### 实验名称

基于银行客户流失数据的超参搜索与特征融合算法实现

### **实验目的**

能独立完成超参数搜索

能完成数据模型融合

### **实验背景**

客户对于银行而言是重要的资产，对银行的收益以及市场占有率起着决定性作用。但是银行每年都要面对严重的客户流失问题，相较留住一个客户，获取一个新客户所需的成本往往是其数倍。因此分析出一个客户是否可能是潜在的易流失客户对于银行而言具有极大价值。

本例收集了国外银行的匿名化数据，包含了信用分数、存贷款情况、性别、年龄等一系列客户信息。大多数银行对于客户流失问题关注度很高，但研究相对较少，目前只有少部分银行开始对真实案例进行建模分析。通过研究客户的历史行为来捕捉流失客户的特点，分析客户流失原因，从而可以在客户真正流失之前做出相应的营销干预，对客户进行挽留。

数据属性包含如下11列。

CreditScore：信用分数

Geography：用户所在国家/地区

Gender：用户性别

Age：年龄

Tenure：当了本银行多少年用户

NumOfProducts：使用产品数量

HasCrCard：是否有本行信用卡

IsActiveMember：是否活跃用户

EstimatedSalary：估计收入

Exited：是否已流失，这将作为我们的标签数据

EB ：Estimated Balance账户预估余额

### **实验原理**

本实验包含一个完整的数据挖掘过程，并提供K折交叉验证和模型融合等方法，模型融合是一种有效的机器学习方法，‌它通过结合多个模型的预测结果来提高预测的准确性和稳定性。‌这种方法的核心在于利用不同模型的优势，‌弥补单个模型的不足。‌模型融合可以从多个角度进行，‌包括但不限于加权融合、‌硬投票、‌软投票、‌集成学习（‌如boosting/bagging）‌以及stacking/blending等方法。‌

*   **加权融合**是通过给每个模型的预测结果分配不同的权重来实现的。‌权重的分配可以根据每个模型在交叉验证中的表现来确定，‌例如，‌如果某个模型的误差较小，‌则可以给它分配较大的权重。‌
*   **硬投票和软投票**主要用于分类问题。‌硬投票是每个模型对每个样本进行类别预测，‌最终结果为出现次数最多的类别；‌软投票则允许每个模型输出一个概率分布，‌最终结果为这些概率分布的加权平均。‌
*   **集成学习**，‌如bagging和boosting，‌通过训练多个模型并将它们的预测结果进行平均或加权平均来提高预测的准确性和稳定性。‌bagging通过对原始数据进行有放回的抽样来训练多个模型，‌而boosting则通过按顺序训练模型，‌并根据前一个模型的错误调整样本权重来训练下一个模型。‌

### 实验环境

Ubuntu 18.04

Python 3.9

jupyter notebook 6.1.0

pandas 2.0.3

sklearn 1.4.1

numpy 1.25.2

### 建议课时

2课时

### 实验步骤

#### 获取数据集

```markup
cd ~
wget http://10.90.3.2/HUP/DataMining/2024/12/final.csv
 
```

在Terminal输入以下命令，启动jupyter：

```markup
jupyter notebook
 
```

在打开的浏览器中新建python3文件:

![01-notebook.png](./pic/01-notebook.png)

#### 加载数据

```python
import pandas as pd
import numpy as np

csv=pd.read_csv("./final.csv")
csv_array=np.array(csv)
csv.head()
```

输出为：

![1721314917457.png](./pic/1721314917457.png)

从输出可以看出，各个字段已经都为数值类型，不需要进行处理。

#### 划分训练集及测试集

首先使用随机划分的方法将数据集按4:1分为训练集和测试集

```python
#首先使用随机划分的方法将数据集按4:1分为训练集和测试集
from sklearn.model_selection import train_test_split
target=csv_array[:,10]
#第1列为编号，对决策树模型无意义，去除，将剩余列作为特征项
feature=csv_array[:,[1,2,3,4,5,6,7,8,9,11]]
feature_train, feature_test, target_train, target_test = train_test_split(feature, target, test_size=0.2, random_state=10)
```

#### 模型快速验证

对数据集进行加载后，首先使用决策树进行银行客户流失预测的分析，将此流失预测的结果作为基准，之后在决策树模型的基础上，与多个常用分类算法调优的结果做比较。

决策树含义直观，容易解释。对于实际应用，决策树有其他算法难以比较的速度优势。因此，对于决策树而言，一方面能够有效地进行大规模数据的处理和学习，另一方面在测试/预测阶段满足实时或者更高的速度要求。

sklearn提供了决策树的训练模型，其使用的是CART算法。CART算法仅生成二叉树，即非叶节点每次生成两个子节点，分别表示符合/不符合该节点的条件。在本例中，需要解决的问题是判断某客户是否为易流失客户，属于分类问题，因此可使用sklean库中的DecisionTreeClassifier来解决该问题。

DecisionTreeClassifier中包括如下主要参数。

（1）criterion：可选值为“gini”或“entropy”，分别表示分裂节点时评价准则为gini指数或信息增益，默认为“gini”。

（2）max\_depth：默认为不输入。如果不输入，决策树在建立子树的时候不会限制子树的深度。一般来说，数据少或特征少的时候可以不考虑这个值。如果模型样本量多，特征也多的情况下，推荐限制这个最大深度，具体的取值取决于数据的分布。若深度过小，决策树可能过于简单而发生欠拟合情况，若深度过大，决策树则越容易过拟合。

（3）splitter：可选值为“best”或“random”，“best”表示分裂时在所有特征中寻找“最优”特征进行分支，“random”则表示选择部分特征中的“最优”特征进行分支，一般在数据量不大时使用“best”。

（4）min\_samples\_split：表示一个节点分裂所需的最少样本数，若样本数小于该值，则不再继续分支。

（5）min\_samples\_leaf：表示一个叶节点所需的最少样本数，若样本数小于该值，则对该叶节点进行剪枝。

设置决策树参数

```python
#设置决策树参数
from sklearn.tree import DecisionTreeClassifier
dt_model = DecisionTreeClassifier(criterion="gini",max_depth=6,min_samples_split=200)
```

以上代码初始化了一个决策树，并设定度量函数为gini系数，树的最大深度为6，一个节点分裂所需的最少样本数为200，若样本数小于该值，则不再继续分支

模型训练并计算得分

```python
dt_model.fit(feature_train,target_train)
scores = dt_model.score(feature_test,target_test)
scores
```

输出为：![1721315551424.png](./pic/1721315551424.png)

从0.788的结果看出，当前决策树的效果还有一些进步空间

预测测试集

```python
predict_results = dt_model.predict(feature_test)#测试集根据决策树的预测结果
predict_results
```

输出为：![1723170839913](pic/1723170839913.png)



#### 绘制ROC曲线

```python
from sklearn.metrics import roc_curve #导入ROC曲线函数
import matplotlib.pyplot as plt #导入作图库
fpr, tpr, thresholds = roc_curve(target_test, predict_results, pos_label=1)
plt.figure(figsize=(10,10))
plt.plot(fpr, tpr, linewidth=2, label = 'ROC curve') #作出ROC曲线
plt.plot([0,1],[0,1],'k--',label='guess')
plt.title("ROC Curve",fontsize=25)
plt.xlabel('False Positive Rate',fontsize=20) #坐标轴标签
plt.ylabel('True Positive Rate',fontsize=20) #坐标轴标签
plt.ylim(0,1.05) #边界范围
plt.xlim(0,1.05) #边界范围
plt.legend(loc=4,fontsize=20) #图例
plt.show() #显示作图结果
```

输出为：

![1721316968376.png](./pic/1721316968376.png)

一般地，ROC曲线下面积在0.5~0.7之间表示诊断价值较低，在0.7~0.9之间表示诊断价值中等，0.9以上表示诊断价值较高。  
ROC曲线越接近左上角，效果越好。若ROC曲线位于对角线下方，说明劣于随机分类结果，这种情况下可考虑将原本二分类结局互换。

从图中可以看出ROC曲线接近左上角，优于随机分类。

#### 绘制混淆矩阵

```python
from sklearn.metrics import confusion_matrix #导入混淆矩阵函数
cm = confusion_matrix(target_test, predict_results) #混淆矩阵
import matplotlib.pyplot as plt #导入作图库
plt.figure(figsize=(10, 10))
plt.matshow(cm, fignum=0,cmap=plt.cm.Blues) 
plt.colorbar() #颜色标签
for x in range(len(cm)): #数据标签
    for y in range(len(cm)):
        plt.annotate(cm[x,y], xy=(x, y),fontsize=30, horizontalalignment='center', verticalalignment='center')
  
plt.ylabel('Hypothesized class',fontsize=20) #坐标轴标签
plt.xlabel('True class',fontsize=20) #坐标轴标签
plt.show()
```

输出为：

![1721316988822.png](./pic/1721316988822.png)

输出混淆矩阵

```python
from sklearn.metrics import confusion_matrix 
confusion_matrix(target_test, predict_results)
```

输出为：

![1721317016655.png](./pic/1721317016655.png)

混淆矩阵中行索引为真实值，列索引为预测值  

左上角为TP(True Positive):实际为正例，预测为正例的数量  

右下角为TN(True Negative):实际为负例，预测为负例的数量  

左下角为FP(False Positive):实际为负例，预测为正例的数量  

右上角为FN(False Negative):实际为正例，预测为负例的数量  

其中T和F代表预测是否正确(T代表预测正确，F代表预测错误)，P和N则代表预测的结果，P代表预测为正例，N代表预测为负例  

将T/F与P/N相结合起来，可计算出如下指标：

PPV(Positive Predictive Value):阳性预测值，等同于精确率，预测为正例，真的正例所占比例。  
PPV=TP/(TP+FP)=precision  
NPV(Negative predictive value):阴性预测值，预测为负例，真的负例所占比例，等同于负例的精确率  
NPV=TN/(TN+FN)  
TPR(True Positive rate):真正例率,等同于正例的召回或灵敏度  
TPR=TP/(TP+FN)=recall=sensitivity  
FPR(False Positive Rate):假正例率,即误诊率（负例中被预测为正例的占全部负例的比例）。  
FPR=FP/(FP+TN)=1-specify (参考混淆矩阵)  
FNR(False Negative Rate):假阴性率，即漏诊率，正例中被预测为负例的占所有正例的比例病检测出没病占真正有病的比例：  
FNR=FN/(TP+FN)=1-sensitivity=1-recall

#### k折交叉验证

10折交叉验证

```python
from sklearn.model_selection import StratifiedKFold
skfold = StratifiedKFold(n_splits=10,shuffle=False)

x_axis=[] ; y_axis=[]
k=0;max=0;min=100;sum=0
for train_index,test_index in skfold.split(feature,target):
    k+=1
    skfold_feature_train=feature[train_index]
    skfold_feature_test=feature[test_index]
    skfold_target_train=target[train_index]
    skfold_target_test=target[test_index]
    dt_model.fit(skfold_feature_train,skfold_target_train)
    scores = dt_model.score(skfold_feature_test,skfold_target_test)
    x_axis.append(k)
    y_axis.append(scores)
    if scores>max:
        max=scores
    if scores<min:
        min=scores
    sum+=scores
avg=sum/k
```

绘制教程验证结果

```python
import matplotlib.pyplot as plt
plt.plot(x_axis,y_axis)
plt.ylim(0.6,0.9)
plt.xlim(1,10)
plt.xlabel("Rounds")
plt.ylabel('True Rate')
plt.title("KFold Cross Validation (k=%s) avg=%s"%(k,round(avg*100,2))+"%"+" max:"+"%s"%(round(max*100,2))+"%"+" min:"+"%s"%(round(min*100,2))+"%")
plt.show()
```

输出为：

![1721317120839.png](./pic/1721317120839.png)

通过多次的交叉验证，可以看到平均的预测准确率为75.82%

#### 模型融合

上面采用决策树对数据进行了完整的预测，现在采用模型融合的方法，增强一下模型的泛化能力。

导入依赖

```python
import sys 
import os
# print("Python version: {}". format(sys.version))
import pandas as pd # 加载csv等表格数据
# print("pandas version: {}". format(pd.__version__))

import matplotlib # 画图
# print("matplotlib version: {}". format(matplotlib.__version__))

import numpy as np #数据运算
# print("NumPy version: {}". format(np.__version__))

import scipy as sp #高级数学运算
# print("SciPy version: {}". format(sp.__version__)) 

import IPython
from IPython import display #美化DataFrame的输出


import sklearn #机器学习算法
# print("scikit-learn version: {}". format(sklearn.__version__))

#基础库
import random
import time


#忽略警告
import warnings
warnings.filterwarnings('ignore')
print('-'*25)


# 常见机器学习算法
from sklearn import svm, tree, linear_model, neighbors, naive_bayes, ensemble, discriminant_analysis, gaussian_process
#from xgboost import XGBClassifier

from sklearn import datasets

# 常见函数
from sklearn.preprocessing import OneHotEncoder, LabelEncoder
from sklearn import feature_selection
from sklearn import model_selection
from sklearn import metrics

#可视化
import matplotlib as mpl
import matplotlib.pyplot as plt
import matplotlib.pylab as pylab
import seaborn as sns
from pandas.plotting import scatter_matrix

#配置可视化
%matplotlib inline
mpl.style.use('ggplot')
sns.set_style('white')
pylab.rcParams['figure.figsize'] = 12,8
```

实例化多个分类器

为了实验可以快速的进行，在构建的分类器列表中，注释了部分分类器，用户可以自行取分类器列表中的分类器，从而实现选择不同的分类器进行模型融合。

```python
# 实例化多个分类器
MLA = [
    #集成方法
    ensemble.AdaBoostClassifier(),
    
    #非线性分类器 时间比较慢 给注释掉了，可以自行取消注释看
    #linear_model.LogisticRegressionCV(),
    #linear_model.SGDClassifier(),
    #linear_model.Perceptron(),
    
    #贝叶斯
    naive_bayes.GaussianNB(),
    
    #KNN算法
    neighbors.KNeighborsClassifier(),
    
    #支持向量机-SVM
    svm.LinearSVC(),
    
    #决策树模型    
    tree.DecisionTreeClassifier(),
    # tree.ExtraTreeClassifier(),
    
    #xgboost: http://xgboost.readthedocs.io/en/latest/model.html
    #XGBClassifier()    
    ]
```

上面代码中，把多个模型封装进一个列表中，模型融合将通过多个模型对数据集进行预测，并通过投票的方式确定最终的结果，从而增加模型的泛化性。

拆分数据集和设定保存机器学习指标的列表，

MLA  Name表示分类器名称 

MLA  Train Accuracy Mean表示分类器的平均训练集准确性

MLA  Test Accuracy Mean表示分类器的平均测试集准确性

MLA  Test Accuracy 3\*STD 表示分类器的测试集准确性的标准差\*3

MLA Time表示当前分类器的平均预测时间

基于上面的几个指标，构建一个DataFrame，变量为MLA\_compare

```python
# 用60%的数据训练模型，30%的数据进行验证，故意留出10%的数据不参与，重复这个过程10次
cv_split = model_selection.ShuffleSplit(n_splits = 10, test_size = .3, train_size = .6, random_state = 0 ) 

# 创建一个表格来比较机器学习算法的指标
MLA_columns = ['MLA Name', 'MLA Parameters','MLA Train Accuracy Mean', 'MLA Test Accuracy Mean', 'MLA Test Accuracy 3*STD' ,'MLA Time']
MLA_compare = pd.DataFrame(columns = MLA_columns)
MLA_compare

#c创建一个表格来比较机器学习算法的预测
# train['pred']=-1
MLA_predict={}
MLA_predict['true'] = target_train
```

实验多个模型对数据集进行预测

```python
# 遍历机器学习算法 (MLA) 并将性能保存到表格中
row_index = 0
for alg in MLA:

    # 设置名字和参数
    MLA_name = alg.__class__.__name__
    print(MLA_name)
    MLA_compare.loc[row_index, 'MLA Name'] = MLA_name
    MLA_compare.loc[row_index, 'MLA Parameters'] = str(alg.get_params())
    cv_results = model_selection.cross_validate(alg, 
                 feature_train,target_train, cv  = cv_split,return_train_score=True)

    MLA_compare.loc[row_index, 'MLA Time'] = cv_results['fit_time'].mean()
    MLA_compare.loc[row_index, 'MLA Train Accuracy Mean'] = cv_results['train_score'].mean()
    MLA_compare.loc[row_index, 'MLA Test Accuracy Mean'] = cv_results['test_score'].mean()   
    #如果这是一个无偏的随机样本，那么从平均值上下三个标准差（+/-3 std）应该统计上捕获99.7%的子集
    MLA_compare.loc[row_index, 'MLA Test Accuracy 3*STD'] = cv_results['test_score'].std()*3   #let's know the worst that can happen!
    

    #存机器学习算法（MLA）的预测结果
    alg.fit(feature_train,target_train)
    MLA_predict[MLA_name] = alg.predict(feature_train)
    
    row_index+=1
```

上面代码先遍历分类器列表，并基于每个分类器进行交叉验证，获取训练集准确性，测试集准确性等参数，并且存入MLA\_compare变量代表的DataFrame中

输出为：

![1723170108712](pic/1723170108712.png)

为了实验可以快速的进行，在构建的分类器列表中，注释了部分分类器，用户可以自行取分类器列表中的分类器，从而实现选择不同的分类器进行模型融合。所以这里的截图可能针对选择的分类器不同，有所不同。

对预测结果进行排序，并进行可视化操作

```python
# 对预测结果的准确度进行排序 
MLA_compare.sort_values(by = ['MLA Test Accuracy Mean'], ascending = False, inplace = True)


#柱状图  https://seaborn.pydata.org/generated/seaborn.barplot.html
sns.barplot(x='MLA Test Accuracy Mean', y = 'MLA Name', data = MLA_compare, color = 'm')

#pyplot 美化: https://matplotlib.org/api/pyplot_api.html
plt.title('Machine Learning Algorithm Accuracy Score \n')
plt.xlabel('Accuracy Score (%)')
plt.ylabel('Algorithm')
plt.show()
```

输出为：

![1723170339561](pic/1723170339561.png)



可以看到集成学习算法AdaBoost分类器效果最佳。

构建一个模型融合的投票模型，并根据多个模型的多数投票进行结果预测，代码如下：

```python

# 构建一个模型融合的多数投票模型

vote_est = [
    #Ensemble Methods: http://scikit-learn.org/stable/modules/ensemble.html
    ('ada', ensemble.AdaBoostClassifier()),
    
    #GLM: http://scikit-learn.org/stable/modules/linear_model.html#logistic-regression
    #('lr', linear_model.LogisticRegressionCV()),
    
    #Navies Bayes: http://scikit-learn.org/stable/modules/naive_bayes.html
    # ('bnb', naive_bayes.BernoulliNB()),
    ('gnb', naive_bayes.GaussianNB()),
    
    #Nearest Neighbor: http://scikit-learn.org/stable/modules/neighbors.html
    ('knn', neighbors.KNeighborsClassifier()),
    
    #SVM: http://scikit-learn.org/stable/modules/svm.html
    ('svc', svm.SVC(probability=True)),

]

#多数投票
vote_hard = ensemble.VotingClassifier(estimators = vote_est , voting = 'hard')
vote_hard_cv = model_selection.cross_validate(vote_hard, feature_train,target_train, cv  = cv_split,return_train_score=True)
vote_hard.fit(feature_train,target_train)

print("vote_hard.predict(iris.data)\n",vote_hard.predict(feature_train))

print("vote_hard_cv\n")
for k,v in vote_hard_cv.items():
    print(k," ",v)

print("Hard Voting Training w/bin score mean: {:.2f}". format(vote_hard_cv['train_score'].mean()*100)) 
print("Hard Voting Test w/bin score mean: {:.2f}". format(vote_hard_cv['test_score'].mean()*100))
print("Hard Voting Test w/bin score 3*std: +/- {:.2f}". format(vote_hard_cv['test_score'].std()*100*3))
print('-'*10)
```

输出为：

![1723170407835](pic/1723170407835.png)



上面的代码，通过ensemble.VotingClassifier把多个分类器组合成一个模型融合的集成分类器，采用投票进行结果的预测。这里运行的结果每次都会有所不同，具体结果根据运行结果进行阐述说明。

从本结果可以看出，预测集的准确性均值为70.57，测试集的准确性均值为67.16，测试集的准确性标准差为6.93，从结果可以看出，没有明显提升，可以减少弱分类器，增加集成学习等分类器的作为基础分类器，来增加模型融合的效果。

### **实验总结**

通过本次试验，巩固所学知识：掌握超参数调优的方法，模型融合的方法，并可以对比多个模型的效果 。同时也对银行客户流失数据进行了进一步的分析。