### 实验名称

建立一个卷积神经网络对图片分类

### **实验目的**

1.掌握卷积神经网络的构建方法。

2.掌握通过卷积神经网络对CIFAR10数据集进行分类的方法。

### **实验原理**

卷积神经网络是目前深度学习技术领域中非常具有代表性的神经网络之一，在图像分析和处理领域取得了众多突破性的进展，在学术界常用的标准图像标注集ImageNet上，基于卷积神经网络取得了很多成就，包括图像特征提取分类、场景识别等。卷积神经网络相较于传统的图像处理算法的优点之一在于避免了对图像复杂的前期预处理过程，尤其是人工参与图像预处理过程，卷积神经网络可以直接输入原始图像进行一系列工作，至今己经广泛应用于各类图像相关的应用中。

本实验使用了3个卷积层的同卷积操作，卷积核（kenel）为3×3，前两个卷积层后面都会跟个步长为2×2的池化层，滤波器为2×2。第三个卷积之后，连接一个展平层，再连接两个全连接层，最后输出10个分类。

### **实验环境**

Ubuntu 18.04

Python 3.9

Numpy 1.18.3

Tensorflow-gpu 2.10

### **建议课时**

2课时

### **实验步骤**

#### 1、下载并准备 CIFAR10 数据集

打开Linux终端，下载数据集

```markup
wget http://10.90.3.2/HUP/DataMining/2023/10/cifar-10-batches-py.tar.gz
```

创建keras数据文件夹，在终端输入以下命令

```markup
mkdir -p .keras/datasets
```

将数据集复制到keras数据文件夹

```markup
cp cifar-10-batches-py.tar.gz .keras/datasets
```

CIFAR10 数据集包含 10 类，共 60000 张彩色图片，每类图片有 6000 张。此数据集中 50000 个样例被作为训练集，剩余 10000 个样例作为测试集。类之间相互独立，不存在重叠的部分。

在终端输入以下代码，启动jupyter notebook开发环境：

```markup
jupyter notebook
```

![微信图片_20230731154922.png](./pic/微信图片_20230731154922.png)

接着，程序会通过浏览器打开jupyter notebook开发环境，我们在“New”选项下，点击“Python3”，会新建一个“Untitled.ipynb”文件。按以下步骤依次输入代码到代码框内，完成相应步骤。

#### 2、安装tensorflow-gpu并加载相关模块

```python
pip install tensorflow-gpu==2.10 -i https://pypi.tuna.tsinghua.edu.cn/simple/
```

进入jupyter工具编写以下代码

```python
import tensorflow as tf
from tensorflow.keras import datasets, layers, models
import matplotlib.pyplot as plt
# ~/.keras/datasets/cifar-10-batches-py.tar.gz
(train_images, train_labels), (test_images, test_labels) = datasets.cifar10.load_data()

# Normalize pixel values to be between 0 and 1
train_images, test_images = train_images / 255.0, test_images / 255.0
```

#### 3、加载并验证数据

为了验证数据集看起来是否正确，我们绘制训练集中的前 25 张图像并在每张图像下方显示类名称：

```python
class_names = ['airplane', 'automobile', 'bird', 'cat', 'deer',
               'dog', 'frog', 'horse', 'ship', 'truck']

plt.figure(figsize=(10,10))
for i in range(25):
    plt.subplot(5,5,i+1)
    plt.xticks([])
    plt.yticks([])
    plt.grid(False)
    plt.imshow(train_images[i])
    # The CIFAR labels happen to be arrays, 
    # which is why you need the extra index
    plt.xlabel(class_names[train_labels[i][0]])
plt.show()
```

![image-20230603125448745.png](./pic/image-20230603125448745.png)

#### 4、构造卷积神经网络模型

下方展示的 6 行代码声明了了一个常见卷积神经网络，由几个 Conv2D 和 MaxPooling2D 层组成。

CNN 将形状为 (image\_height, image\_width, color\_channels) 的张量作为输入，忽略批次大小。如果您不熟悉这些维度，color\_channels 是指 (R,G,B)。在此示例中，您将配置 CNN 以处理形状为 (32, 32, 3) 的输入，即 CIFAR 图像的格式。您可以通过将参数 `input_shape` 传递给第一层来实现此目的。

```python
model = models.Sequential()
model.add(layers.Conv2D(32, (3, 3), activation='relu', input_shape=(32, 32, 3)))
model.add(layers.MaxPooling2D((2, 2)))
model.add(layers.Conv2D(64, (3, 3), activation='relu'))
model.add(layers.MaxPooling2D((2, 2)))
model.add(layers.Conv2D(64, (3, 3), activation='relu'))
```

模型的架构如下：

```python
model.summary()
```

![image-20230603130138553.png](./pic/image-20230603130138553.png)

在上面的结构中，您可以看到每个 Conv2D 和 MaxPooling2D 层的输出都是一个三维的张量 (Tensor)，其形状描述了 (height, width, channels)。越深的层中，宽度和高度都会收缩。每个 Conv2D 层输出的通道数量 (channels) 取决于声明层时的第一个参数（如：上面代码中的 32 或 64）。这样，由于宽度和高度的收缩，您便可以（从运算的角度）增加每个 Conv2D 层输出的通道数量 (channels)。

#### 5、增加 Dense 层

为了完成模型，您需要将卷积（形状为 (4, 4, 64)）的最后一个输出张量馈送到一个或多个 Dense 层以执行分类。Dense 层将向量作为输入（即 1 维），而当前输出为 3 维张量。首先，将 3 维输出展平（或展开）为 1 维，然后在顶部添加一个或多个 Dense 层。CIFAR 有 10 个输出类，因此使用具有 10 个输出的最终 Dense 层。

```python
model.add(layers.Flatten())
model.add(layers.Dense(64, activation='relu'))
model.add(layers.Dense(10))
```

模型的完整架构：

```python
model.summary()
```

![image-20230603130109410.png](./pic/image-20230603130109410.png)

网络摘要显示 (4, 4, 64) 输出在经过两个 Dense 层之前被展平为形状为 (1024) 的向量。

#### 6、编译并训练模型

```python
model.compile(optimizer='adam',
              loss=tf.keras.losses.SparseCategoricalCrossentropy(from_logits=True),
              metrics=['accuracy'])

history = model.fit(train_images, train_labels, epochs=10, 
                    validation_data=(test_images, test_labels))
```

![image-20240725005547211](pic/image-20240725005547211.png)

#### 7、评估模型

```python
plt.plot(history.history['accuracy'], label='accuracy')
plt.plot(history.history['val_accuracy'], label = 'val_accuracy')
plt.xlabel('Epoch')
plt.ylabel('Accuracy')
plt.ylim([0.5, 1])
plt.legend(loc='lower right')
plt.show()

test_loss, test_acc = model.evaluate(test_images,  test_labels, verbose=2)
```

![image-20240725005609861](pic/image-20240725005609861.png)

```python
print(test_acc)
```

输入结果：0.709100028



### 实验总结

简单 CNN 的测试准确率已达到 70% 以上。对于只有几行的代码来说，效果不错！对于另一种 CNN 风格，请参阅\[适合专家的 TensorFlow 2 快速入门\]示例，此示例使用了 Keras 子类化 API 和 tf.GradientTape。