﻿### 实验名称﻿

Surprise构建推荐系统

### 实验目的

1.了解Surprise库的基本使用

2.基于Surprise库实现推荐系统

### 实验背景

Surprise（Simple Python Recommendation System  Engine）是scikit系列中的一个，也是一个推荐系统库，简单易用，提供了如基线算法，邻域方法，基于矩阵因子分解（SVD，PMF，SVD  ++，NMF）等各种即用型预测算法。此外，内置了各种相似性度量（余弦，MSD，皮尔逊）。本实验使用Surprise实现一个推荐系统。

### 实验原理

奇异值分解(Singular Value  Decomposition，以下简称SVD)是在机器学习领域广泛应用的算法，它不光可以用于降维算法中的特征分解，还可以用于推荐系统，以及自然语言处理等领域。是很多机器学习算法的基石。本实验主要基于SVD实现一个推荐系统。

### 实验环境

Ubuntu16.04

Python3.6

Surprise1.1.1

### 建议课时

2课时

### 实验步骤

#### STEP0：开发环境配置：

下载数据集

```markup
cd
wget http://i9000.net:8888/sgn/HUP/DataMining/6/surprisedata.zip
unzip -o surprisedata.zip -d /home/ubuntu/
```

安装机器学习库

安装机器学习库

```markup
pip install scikit-surprise
```

打开pycharm开发环境

![pic/pycharm启动0.png](pic/pycharm启动0.png)

新建工程

![pic/pycharm启动1.jpg](pic/pycharm启动1.jpg)

在接下来的界面中，为项目命名为recom，并且勾选"Existing Interpreter"，然后点击"Create"按钮

![image-20240724220514616](pic/image-20240724220514616.png)

创建python文件：右键"Recommend"项目名称，然后选择"New" - "Python File"，如下图所示：

![image-20240724220644315](pic/image-20240724220644315.png)

#### STEP1：导入库

导入surprise库中的算法，数据集，网格搜索。

```python
# 导入库
from surprise import SVD
from surprise import Dataset
from surprise import Reader
from surprise.model_selection import GridSearchCV
import os
```

#### STEP2：加载数据集

加载movielens-100K数据集，默认在线下载数据集，也可以加载本地数据

```python
# 加载 movielens-100K
# 定义推荐数据集文件路径
file_path = '/home/ubuntu/u.data'
# 指定分隔符
reader = Reader(line_format='user item rating timestamp', sep='\t')
# 导入文件
data = Dataset.load_from_file(file_path, reader=reader)
```

####  STEP3：网格搜索

设置网格搜索参数

```python
# 网格搜索
param_grid = {'n_epochs': [5, 10], 'lr_all': [0.002, 0.005],
              'reg_all': [0.4, 0.6]}
gs = GridSearchCV(SVD, param_grid, measures=['rmse', 'mae'], cv=3)
```

#### STEP4：训练并获得最佳模型

```python
# 训练模型
gs.fit(data)
# 输出最佳RMSE（均方根误差）得分
print('The best RMSE：',gs.best_score['rmse'])
# 输出最佳RMSE得分的参数组合
print('The best params：',gs.best_params['rmse']) 
# 获得最佳算法
algo = gs.best_estimator['rmse']
algo.fit(data.build_full_trainset())
```

#### STEP5：模型预测

```python
# 模型预测
uid = str(196)  # 原始user id (在评分文件中的)
iid = str(302)  # 原始item id （在评分文件中的）
#对某一个具体的user和item给出预测
pred = algo.predict(uid, iid, r_ui=4, verbose=True)
```

#### STEP6：输出结果解释

```python
The best RMSE 0.9629441271618542
The best params {'n_epochs': 10, 'lr_all': 0.005, 'reg_all': 0.4}
user: 196        item: 302        r_ui = 4.00   est = 4.02   {'was_impossible': False}
# 说明：user为用户id，item为项目id，r_ui为真实评分，est为预测评分
```

### 实验总结

本实验基于Surprise构建了推荐系统，采用的算法为SVD。完成本实验后，就对一个完整的推荐系统使用有了基本的理解，用户也可以自定义数据集，并训练自己的推荐系统模型。