### 实验名称

Apriori算法的应用案例：Mlxtend构建购物篮分析

### 实验目的

本实验我们将使用mlxtend模块来完成一个基于apriori算法的关联规则挖掘的购物篮分析案例。

### 实验背景

数据来源于天池大数据实验室，包含一个体育用品连锁商店的60398件商品的销售记录表，表中每一行记录一件商品的销售日期、客户ID、商品名称等字段。该数据集是基于关系模型建立的二维表，这与关联规则挖掘所需的项集数据不一致，本节将介绍如何将关系表数据转换为基于交易事务的商品项集数据，并使用Apriori算法进行关联规则挖掘，找到具有强关联关系的商品规则，对商店销售策略提供数据支持。

### 实验原理

关联规则 (Association Rules，又称 Basket Analysis) 是形如X→Y的蕴涵式，其中， X和Y分别称为关联规则的先导(antecedent或left-hand-side, LHS)和后继(consequent或right-hand-side, RHS) 。在这当中，关联规则X→Y，利用其支持度和置信度从大量数据中挖掘出有价值的数据项之间的相关关系。

关联规则挖掘过程主要包含两个阶段：第一阶段必须先从资料集合中找出所有的频繁项集(Frequent Itemsets)，第二阶段再由这些高频项目组中产生强关联规则(Association Rules)。

mlxtend.frequent\_patterns是mlxtend库中的一个模块，用于在关联规则挖掘中寻找频繁项集。频繁项集是指在一组事务中经常同时出现的项集，是关联规则挖掘的基础。在mlxtend.frequent\_patterns模块中，提供了几种算法用于发现频繁项集，包括Apriori算法和FP-growth算法。

使用mlxtend.frequent\_patterns模块，可以进行以下关联规则挖掘的任务：

1.  频繁项集挖掘：通过设定最小支持度阈值，可以找到频繁项集，即在数据集中经常同时出现的项集。
2.  关联规则生成：基于频繁项集，可以生成关联规则。关联规则是指描述项集之间关联性的规则，它们可以用来发现数据中的有趣模式。
3.  关联规则评估：通过计算关联规则的置信度，可以对关联规则进行评估和排序。置信度表示规则中结论在给定条件下的出现概率，可以用来衡量规则的可靠程度。

mlxtend.frequent\_patterns模块提供了一些方便的函数和类来实现以上功能，如apriori和association\_rules函数。这些函数可以根据数据集和设定的阈值，快速发现频繁项集和强关联规则。

### 实验环境

Ubuntu18.04

Python 3.9

pandas 1.3.5

mlxtend 0.19.0

### 建议课时

1课时

### 实验步骤

#### 1、环境准备

下载数据源

```markup
mkdir ~/data/
wget http://10.90.3.2/HUP/DataMining/2023/06-2/order.csv -P ~/data/

```

安装mlxtend库

打开一个终端，在命令行提示符后输入下列命令从线上文件服务器下载数据文件：

```shell
pip install mlxtend

```

运行Jupyter notebook

```shell
jupyter notebook

```

结果如下图所示：

![6-1-1](./pic/6-1-1)

新建python文件，结果如下图所示：

![6-1-2](./pic/6-1-2)

#### 2、数据预处理

（1）对数据的分析处理从数据导入开始，使用pandas将商品销售记录表文件中的数据导入：

```python
import pandas as pd

# 读取订单表数据
order=pd.read_csv('./data/order.csv', encoding = 'gb2312')
# 查看订单表数据
order.tail()

```

![img](./pic/img)

（2）为了进一步应用mlxtend提供的apriori算法函数，需要将表格数据整理成交易项集数据：

```python
from collections import defaultdict

# 将订单表格数据整理成订单商品列表
order_list=order.to_dict(orient='records')
transactions=defaultdict(list)

# 以日期和客户ID作为一笔交易的标识，将同一客户在同一天购买的商品添加到一组列表
for order in order_list:
    transactions[order['订单日期']+"-"+order['客户ID']].append(order["产品名称"])

transaction_list = list(transactions.values())
transaction_list 
```

![img](./pic/img)

（3）Mlxtend提供了一个预处理器TransactionEncoder，可以将交易项集列表数据转换成One-Hot编码的矩阵，以便在后续步骤中快速计算项集的支持度。

```python
from mlxtend.preprocessing import TransactionEncoder

# mlxtend.preprocessing提供了一个TransactionEncoder，用以将交易商品列表数据转换为One-Hot编码的数组
te = TransactionEncoder()
array_onehot_dataset = te.fit_transform(transaction_list)

# 项目名称存储在编码器对象的columns_属性中
item_names = te.columns_
# 将one-hot数组转换成一个DataFrame对象
df_onehot_dataset = pd.DataFrame(array_onehot_dataset, columns=item_names)

df_onehot_dataset

```

![img](./pic/img)

#### 3、Apriori提取频繁项集

导入mlxtend.frequent\_patterns.apriori函数，该函数会基于One-Hot编码的交易数据集计算项集的支持度，并根据指定的最小支持度阈值(min\_support)来筛选频繁项集：

```markup
from mlxtend.frequent_patterns import apriori

# 使用mlxtend提供的apriori方法生成频繁项集，使用最小支持度阈值来过滤频繁项集
frequent_itemsets=apriori(df_onehot_dataset,min_support=0.03,use_colnames=True)

# 根据支持度高低进行排序并显示支持度最高的项集
frequent_itemsets.sort_values("support",ascending=False).head()

```

![img](./pic/img)

#### 4、提取强关联规则

导入mlxtend.frequent\_patterns.association\_rules函数，该函数会基于找到的频繁项集组合出关联规则，并且根据给定的评估条件（如最小置信度阈值）来筛选强关联规则，同时会给出多项评估指标，如：support、confidence、lift、leverage、conviction和zhangs\_metric等，这些评估指标可以帮助我们理解关联规则的相关性和可信度，从而找到有意义和有用的规则。

```python
from mlxtend.frequent_patterns import association_rules

# 使用mlxtend提供的association_rules方法来从频繁项集中组合出关联规则，使用最小置信度阈值来过滤强规则
rules=association_rules(frequent_itemsets,metric='confidence',min_threshold=0.2)

rules

```

![img](./pic/img)

根据各项评估指标，对得到的强关联规则进行进一步的筛选：

```python
# 过滤出兴趣度大于等于1的强规则
rules = rules[rules['lift']>=1]  

# 按置信度高低排序
rules = rules.sort_values('confidence',ascending=False)

# 重新对规则进行编号
rules.reset_index(inplace=True)

rules

```

![img](./pic/img)

最终得到的强关联规则：

```python
# 依次打印强关联规则
for idx,rule in rules.iterrows():
  print("关联规则%02d" % idx,
        set(rule['antecedents']),"->",set(rule['consequents']),
        "支持度：",round(rule['support'],2),
        "置信度：",round(rule['confidence'],2))

```

![img](./pic/img)

### 实验总结

本实验通过案例学习了关联规则挖掘的一般过程，包括从数据集的构造与处理，频繁项集的提取和关联规则的提取三个主要部分。通过本实验可以掌握mlxtend库中对于关联规则推荐的相关函数，并了解了多种关联规则的评估指标。