/**
 * @author  MIoT
 * @date    2019
 * @par     Copyright (c):
 *
 *    Copyright 2019 MIoT,MI
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
#include "delay.h"
#include <stdint.h>
static uint8_t  systime_us = 0;							
static uint16_t systime_ms = 0;							


void delay_init()
{

	systick_clksource_set(SYSTICK_CLKSOURCE_HCLK_DIV8);	
	systime_us = SystemCoreClock / 25000000;				
	systime_ms = (uint16_t)systime_us * 1000;					

}								    
	    								   
void delay_us(uint32_t num_us)
{		
	uint32_t temp;	    	 
	SysTick->LOAD = num_us*systime_us; 					
	SysTick->VAL = 0x00;        					
	SysTick->CTRL |= SysTick_CTRL_ENABLE_Msk ;	
	do
	{
		temp = SysTick->CTRL;
	}while((temp & 0x01) && !(temp & (1 << 16)));		
	SysTick->CTRL &= ~SysTick_CTRL_ENABLE_Msk;	
	SysTick->VAL = 0X00;      					
}

void delay_ms(uint16_t num_ms)
{	 		  	  
	uint32_t temp;		   
	SysTick->LOAD = (uint32_t)num_ms*systime_ms;				
	SysTick->VAL = 0x00;							
	SysTick->CTRL |= SysTick_CTRL_ENABLE_Msk ;	
	do
	{
		temp = SysTick->CTRL;
	}while((temp & 0x01) && !(temp & (1 << 16)));		
	SysTick->CTRL &= ~SysTick_CTRL_ENABLE_Msk;	
	SysTick->VAL = 0X00;       					
} 









































