/*!
    \file  i2c_test.h
    \brief the header file of I2C
*/



#ifndef I2C_TEST_H
#define I2C_TEST_H

#include "gd32f4xx.h"

#define GD32F330_ADDRESS_S6    	0x58
#define	GD32F330_READ_CMD				0xAA

#define PASSWORD_ADDRESS    0x08040000


#define SWN         0xFF
#define SW1         0x01
#define SW2         0x02
#define SW3         0x03
#define SW4         0x04
#define SW5         0x05
#define SW6         0x06
#define SW7         0x07
#define SW8         0x08
#define SW9         0x09
#define SWA         '*'
#define SW0         0x00
#define SWC         '#'



#define   PS_INIT_STATUS    0
#define   PS_VERY_STATUS    1
#define   PS_SEL_STATUS     2
#define   PS_SET_STATUS     3
#define   PS_CTL_STATUS     4



typedef struct
{
	  uint8_t password_ok_flag;
	  uint8_t display_data[10];
	  uint8_t password_value[8];
	  uint16_t valid_time;
	  uint8_t display_pos;
	  uint16_t start_count;
	  uint8_t  status;
}pass_t;





//I2C address struct
typedef struct
{
	  uint8_t flag;
	  uint32_t periph;
	  uint8_t addr;
} i2c_addr_def;


typedef struct
{
	  uint8_t func_set;
	  uint16_t level_set;
} message_def;

enum func_key
{	
     LED_FUNC, 
     NIXIE_TUBE_FUNC,
	   CURTAN_FUNC,
	   EFAN_FUNC,
	   NFC_FUNC,
	   OUTPUT_FUNC
};





extern i2c_addr_def e1_nixie_tube_addr;
extern i2c_addr_def e1_rgb_led_addr;
extern i2c_addr_def e2_fan_addr;
extern i2c_addr_def e3_curtain_addr;
extern i2c_addr_def s1_key_addr;
extern i2c_addr_def s5_nfc_addr;
extern i2c_addr_def s6_ult_addr;
extern i2c_addr_def s7_ir_addr;

void save_password_value(void);
void read_password_value(void);
void Ultra_Data_test(void);
void led_number_display(void);
void pc9685_rgb_led_control(uint32_t i2c_periph,uint8_t i2c_addr,uint8_t num);
void pc9685_motor_control(uint32_t i2c_periph,uint8_t i2c_addr,uint8_t num);
void e3_curtain_init(uint32_t i2c_periph,uint8_t i2c_addr);
void i2c_addr_init(void);
void i2c_test(void);
void i2c_task(void * pvParameters);
void init_pass_set(void);
void con_rgb_led(uint8_t on);

#endif  /* I2C_TEST_H */
