#include "i2c.h"
#include "i2c_test.h"
#include <stdio.h>
#include <string.h>


#include "ht16k33.h"
#include "ms523.h"
#include "pca9685.h"
#include "pca9557.h"




//Each sub board I2C address
i2c_addr_def e1_nixie_tube_addr;
i2c_addr_def e1_rgb_led_addr;













/*!
    \brief      nixie tube display,display 1234
    \param[in]  none
    \param[out] none
    \retval     none
*/
void led_number_display(void)
{
	  //ht16k33_display_data(e1_nixie_tube_addr.periph,e1_nixie_tube_addr.addr,1,mode);
	  //ht16k33_display_data(e1_nixie_tube_addr.periph,e1_nixie_tube_addr.addr,2,2);
	  //ht16k33_display_data(e1_nixie_tube_addr.periph,e1_nixie_tube_addr.addr,3,3);
	  //ht16k33_display_data(e1_nixie_tube_addr.periph,e1_nixie_tube_addr.addr,4,4);
	  //ht16k33_display_data(e1_nixie_tube_addr.periph,e1_nixie_tube_addr.addr,1,pass_set.display_data[0]);
	  //ht16k33_display_data(e1_nixie_tube_addr.periph,e1_nixie_tube_addr.addr,2,pass_set.display_data[1]);
	  //ht16k33_display_data(e1_nixie_tube_addr.periph,e1_nixie_tube_addr.addr,3,pass_set.display_data[2]);
	  //ht16k33_display_data(e1_nixie_tube_addr.periph,e1_nixie_tube_addr.addr,4,pass_set.display_data[3]);
}


/*!
    \brief      rgb led display
    \param[in]  i2c_periph,I2C0 or I2C1
		\param[in]  i2c_addr, e1 rgb led i2c address
	  \param[in]  num,1:Warm white;2:White;3:Cold white
    \param[out] none
    \retval     none
*/

void pc9685_rgb_led_control(uint32_t i2c_periph,uint8_t i2c_addr,uint8_t num)
{	
		
		switch(num)
		{
		case 0:
			setPWM_off(i2c_periph,i2c_addr);
			break;
		case 1:
			setPWM(i2c_periph,i2c_addr,0,0x0000,0x0010);
			setPWM(i2c_periph,i2c_addr,1,0x0199,0x0C00);
			setPWM(i2c_periph,i2c_addr,2,0x0000,0x0010);
			break;
		case 2:
			setPWM(i2c_periph,i2c_addr,0,0x0199,0x0800);
			setPWM(i2c_periph,i2c_addr,1,0x0199,0x0800);
			setPWM(i2c_periph,i2c_addr,2,0x0000,0x0010);
			break;		
		case 3:
			setPWM(i2c_periph,i2c_addr,0,0x0000,0x0010);
			setPWM(i2c_periph,i2c_addr,1,0x0000,0x0010);
			setPWM(i2c_periph,i2c_addr,2,0x0199,0x0C00);
			break;  
		default:
			setPWM_off(i2c_periph,i2c_addr);
			break;
		}
}

void con_rgb_led(uint8_t on)
{
	   if(on)
		  pc9685_rgb_led_control(e1_rgb_led_addr.periph,e1_rgb_led_addr.addr,2);
     else
      pc9685_rgb_led_control(e1_rgb_led_addr.periph,e1_rgb_led_addr.addr,0);			 
}
/*********************************************************************************************
*函数名:    i2c_addr_init
*功能:      确定I2C器件地址
*入口参数:  无
*出口参数： 无
*返回值：   无
*作者：     ZZZ
*日期:      2023/3/7
**********************************************************************************************/
void i2c_addr_init(void)
{
	uint8_t i;
	
	e1_rgb_led_addr.flag = 0;
	for(i=0;i<4;i++)
	{
			if(i2c_addr_poll(I2C0,PCA9685_ADDRESS_E1+i*2))
			{
					e1_rgb_led_addr.periph = I2C0;
					e1_rgb_led_addr.addr = PCA9685_ADDRESS_E1+i*2;
					e1_rgb_led_addr.flag = 1;			
					break;
			}	
	}
	//address not read
	if(e1_rgb_led_addr.flag != 1)
	{			
			//poll I2C1,Verti1
			for(i=0;i<4;i++)
			{
					if(i2c_addr_poll(I2C1,PCA9685_ADDRESS_E1+i*2))
					{
							e1_rgb_led_addr.periph = I2C1;
							e1_rgb_led_addr.addr = PCA9685_ADDRESS_E1+i*2;
							e1_rgb_led_addr.flag = 1;
							break;
					}	
			}
	}
	//read successful
	if(e1_rgb_led_addr.flag)
	{
			//init E1 rgb led
			pc9685_init(e1_rgb_led_addr.periph,e1_rgb_led_addr.addr);
	}
	
	//E1 NIXIE TUBE I2C address init
	//poll I2C0,Horizontal
	e1_nixie_tube_addr.flag = 0;
	for(i=0;i<4;i++)
	{
			if(i2c_addr_poll(I2C0,HT16K33_ADDRESS_E1+i*2))
			{
					e1_nixie_tube_addr.periph = I2C0;
					e1_nixie_tube_addr.addr = HT16K33_ADDRESS_E1+i*2;
					e1_nixie_tube_addr.flag = 1;
					break;
			}	
	}
	//address not read
	if(e1_nixie_tube_addr.flag != 1)
	{	
			//poll I2C1,Verti1
			for(i=0;i<4;i++)
			{
					if(i2c_addr_poll(I2C1,HT16K33_ADDRESS_E1+i*2))
					{
							e1_nixie_tube_addr.periph = I2C1;
							e1_nixie_tube_addr.addr = HT16K33_ADDRESS_E1+i*2;
							e1_nixie_tube_addr.flag = 1;
							break;
					}	
			}
	}
	//read successful
	if(e1_nixie_tube_addr.flag)
	{
			// init E1 nixie tube
			ht16k33_init(e1_nixie_tube_addr.periph,e1_nixie_tube_addr.addr);
	}
	
 
}





