/**
* Copyright (C) 2013-2015
*
* @file   S_2_Light_doAction.c
*
* @remark
*
*/

#include "S_2_Light_doAction.h"
#include "operation_code.h"
#include "iid.h"

static operation_code_t A_2_1_Toggle()
{
    // TODO: 在这里执行真正的Action操作

    return OPERATION_OK;
}

static operation_code_t A_2_2_GetAwakeConfig(int *out_gradualDuration, int *out_gradualEndPointBrightness, int *out_gradualStartPointBrightness)
{
    // TODO: 在这里执行真正的Action操作

    return OPERATION_OK;
}

static operation_code_t A_2_3_SetAwakeConfig(int in_gradualDuration, int in_gradualEndPointBrightness, int in_gradualStartPointBrightness)
{
    // TODO: 在这里执行真正的Action操作

    return OPERATION_OK;
}

static operation_code_t A_2_4_GetAsleepConfig(int *out_gradualDuration, int *out_gradualEndPointBrightness, int *out_gradualStartPointBrightness)
{
    // TODO: 在这里执行真正的Action操作

    return OPERATION_OK;
}

static operation_code_t A_2_5_SetAsleepConfig(int in_gradualDuration, int in_gradualEndPointBrightness, int in_gradualStartPointBrightness)
{
    // TODO: 在这里执行真正的Action操作

    return OPERATION_OK;
}

static operation_code_t A_2_6_ToggleLightMode()
{
    // TODO: 在这里执行真正的Action操作

    return OPERATION_OK;
}

/**
 * 将Action调用转换为强类型的函数调用。
 */
static void A_2_1_Toggle_doInvoke(action_operation_t *o)
{
    // 检查输入参数个数
    if (o->in->size != 0)
    {
        o->code = OPERATION_INVALID;
        return;
    }

    // 输出结果个数
    o->out->size = 0;
    

    // 调用真正的执行函数
    o->code = A_2_1_Toggle();
}

/**
 * 将Action调用转换为强类型的函数调用。
 */
static void A_2_2_GetAwakeConfig_doInvoke(action_operation_t *o)
{
    // 检查输入参数个数
    if (o->in->size != 0)
    {
        o->code = OPERATION_INVALID;
        return;
    }

    // 输出结果个数
    o->out->size = 3;
    
    //初始化输出参数
	o->out->arguments[0].value = property_value_new_integer(1);
	o->out->arguments[0].piid = 12;
    //初始化输出参数
	o->out->arguments[1].value = property_value_new_integer(0);
	o->out->arguments[1].piid = 13;
    //初始化输出参数
	o->out->arguments[2].value = property_value_new_integer(0);
	o->out->arguments[2].piid = 14;

    // 调用真正的执行函数
    o->code = A_2_2_GetAwakeConfig(&(o->out->arguments[0].value->data.number.value.integerValue),
        &(o->out->arguments[1].value->data.number.value.integerValue),
        &(o->out->arguments[2].value->data.number.value.integerValue));
}

/**
 * 将Action调用转换为强类型的函数调用。
 */
static void A_2_3_SetAwakeConfig_doInvoke(action_operation_t *o)
{
    // 检查输入参数个数
    if (o->in->size != 3)
    {
        o->code = OPERATION_INVALID;
        return;
    }

    // 检查参数: GradualDuration
    if (o->in->arguments[0].piid != 12)
    {
        o->code = OPERATION_INVALID;
        return;
    }

    if (o->in->arguments[0].value->format != PROPERTY_FORMAT_NUMBER)
    {
        o->code = OPERATION_INVALID;
        return;
    }

    // 检查参数: GradualEndPointBrightness
    if (o->in->arguments[1].piid != 13)
    {
        o->code = OPERATION_INVALID;
        return;
    }

    if (o->in->arguments[1].value->format != PROPERTY_FORMAT_NUMBER)
    {
        o->code = OPERATION_INVALID;
        return;
    }

    // 检查参数: GradualStartPointBrightness
    if (o->in->arguments[2].piid != 14)
    {
        o->code = OPERATION_INVALID;
        return;
    }

    if (o->in->arguments[2].value->format != PROPERTY_FORMAT_NUMBER)
    {
        o->code = OPERATION_INVALID;
        return;
    }

    // 输出结果个数
    o->out->size = 0;
    

    // 调用真正的执行函数
    o->code = A_2_3_SetAwakeConfig(o->in->arguments[0].value->data.number.value.integerValue,
        o->in->arguments[1].value->data.number.value.integerValue,
        o->in->arguments[2].value->data.number.value.integerValue);
}

/**
 * 将Action调用转换为强类型的函数调用。
 */
static void A_2_4_GetAsleepConfig_doInvoke(action_operation_t *o)
{
    // 检查输入参数个数
    if (o->in->size != 0)
    {
        o->code = OPERATION_INVALID;
        return;
    }

    // 输出结果个数
    o->out->size = 3;
    
    //初始化输出参数
	o->out->arguments[0].value = property_value_new_integer(1);
	o->out->arguments[0].piid = 12;
    //初始化输出参数
	o->out->arguments[1].value = property_value_new_integer(0);
	o->out->arguments[1].piid = 13;
    //初始化输出参数
	o->out->arguments[2].value = property_value_new_integer(0);
	o->out->arguments[2].piid = 14;

    // 调用真正的执行函数
    o->code = A_2_4_GetAsleepConfig(&(o->out->arguments[0].value->data.number.value.integerValue),
        &(o->out->arguments[1].value->data.number.value.integerValue),
        &(o->out->arguments[2].value->data.number.value.integerValue));
}

/**
 * 将Action调用转换为强类型的函数调用。
 */
static void A_2_5_SetAsleepConfig_doInvoke(action_operation_t *o)
{
    // 检查输入参数个数
    if (o->in->size != 3)
    {
        o->code = OPERATION_INVALID;
        return;
    }

    // 检查参数: GradualDuration
    if (o->in->arguments[0].piid != 12)
    {
        o->code = OPERATION_INVALID;
        return;
    }

    if (o->in->arguments[0].value->format != PROPERTY_FORMAT_NUMBER)
    {
        o->code = OPERATION_INVALID;
        return;
    }

    // 检查参数: GradualEndPointBrightness
    if (o->in->arguments[1].piid != 13)
    {
        o->code = OPERATION_INVALID;
        return;
    }

    if (o->in->arguments[1].value->format != PROPERTY_FORMAT_NUMBER)
    {
        o->code = OPERATION_INVALID;
        return;
    }

    // 检查参数: GradualStartPointBrightness
    if (o->in->arguments[2].piid != 14)
    {
        o->code = OPERATION_INVALID;
        return;
    }

    if (o->in->arguments[2].value->format != PROPERTY_FORMAT_NUMBER)
    {
        o->code = OPERATION_INVALID;
        return;
    }

    // 输出结果个数
    o->out->size = 0;
    

    // 调用真正的执行函数
    o->code = A_2_5_SetAsleepConfig(o->in->arguments[0].value->data.number.value.integerValue,
        o->in->arguments[1].value->data.number.value.integerValue,
        o->in->arguments[2].value->data.number.value.integerValue);
}

/**
 * 将Action调用转换为强类型的函数调用。
 */
static void A_2_6_ToggleLightMode_doInvoke(action_operation_t *o)
{
    // 检查输入参数个数
    if (o->in->size != 0)
    {
        o->code = OPERATION_INVALID;
        return;
    }

    // 输出结果个数
    o->out->size = 0;
    

    // 调用真正的执行函数
    o->code = A_2_6_ToggleLightMode();
}

void S_2_Light_doAction(action_operation_t *o)
{
    switch (o->aiid)
    {
        case IID_2_1_Toggle:
            A_2_1_Toggle_doInvoke(o);
            break;

        case IID_2_2_GetAwakeConfig:
            A_2_2_GetAwakeConfig_doInvoke(o);
            break;

        case IID_2_3_SetAwakeConfig:
            A_2_3_SetAwakeConfig_doInvoke(o);
            break;

        case IID_2_4_GetAsleepConfig:
            A_2_4_GetAsleepConfig_doInvoke(o);
            break;

        case IID_2_5_SetAsleepConfig:
            A_2_5_SetAsleepConfig_doInvoke(o);
            break;

        case IID_2_6_ToggleLightMode:
            A_2_6_ToggleLightMode_doInvoke(o);
            break;

        default:
            o->code = OPERATION_INVALID;
            break;
    }
}
