/**
 * Copyright (C) 2013-2015
 *
 * @file   S_2_Light_doChange.c
 *
 * @remark
 *
 */

#include "arch_dbg.h"
#include "arch_os.h"
#include "S_2_Light_doChange.h"
#include "operation_executor.h"

#define TAG "S_2_Light_doChange"

extern miio_handle_t g_miio_instance_handle;


void P_2_1_On_doChange(miio_handle_t handle, bool newValue)
{
    if (send_property_changed(handle, 2, 1, property_value_new_boolean(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_1_On_doChange_cb(void * newValue)
{
	bool value = (bool) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_1_On_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_2_1_On_doChange_notify(bool newValue)
{
	arch_os_async_call(P_2_1_On_doChange_cb,(void *)newValue,500);
}*/

void P_2_2_Mode_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 2, 2, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_2_Mode_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_2_Mode_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_2_2_Mode_doChange_notify(int newValue)
{
	arch_os_async_call(P_2_2_Mode_doChange_cb,(void *)newValue,500);
}*/

void P_2_3_Brightness_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 2, 3, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_3_Brightness_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_3_Brightness_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_2_3_Brightness_doChange_notify(int newValue)
{
	arch_os_async_call(P_2_3_Brightness_doChange_cb,(void *)newValue,500);
}*/

void P_2_4_Color_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 2, 4, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_4_Color_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_4_Color_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_2_4_Color_doChange_notify(int newValue)
{
	arch_os_async_call(P_2_4_Color_doChange_cb,(void *)newValue,500);
}*/

void P_2_5_ColorTemperature_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 2, 5, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_5_ColorTemperature_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_5_ColorTemperature_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_2_5_ColorTemperature_doChange_notify(int newValue)
{
	arch_os_async_call(P_2_5_ColorTemperature_doChange_cb,(void *)newValue,500);
}*/

void P_2_6_Flow_doChange(miio_handle_t handle, bool newValue)
{
    if (send_property_changed(handle, 2, 6, property_value_new_boolean(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_6_Flow_doChange_cb(void * newValue)
{
	bool value = (bool) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_6_Flow_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_2_6_Flow_doChange_notify(bool newValue)
{
	arch_os_async_call(P_2_6_Flow_doChange_cb,(void *)newValue,500);
}*/

void P_2_7_Saturability_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 2, 7, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_7_Saturability_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_7_Saturability_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_2_7_Saturability_doChange_notify(int newValue)
{
	arch_os_async_call(P_2_7_Saturability_doChange_cb,(void *)newValue,500);
}*/

void P_2_8_FlexSwitch_doChange(miio_handle_t handle, bool newValue)
{
    if (send_property_changed(handle, 2, 8, property_value_new_boolean(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_8_FlexSwitch_doChange_cb(void * newValue)
{
	bool value = (bool) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_8_FlexSwitch_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_2_8_FlexSwitch_doChange_notify(bool newValue)
{
	arch_os_async_call(P_2_8_FlexSwitch_doChange_cb,(void *)newValue,500);
}*/

void P_2_9_DefaultPowerOnState_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 2, 9, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_9_DefaultPowerOnState_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_9_DefaultPowerOnState_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_2_9_DefaultPowerOnState_doChange_notify(int newValue)
{
	arch_os_async_call(P_2_9_DefaultPowerOnState_doChange_cb,(void *)newValue,500);
}*/

void P_2_10_WakeUpMode_doChange(miio_handle_t handle, bool newValue)
{
    if (send_property_changed(handle, 2, 10, property_value_new_boolean(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_10_WakeUpMode_doChange_cb(void * newValue)
{
	bool value = (bool) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_10_WakeUpMode_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_2_10_WakeUpMode_doChange_notify(bool newValue)
{
	arch_os_async_call(P_2_10_WakeUpMode_doChange_cb,(void *)newValue,500);
}*/

void P_2_11_SleepAidMode_doChange(miio_handle_t handle, bool newValue)
{
    if (send_property_changed(handle, 2, 11, property_value_new_boolean(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_11_SleepAidMode_doChange_cb(void * newValue)
{
	bool value = (bool) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_11_SleepAidMode_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_2_11_SleepAidMode_doChange_notify(bool newValue)
{
	arch_os_async_call(P_2_11_SleepAidMode_doChange_cb,(void *)newValue,500);
}*/

void P_2_15_CurrentColorMode_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 2, 15, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_15_CurrentColorMode_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_15_CurrentColorMode_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_2_15_CurrentColorMode_doChange_notify(int newValue)
{
	arch_os_async_call(P_2_15_CurrentColorMode_doChange_cb,(void *)newValue,500);
}*/

void P_2_16_MultiLightWorkMode_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 2, 16, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_16_MultiLightWorkMode_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_16_MultiLightWorkMode_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_2_16_MultiLightWorkMode_doChange_notify(int newValue)
{
	arch_os_async_call(P_2_16_MultiLightWorkMode_doChange_cb,(void *)newValue,500);
}*/

void P_2_17_LightOnGradientTime_doChange(miio_handle_t handle, float newValue)
{
    if (send_property_changed(handle, 2, 17, property_value_new_float(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_17_LightOnGradientTime_doChange_cb(void * newValue)
{
	float value = *((float *) newValue);
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_17_LightOnGradientTime_doChange(g_miio_instance_handle,value);
	
	free(newValue);
	
	return;
}

void P_2_17_LightOnGradientTime_doChange_notify(float newValue)
{
	float * value = (float *) malloc(sizeof(float));
	*value = newValue;
	arch_os_async_call(P_2_17_LightOnGradientTime_doChange_cb,(void *)value,500);
}*/

void P_2_18_LightOffGradientTime_doChange(miio_handle_t handle, float newValue)
{
    if (send_property_changed(handle, 2, 18, property_value_new_float(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_18_LightOffGradientTime_doChange_cb(void * newValue)
{
	float value = *((float *) newValue);
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_18_LightOffGradientTime_doChange(g_miio_instance_handle,value);
	
	free(newValue);
	
	return;
}

void P_2_18_LightOffGradientTime_doChange_notify(float newValue)
{
	float * value = (float *) malloc(sizeof(float));
	*value = newValue;
	arch_os_async_call(P_2_18_LightOffGradientTime_doChange_cb,(void *)value,500);
}*/

void P_2_19_FlowSpeedLevel_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 2, 19, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_19_FlowSpeedLevel_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_19_FlowSpeedLevel_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_2_19_FlowSpeedLevel_doChange_notify(int newValue)
{
	arch_os_async_call(P_2_19_FlowSpeedLevel_doChange_cb,(void *)newValue,500);
}*/
