/**
* Copyright (C) 2013-2015
*
* @file   S_2_Light_doGet.c
*
* @remark
*
*/

#include "S_2_Light_doGet.h"
#include "operation_code.h"
#include "iid.h"

/**
 * 格式: property_value_new_boolean(true 或 false)　
 * 取值: true 或　false
 */
static void P_2_1_On_doGet(property_operation_t *o)
{
    o->value = property_value_new_boolean(true); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 0(Auto)
 */
static void P_2_2_Mode_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(0); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 最小值: 1, 最大值: 100, 步长: 1
 */
static void P_2_3_Brightness_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(1); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 最小值: 0, 最大值: 16777215, 步长: 1
 */
static void P_2_4_Color_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(0); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 最小值: 1000, 最大值: 10000, 步长: 1
 */
static void P_2_5_ColorTemperature_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(1000); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_boolean(true 或 false)　
 * 取值: true 或　false
 */
static void P_2_6_Flow_doGet(property_operation_t *o)
{
    o->value = property_value_new_boolean(true); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 最小值: 0, 最大值: 100, 步长: 1
 */
static void P_2_7_Saturability_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(0); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_boolean(true 或 false)　
 * 取值: true 或　false
 */
static void P_2_8_FlexSwitch_doGet(property_operation_t *o)
{
    o->value = property_value_new_boolean(true); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 1(Off)
 */
static void P_2_9_DefaultPowerOnState_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(1); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_boolean(true 或 false)　
 * 取值: true 或　false
 */
static void P_2_10_WakeUpMode_doGet(property_operation_t *o)
{
    o->value = property_value_new_boolean(true); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_boolean(true 或 false)　
 * 取值: true 或　false
 */
static void P_2_11_SleepAidMode_doGet(property_operation_t *o)
{
    o->value = property_value_new_boolean(true); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 1(RGB), 2(ColorTemperature)
 */
static void P_2_15_CurrentColorMode_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(1); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 1(Multi Lighting), 2(Atmosphere)
 */
static void P_2_16_MultiLightWorkMode_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(1); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_float(浮点数)　
 * 取值: 最小值: 0.0, 最大值: 10.0, 步长: 0.5
 */
static void P_2_17_LightOnGradientTime_doGet(property_operation_t *o)
{
    o->value = property_value_new_float(0.0); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_float(浮点数)　
 * 取值: 最小值: 0.0, 最大值: 10.0, 步长: 0.5
 */
static void P_2_18_LightOffGradientTime_doGet(property_operation_t *o)
{
    o->value = property_value_new_float(0.0); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 0(Low), 1(Medium), 2(High)
 */
static void P_2_19_FlowSpeedLevel_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(0); // TODO: 这里需要读到属性真正的值
}

void S_2_Light_doGet(property_operation_t *o)
{
    switch (o->piid)
    {
        case IID_2_1_On:
            P_2_1_On_doGet(o);
            break;

        case IID_2_2_Mode:
            P_2_2_Mode_doGet(o);
            break;

        case IID_2_3_Brightness:
            P_2_3_Brightness_doGet(o);
            break;

        case IID_2_4_Color:
            P_2_4_Color_doGet(o);
            break;

        case IID_2_5_ColorTemperature:
            P_2_5_ColorTemperature_doGet(o);
            break;

        case IID_2_6_Flow:
            P_2_6_Flow_doGet(o);
            break;

        case IID_2_7_Saturability:
            P_2_7_Saturability_doGet(o);
            break;

        case IID_2_8_FlexSwitch:
            P_2_8_FlexSwitch_doGet(o);
            break;

        case IID_2_9_DefaultPowerOnState:
            P_2_9_DefaultPowerOnState_doGet(o);
            break;

        case IID_2_10_WakeUpMode:
            P_2_10_WakeUpMode_doGet(o);
            break;

        case IID_2_11_SleepAidMode:
            P_2_11_SleepAidMode_doGet(o);
            break;

        case IID_2_15_CurrentColorMode:
            P_2_15_CurrentColorMode_doGet(o);
            break;

        case IID_2_16_MultiLightWorkMode:
            P_2_16_MultiLightWorkMode_doGet(o);
            break;

        case IID_2_17_LightOnGradientTime:
            P_2_17_LightOnGradientTime_doGet(o);
            break;

        case IID_2_18_LightOffGradientTime:
            P_2_18_LightOffGradientTime_doGet(o);
            break;

        case IID_2_19_FlowSpeedLevel:
            P_2_19_FlowSpeedLevel_doGet(o);
            break;

        default:
            o->code = OPERATION_ERROR_CANNOT_READ;
            break;
    }
}
