/**
* Copyright (C) 2013-2015
*
* @file   S_2_Light_doSet.c
*
* @remark
*
*/

#include "S_2_Light_doSet.h"
#include "S_2_Light_doChange.h"
#include "operation_code.h"
#include "iid.h"
#include "i2c_test.h"

static void P_2_1_On_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_BOOLEAN)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.boolean.value;
   if(o->value->data.boolean.value)
	con_rgb_led(1);
  else
  con_rgb_led(0);
		
		
    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_2_1_On_doChange_notify(o->value->data.boolean.value);

    return;
}

static void P_2_2_Mode_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_NUMBER)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // 简单判断数据取值范围是否合法，如果不合法，返回代码: OPERATION_ERROR_VALUE
    if (o->value->data.number.value.integerValue < 0 || o->value->data.number.value.integerValue > 0)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.number.value.integerValue;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_2_2_Mode_doChange_notify(o->value->data.number.value.integerValue);

    return;
}

static void P_2_3_Brightness_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_NUMBER)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // 判断数据取值范围是否合法，如果不合法，返回代码: OPERATION_ERROR_VALUE
    if (o->value->data.number.value.integerValue < 1 || o->value->data.number.value.integerValue > 100)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.number.value.integerValue;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_2_3_Brightness_doChange_notify(o->value->data.number.value.integerValue);

    return;
}

static void P_2_4_Color_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_NUMBER)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // 判断数据取值范围是否合法，如果不合法，返回代码: OPERATION_ERROR_VALUE
    if (o->value->data.number.value.integerValue < 0 || o->value->data.number.value.integerValue > 16777215)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.number.value.integerValue;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_2_4_Color_doChange_notify(o->value->data.number.value.integerValue);

    return;
}

static void P_2_5_ColorTemperature_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_NUMBER)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // 判断数据取值范围是否合法，如果不合法，返回代码: OPERATION_ERROR_VALUE
    if (o->value->data.number.value.integerValue < 1000 || o->value->data.number.value.integerValue > 10000)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.number.value.integerValue;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_2_5_ColorTemperature_doChange_notify(o->value->data.number.value.integerValue);

    return;
}

static void P_2_6_Flow_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_BOOLEAN)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.boolean.value;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_2_6_Flow_doChange_notify(o->value->data.boolean.value);

    return;
}

static void P_2_7_Saturability_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_NUMBER)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // 判断数据取值范围是否合法，如果不合法，返回代码: OPERATION_ERROR_VALUE
    if (o->value->data.number.value.integerValue < 0 || o->value->data.number.value.integerValue > 100)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.number.value.integerValue;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_2_7_Saturability_doChange_notify(o->value->data.number.value.integerValue);

    return;
}

static void P_2_8_FlexSwitch_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_BOOLEAN)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.boolean.value;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_2_8_FlexSwitch_doChange_notify(o->value->data.boolean.value);

    return;
}

static void P_2_9_DefaultPowerOnState_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_NUMBER)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // 简单判断数据取值范围是否合法，如果不合法，返回代码: OPERATION_ERROR_VALUE
    if (o->value->data.number.value.integerValue < 1 || o->value->data.number.value.integerValue > 1)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.number.value.integerValue;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_2_9_DefaultPowerOnState_doChange_notify(o->value->data.number.value.integerValue);

    return;
}

static void P_2_10_WakeUpMode_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_BOOLEAN)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.boolean.value;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_2_10_WakeUpMode_doChange_notify(o->value->data.boolean.value);

    return;
}

static void P_2_11_SleepAidMode_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_BOOLEAN)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.boolean.value;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_2_11_SleepAidMode_doChange_notify(o->value->data.boolean.value);

    return;
}

static void P_2_16_MultiLightWorkMode_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_NUMBER)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // 简单判断数据取值范围是否合法，如果不合法，返回代码: OPERATION_ERROR_VALUE
    if (o->value->data.number.value.integerValue < 1 || o->value->data.number.value.integerValue > 2)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.number.value.integerValue;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_2_16_MultiLightWorkMode_doChange_notify(o->value->data.number.value.integerValue);

    return;
}

static void P_2_17_LightOnGradientTime_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_NUMBER)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // 判断数据取值范围是否合法，如果不合法，返回代码: OPERATION_ERROR_VALUE
    if (o->value->data.number.value.floatValue < 0.0 || o->value->data.number.value.floatValue > 10.0)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.number.value.floatValue;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_2_17_LightOnGradientTime_doChange_notify(o->value->data.number.value.floatValue);

    return;
}

static void P_2_18_LightOffGradientTime_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_NUMBER)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // 判断数据取值范围是否合法，如果不合法，返回代码: OPERATION_ERROR_VALUE
    if (o->value->data.number.value.floatValue < 0.0 || o->value->data.number.value.floatValue > 10.0)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.number.value.floatValue;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_2_18_LightOffGradientTime_doChange_notify(o->value->data.number.value.floatValue);

    return;
}

static void P_2_19_FlowSpeedLevel_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_NUMBER)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // 简单判断数据取值范围是否合法，如果不合法，返回代码: OPERATION_ERROR_VALUE
    if (o->value->data.number.value.integerValue < 0 || o->value->data.number.value.integerValue > 2)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.number.value.integerValue;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_2_19_FlowSpeedLevel_doChange_notify(o->value->data.number.value.integerValue);

    return;
}

void S_2_Light_doSet(property_operation_t *o)
{
    switch (o->piid)
    {
        case IID_2_1_On:
            P_2_1_On_doSet(o);
            break;

        case IID_2_2_Mode:
            P_2_2_Mode_doSet(o);
            break;

        case IID_2_3_Brightness:
            P_2_3_Brightness_doSet(o);
            break;

        case IID_2_4_Color:
            P_2_4_Color_doSet(o);
            break;

        case IID_2_5_ColorTemperature:
            P_2_5_ColorTemperature_doSet(o);
            break;

        case IID_2_6_Flow:
            P_2_6_Flow_doSet(o);
            break;

        case IID_2_7_Saturability:
            P_2_7_Saturability_doSet(o);
            break;

        case IID_2_8_FlexSwitch:
            P_2_8_FlexSwitch_doSet(o);
            break;

        case IID_2_9_DefaultPowerOnState:
            P_2_9_DefaultPowerOnState_doSet(o);
            break;

        case IID_2_10_WakeUpMode:
            P_2_10_WakeUpMode_doSet(o);
            break;

        case IID_2_11_SleepAidMode:
            P_2_11_SleepAidMode_doSet(o);
            break;

        case IID_2_16_MultiLightWorkMode:
            P_2_16_MultiLightWorkMode_doSet(o);
            break;

        case IID_2_17_LightOnGradientTime:
            P_2_17_LightOnGradientTime_doSet(o);
            break;

        case IID_2_18_LightOffGradientTime:
            P_2_18_LightOffGradientTime_doSet(o);
            break;

        case IID_2_19_FlowSpeedLevel:
            P_2_19_FlowSpeedLevel_doSet(o);
            break;

        default:
            o->code = OPERATION_ERROR_CANNOT_WRITE;
            break;
    }
}
