#include "i2c.h"
#include "i2c_test.h"
#include <stdio.h>
#include <string.h>

//Each sub board I2C address
i2c_addr_def s2_addr;





/*********************************************************************************************
*函数名:    i2c_addr_init
*功能:      确定I2C器件地址
*入口参数:  无
*出口参数： 无
*返回值：   无
*作者：     ZZZ
*日期:      2023/3/7
**********************************************************************************************/
void i2c_addr_init(void)
{
	uint8_t i;
	
	s2_addr.flag = 0;
	for(i=0;i<4;i++)
	{
			if(i2c_addr_poll(I2C0,S1_ADDRESS_S2+i*2))
		 {
				s2_addr.periph = I2C0;
				s2_addr.addr = S1_ADDRESS_S2+i*2;
				s2_addr.flag = 1;			
		 } 			 
	   if(s2_addr.flag != 1)
		 {
				if(i2c_addr_poll(I2C1,S1_ADDRESS_S2+i*2))
				{
					s2_addr.periph = I2C1;
					s2_addr.addr = S1_ADDRESS_S2+i*2;
					s2_addr.flag = 1; 
				}						
     }
	}
	//address not read
	if(s2_addr.flag != 1)
	{			
			//poll I2C1,Verti1
			for(i=0;i<4;i++)
			{
				if(i2c_addr_poll(I2C0,S2_ADDRESS_S2+i*2))
				 {
						s2_addr.periph = I2C0;
						s2_addr.addr = S2_ADDRESS_S2+i*2;
						s2_addr.flag = 1;			
				 } 			 
				 if(s2_addr.flag != 1)
				 {
						if(i2c_addr_poll(I2C1,S2_ADDRESS_S2+i*2))
						{
							s2_addr.periph = I2C1;
							s2_addr.addr = S2_ADDRESS_S2+i*2;
							s2_addr.flag = 1; 
						}						
				 }	
			}
	}
	//read successful
	if(s2_addr.flag)
	{

		i2c_cmd_write(s2_addr.periph,s2_addr.addr,0x01);
	}

}


/*********************************************************************************************

函数名:      delay_s2_ms

功能:        s2子板延时函数

入口参数:    count

出口参数:    无

返回值：     无

作者：       ZZZ

日期:        2023/4/1

**********************************************************************************************/

void delay_s2_ms(uint16_t count)

{

	uint16_t i;

	uint32_t decount;

	for(i=0;i<count;i++)

	{

		for(decount=0;decount<50000;decount++)

		{

		}	

	}	 

}



void i2c_delay(uint32_t time)

{

     uint32_t i;

     

	   for(i=0;i<time;i++)

	   {

		 }	 

}


void i2c_direct_read(uint32_t i2c_periph,uint8_t i2c_addr,uint8_t* p_buffer,  uint16_t number_of_byte)

{

	  uint32_t time = 10000;

    /* wait until I2C bus is idle */

    while(i2c_flag_get(i2c_periph, I2C_FLAG_I2CBSY));



    if(2 == number_of_byte){

        i2c_ackpos_config(i2c_periph,I2C_ACKPOS_NEXT);

    }



     /* send a start condition to I2C bus */

    i2c_start_on_bus(i2c_periph);

    i2c_delay(time);

    /* wait until SBSEND bit is set */

    while(!i2c_flag_get(i2c_periph, I2C_FLAG_SBSEND));

    i2c_delay(time);

		

    /* send slave address to I2C bus */

    i2c_master_addressing(i2c_periph, i2c_addr, I2C_RECEIVER);

    i2c_delay(time);

		

    if(number_of_byte < 3){

        /* disable acknowledge */

        i2c_ack_config(i2c_periph,I2C_ACK_DISABLE);

			  i2c_delay(time);

    }

    

    /* wait until ADDSEND bit is set */

    while(!i2c_flag_get(i2c_periph, I2C_FLAG_ADDSEND));

    i2c_delay(time);

		

    /* clear the ADDSEND bit */

    i2c_flag_clear(i2c_periph,I2C_FLAG_ADDSEND);

		i2c_delay(time);

    

    if(1 == number_of_byte){

        /* send a stop condition to I2C bus */

        i2c_stop_on_bus(i2c_periph);

			  i2c_delay(time);

    }

    

    /* while there is data to be read */

    while(number_of_byte){

        if(3 == number_of_byte){

            /* wait until BTC bit is set */

            while(!i2c_flag_get(i2c_periph, I2C_FLAG_BTC));



            /* disable acknowledge */

            i2c_ack_config(i2c_periph,I2C_ACK_DISABLE);

					  i2c_delay(time);

        }

        if(2 == number_of_byte){

            /* wait until BTC bit is set */

            while(!i2c_flag_get(i2c_periph, I2C_FLAG_BTC));

            

            /* send a stop condition to I2C bus */

            i2c_stop_on_bus(i2c_periph);

					  i2c_delay(time);

        }

        

        /* wait until the RBNE bit is set and clear it */

        if(i2c_flag_get(i2c_periph, I2C_FLAG_RBNE)){

            /* read a byte from the EEPROM */

					  i2c_delay(time);

            *p_buffer = i2c_data_receive(i2c_periph);

            i2c_delay(time);

            /* point to the next location where the byte read will be saved */

            p_buffer++; 

            

            /* decrement the read bytes counter */

            number_of_byte--;

        } 

    }

    

    /* wait until the stop condition is finished */

    while(I2C_CTL0(i2c_periph)&0x0200);

    

    /* enable acknowledge */

    i2c_ack_config(i2c_periph,I2C_ACK_ENABLE);



    i2c_ackpos_config(i2c_periph,I2C_ACKPOS_CURRENT);



}

/*********************************************************************************************

函数名:      s2_read_bh1750_value

功能:        读取光照度  

入口参数:    2c_periph:i2c口   i2c_addr:i2c地址

出口参数:    无

返回值：     float ss单精度值

作者：       ZZZ

日期:        2023/4/1

调用描述:    读取bh1750的光照强度值

**********************************************************************************************/

float s2_read_bh1750_value(void)

{	

	uint16_t tmp;

	uint8_t ss_value[2];

	float ss;



	i2c_cmd_write(s2_addr.periph,s2_addr.addr,0x01);

	i2c_cmd_write(s2_addr.periph,s2_addr.addr,0x10);

	delay_s2_ms(200);

	i2c_direct_read(s2_addr.periph,s2_addr.addr,ss_value,2);

	tmp = (ss_value[0]<<8) + ss_value[1];

	ss = (float)tmp*10/12;



	return ss;

}

