/**
 * Copyright (C) 2013-2015
 *
 * @file   S_2_MotionSensor_doChange.c
 *
 * @remark
 *
 */

#include "arch_dbg.h"
#include "arch_os.h"
#include "S_2_MotionSensor_doChange.h"
#include "operation_executor.h"

#define TAG "S_2_MotionSensor_doChange"

extern miio_handle_t g_miio_instance_handle;


void P_2_1_On_doChange(miio_handle_t handle, bool newValue)
{
    if (send_property_changed(handle, 2, 1, property_value_new_boolean(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_1_On_doChange_cb(void * newValue)
{
	bool value = (bool) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_1_On_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_2_1_On_doChange_notify(bool newValue)
{
	arch_os_async_call(P_2_1_On_doChange_cb,(void *)newValue,500);
}*/

void P_2_2_Fault_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 2, 2, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_2_Fault_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_2_Fault_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_2_2_Fault_doChange_notify(int newValue)
{
	arch_os_async_call(P_2_2_Fault_doChange_cb,(void *)newValue,500);
}*/

void P_2_3_Mode_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 2, 3, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_3_Mode_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_3_Mode_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_2_3_Mode_doChange_notify(int newValue)
{
	arch_os_async_call(P_2_3_Mode_doChange_cb,(void *)newValue,500);
}*/

void P_2_4_Status_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 2, 4, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_4_Status_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_4_Status_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_2_4_Status_doChange_notify(int newValue)
{
	arch_os_async_call(P_2_4_Status_doChange_cb,(void *)newValue,500);
}*/

void P_2_5_Illumination_doChange(miio_handle_t handle, float newValue)
{
    if (send_property_changed(handle, 2, 5, property_value_new_float(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_5_Illumination_doChange_cb(void * newValue)
{
	float value = *((float *) newValue);
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_5_Illumination_doChange(g_miio_instance_handle,value);
	
	free(newValue);
	
	return;
}

void P_2_5_Illumination_doChange_notify(float newValue)
{
	float * value = (float *) malloc(sizeof(float));
	*value = newValue;
	arch_os_async_call(P_2_5_Illumination_doChange_cb,(void *)value,500);
}*/

void P_2_6_NoMotionDuration_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 2, 6, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_6_NoMotionDuration_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_6_NoMotionDuration_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_2_6_NoMotionDuration_doChange_notify(int newValue)
{
	arch_os_async_call(P_2_6_NoMotionDuration_doChange_cb,(void *)newValue,500);
}*/

void P_2_7_MotionState_doChange(miio_handle_t handle, bool newValue)
{
    if (send_property_changed(handle, 2, 7, property_value_new_boolean(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_7_MotionState_doChange_cb(void * newValue)
{
	bool value = (bool) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_7_MotionState_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_2_7_MotionState_doChange_notify(bool newValue)
{
	arch_os_async_call(P_2_7_MotionState_doChange_cb,(void *)newValue,500);
}*/

void P_2_8_CustomDetectInterval_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 2, 8, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_8_CustomDetectInterval_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_8_CustomDetectInterval_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_2_8_CustomDetectInterval_doChange_notify(int newValue)
{
	arch_os_async_call(P_2_8_CustomDetectInterval_doChange_cb,(void *)newValue,500);
}*/

void P_2_9_CustomNoMotionTime_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 2, 9, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_9_CustomNoMotionTime_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_9_CustomNoMotionTime_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_2_9_CustomNoMotionTime_doChange_notify(int newValue)
{
	arch_os_async_call(P_2_9_CustomNoMotionTime_doChange_cb,(void *)newValue,500);
}*/

void P_2_10_DetectionSensitivity_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 2, 10, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_2_10_DetectionSensitivity_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_2_10_DetectionSensitivity_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_2_10_DetectionSensitivity_doChange_notify(int newValue)
{
	arch_os_async_call(P_2_10_DetectionSensitivity_doChange_cb,(void *)newValue,500);
}*/
