/**
 * Copyright (C) 2013-2015
 *
 * @file   S_2_MotionSensor_doEvent.c
 *
 * @remark
 *
 */

#include "arch_dbg.h"
#include "S_2_MotionSensor_doEvent.h"
#include "operation_executor.h"
#include "arguments.h"

#define TAG "S_2_MotionSensor_doEvent"

void E_2_1_MotionDetected(miio_handle_t handle)
{
    event_operation_t * o = NULL;

    do
    {
        // 初始化Event
        o = event_operation_new();
        if (o == NULL)
        {
            LOG_ERROR_TAG(TAG, "event_operation_new failed!\n");
            break;
        }

        o->siid = 2;
        o->eiid = 1;

        // 初始化参数列表
        o->arguments = arguments_new();
        if (o->arguments == NULL)
        {
            LOG_ERROR_TAG(TAG, "arguments_new failed!\n");
            break;
        }

        // 参数个数
        o->arguments->size = 0;

        // 发送消息到服务器
        if (send_event_occurred(handle, o) != MIIO_OK)
        {
            LOG_ERROR_TAG(TAG, "send_event_occurred failed!\n");
            break;
        }
    } while (false);

    if (o != NULL)
    {
        event_operation_delete(o);
    }
}

void E_2_2_DeviceBeReset(miio_handle_t handle)
{
    event_operation_t * o = NULL;

    do
    {
        // 初始化Event
        o = event_operation_new();
        if (o == NULL)
        {
            LOG_ERROR_TAG(TAG, "event_operation_new failed!\n");
            break;
        }

        o->siid = 2;
        o->eiid = 2;

        // 初始化参数列表
        o->arguments = arguments_new();
        if (o->arguments == NULL)
        {
            LOG_ERROR_TAG(TAG, "arguments_new failed!\n");
            break;
        }

        // 参数个数
        o->arguments->size = 0;

        // 发送消息到服务器
        if (send_event_occurred(handle, o) != MIIO_OK)
        {
            LOG_ERROR_TAG(TAG, "send_event_occurred failed!\n");
            break;
        }
    } while (false);

    if (o != NULL)
    {
        event_operation_delete(o);
    }
}

