/**
* Copyright (C) 2013-2015
*
* @file   S_2_MotionSensor_doGet.c
*
* @remark
*
*/

#include "S_2_MotionSensor_doGet.h"
#include "operation_code.h"
#include "iid.h"
#include "i2c_test.h"

int tmp = 0;

/**
 * 格式: property_value_new_boolean(true 或 false)　
 * 取值: true 或　false
 */
static void P_2_1_On_doGet(property_operation_t *o)
{
    o->value = property_value_new_boolean(true); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 0(No Faults)
 */
static void P_2_2_Fault_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(0); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 0(Auto)
 */
static void P_2_3_Mode_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(0); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 1(Idle), 2(Busy), 3(Delay)
 */
static void P_2_4_Status_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(1); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_float(浮点数)　
 * 取值: 最小值: 0.0, 最大值: 10000.0, 步长: 1.0
 */
static void P_2_5_Illumination_doGet(property_operation_t *o)
{
		float data = s2_read_bh1750_value();
    o->value = property_value_new_float(data); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 最小值: 0, 最大值: 600, 步长: 60
 */
static void P_2_6_NoMotionDuration_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(0); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_boolean(true 或 false)　
 * 取值: true 或　false
 */
static void P_2_7_MotionState_doGet(property_operation_t *o)
{
    o->value = property_value_new_boolean(1); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 最小值: 0, 最大值: 65535, 步长: 1
 */
static void P_2_8_CustomDetectInterval_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(1); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 最小值: 0, 最大值: 65535, 步长: 1
 */
static void P_2_9_CustomNoMotionTime_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(1); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 1(Low)
 */
static void P_2_10_DetectionSensitivity_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(1); // TODO: 这里需要读到属性真正的值
}

void S_2_MotionSensor_doGet(property_operation_t *o)
{
    switch (o->piid)
    {
        case IID_2_1_On:
            P_2_1_On_doGet(o);
            break;

        case IID_2_2_Fault:
            P_2_2_Fault_doGet(o);
            break;

        case IID_2_3_Mode:
            P_2_3_Mode_doGet(o);
            break;

        case IID_2_4_Status:
            P_2_4_Status_doGet(o);
            break;

        case IID_2_5_Illumination:
            P_2_5_Illumination_doGet(o);
            break;

        case IID_2_6_NoMotionDuration:
            P_2_6_NoMotionDuration_doGet(o);
            break;

        case IID_2_7_MotionState:
            P_2_7_MotionState_doGet(o);
            break;

        case IID_2_8_CustomDetectInterval:
            P_2_8_CustomDetectInterval_doGet(o);
            break;

        case IID_2_9_CustomNoMotionTime:
            P_2_9_CustomNoMotionTime_doGet(o);
            break;

        case IID_2_10_DetectionSensitivity:
            P_2_10_DetectionSensitivity_doGet(o);
            break;

        default:
            o->code = OPERATION_ERROR_CANNOT_READ;
            break;
    }
}
