/**
* Copyright (C) 2013-2015
*
* @file   S_2_MotionSensor_doSet.c
*
* @remark
*
*/

#include "S_2_MotionSensor_doSet.h"
#include "S_2_MotionSensor_doChange.h"
#include "operation_code.h"
#include "iid.h"

static void P_2_1_On_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_BOOLEAN)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.boolean.value;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_2_1_On_doChange_notify(o->value->data.boolean.value);

    return;
}

static void P_2_3_Mode_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_NUMBER)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // 简单判断数据取值范围是否合法，如果不合法，返回代码: OPERATION_ERROR_VALUE
    if (o->value->data.number.value.integerValue < 0 || o->value->data.number.value.integerValue > 0)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.number.value.integerValue;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_2_3_Mode_doChange_notify(o->value->data.number.value.integerValue);

    return;
}

static void P_2_8_CustomDetectInterval_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_NUMBER)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // 判断数据取值范围是否合法，如果不合法，返回代码: OPERATION_ERROR_VALUE
    if (o->value->data.number.value.integerValue < 0 || o->value->data.number.value.integerValue > 65535)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.number.value.integerValue;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_2_8_CustomDetectInterval_doChange_notify(o->value->data.number.value.integerValue);

    return;
}

static void P_2_9_CustomNoMotionTime_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_NUMBER)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // 判断数据取值范围是否合法，如果不合法，返回代码: OPERATION_ERROR_VALUE
    if (o->value->data.number.value.integerValue < 0 || o->value->data.number.value.integerValue > 65535)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.number.value.integerValue;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_2_9_CustomNoMotionTime_doChange_notify(o->value->data.number.value.integerValue);

    return;
}

static void P_2_10_DetectionSensitivity_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_NUMBER)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // 简单判断数据取值范围是否合法，如果不合法，返回代码: OPERATION_ERROR_VALUE
    if (o->value->data.number.value.integerValue < 1 || o->value->data.number.value.integerValue > 1)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.number.value.integerValue;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_2_10_DetectionSensitivity_doChange_notify(o->value->data.number.value.integerValue);

    return;
}

void S_2_MotionSensor_doSet(property_operation_t *o)
{
    switch (o->piid)
    {
        case IID_2_1_On:
            P_2_1_On_doSet(o);
            break;

        case IID_2_3_Mode:
            P_2_3_Mode_doSet(o);
            break;

        case IID_2_8_CustomDetectInterval:
            P_2_8_CustomDetectInterval_doSet(o);
            break;

        case IID_2_9_CustomNoMotionTime:
            P_2_9_CustomNoMotionTime_doSet(o);
            break;

        case IID_2_10_DetectionSensitivity:
            P_2_10_DetectionSensitivity_doSet(o);
            break;

        default:
            o->code = OPERATION_ERROR_CANNOT_WRITE;
            break;
    }
}
