/**
* Copyright (C) 2013-2015
*
* @file   S_3_Battery_doAction.c
*
* @remark
*
*/

#include "S_3_Battery_doAction.h"
#include "operation_code.h"
#include "iid.h"

static operation_code_t A_3_1_StartCharge()
{
    // TODO: 在这里执行真正的Action操作

    return OPERATION_OK;
}

/**
 * 将Action调用转换为强类型的函数调用。
 */
static void A_3_1_StartCharge_doInvoke(action_operation_t *o)
{
    // 检查输入参数个数
    if (o->in->size != 0)
    {
        o->code = OPERATION_INVALID;
        return;
    }

    // 输出结果个数
    o->out->size = 0;
    

    // 调用真正的执行函数
    o->code = A_3_1_StartCharge();
}

void S_3_Battery_doAction(action_operation_t *o)
{
    switch (o->aiid)
    {
        case IID_3_1_StartCharge:
            A_3_1_StartCharge_doInvoke(o);
            break;

        default:
            o->code = OPERATION_INVALID;
            break;
    }
}
