/**
 * Copyright (C) 2013-2015
 *
 * @file   S_3_Battery_doChange.c
 *
 * @remark
 *
 */

#include "arch_dbg.h"
#include "arch_os.h"
#include "S_3_Battery_doChange.h"
#include "operation_executor.h"

#define TAG "S_3_Battery_doChange"

extern miio_handle_t g_miio_instance_handle;


void P_3_1_BatteryLevel_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 3, 1, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_3_1_BatteryLevel_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_3_1_BatteryLevel_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_3_1_BatteryLevel_doChange_notify(int newValue)
{
	arch_os_async_call(P_3_1_BatteryLevel_doChange_cb,(void *)newValue,500);
}*/

void P_3_2_ChargingState_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 3, 2, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_3_2_ChargingState_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_3_2_ChargingState_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_3_2_ChargingState_doChange_notify(int newValue)
{
	arch_os_async_call(P_3_2_ChargingState_doChange_cb,(void *)newValue,500);
}*/

void P_3_3_Voltage_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 3, 3, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_3_3_Voltage_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_3_3_Voltage_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_3_3_Voltage_doChange_notify(int newValue)
{
	arch_os_async_call(P_3_3_Voltage_doChange_cb,(void *)newValue,500);
}*/

void P_3_4_Status_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 3, 4, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_3_4_Status_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_3_4_Status_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_3_4_Status_doChange_notify(int newValue)
{
	arch_os_async_call(P_3_4_Status_doChange_cb,(void *)newValue,500);
}*/

void P_3_5_ChargeProgress_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 3, 5, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_3_5_ChargeProgress_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_3_5_ChargeProgress_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_3_5_ChargeProgress_doChange_notify(int newValue)
{
	arch_os_async_call(P_3_5_ChargeProgress_doChange_cb,(void *)newValue,500);
}*/

void P_3_6_UsageProgress_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 3, 6, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_3_6_UsageProgress_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_3_6_UsageProgress_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_3_6_UsageProgress_doChange_notify(int newValue)
{
	arch_os_async_call(P_3_6_UsageProgress_doChange_cb,(void *)newValue,500);
}*/

void P_3_7_Eco_doChange(miio_handle_t handle, bool newValue)
{
    if (send_property_changed(handle, 3, 7, property_value_new_boolean(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_3_7_Eco_doChange_cb(void * newValue)
{
	bool value = (bool) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_3_7_Eco_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_3_7_Eco_doChange_notify(bool newValue)
{
	arch_os_async_call(P_3_7_Eco_doChange_cb,(void *)newValue,500);
}*/
