/**
 * Copyright (C) 2013-2015
 *
 * @file   S_3_Battery_doEvent.c
 *
 * @remark
 *
 */

#include "arch_dbg.h"
#include "S_3_Battery_doEvent.h"
#include "operation_executor.h"
#include "arguments.h"

#define TAG "S_3_Battery_doEvent"

void E_3_1_LowBattery(miio_handle_t handle)
{
    event_operation_t * o = NULL;

    do
    {
        // 初始化Event
        o = event_operation_new();
        if (o == NULL)
        {
            LOG_ERROR_TAG(TAG, "event_operation_new failed!\n");
            break;
        }

        o->siid = 3;
        o->eiid = 1;

        // 初始化参数列表
        o->arguments = arguments_new();
        if (o->arguments == NULL)
        {
            LOG_ERROR_TAG(TAG, "arguments_new failed!\n");
            break;
        }

        // 参数个数
        o->arguments->size = 0;

        // 发送消息到服务器
        if (send_event_occurred(handle, o) != MIIO_OK)
        {
            LOG_ERROR_TAG(TAG, "send_event_occurred failed!\n");
            break;
        }
    } while (false);

    if (o != NULL)
    {
        event_operation_delete(o);
    }
}

void E_3_2_BatteryStatusChange(miio_handle_t handle, int status)
{
    event_operation_t * o = NULL;

    do
    {
        // 初始化Event
        o = event_operation_new();
        if (o == NULL)
        {
            LOG_ERROR_TAG(TAG, "event_operation_new failed!\n");
            break;
        }

        o->siid = 3;
        o->eiid = 2;

        // 初始化参数列表
        o->arguments = arguments_new();
        if (o->arguments == NULL)
        {
            LOG_ERROR_TAG(TAG, "arguments_new failed!\n");
            break;
        }

        // 参数个数
        o->arguments->size = 1;

        // 第0个参数: Status
        o->arguments->arguments[0].piid = 4;
        o->arguments->arguments[0].value = property_value_new_integer(status);

        // 发送消息到服务器
        if (send_event_occurred(handle, o) != MIIO_OK)
        {
            LOG_ERROR_TAG(TAG, "send_event_occurred failed!\n");
            break;
        }
    } while (false);

    if (o != NULL)
    {
        event_operation_delete(o);
    }
}

