/**
* Copyright (C) 2013-2015
*
* @file   S_3_Battery_doGet.c
*
* @remark
*
*/

#include "S_3_Battery_doGet.h"
#include "operation_code.h"
#include "iid.h"

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 最小值: 0, 最大值: 100, 步长: 1
 */
static void P_3_1_BatteryLevel_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(0); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 1(Charging), 2(Not Charging), 3(Not Chargeable)
 */
static void P_3_2_ChargingState_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(1); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 最小值: 0, 最大值: 65535, 步长: 1
 */
static void P_3_3_Voltage_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(0); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 1(Idle), 2(Busy), 3(Delay)
 */
static void P_3_4_Status_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(1); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 最小值: 1, 最大值: 100, 步长: 1
 */
static void P_3_5_ChargeProgress_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(1); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 最小值: 1, 最大值: 100, 步长: 1
 */
static void P_3_6_UsageProgress_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(1); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_boolean(true 或 false)　
 * 取值: true 或　false
 */
static void P_3_7_Eco_doGet(property_operation_t *o)
{
    o->value = property_value_new_boolean(true); // TODO: 这里需要读到属性真正的值
}

void S_3_Battery_doGet(property_operation_t *o)
{
    switch (o->piid)
    {
        case IID_3_1_BatteryLevel:
            P_3_1_BatteryLevel_doGet(o);
            break;

        case IID_3_2_ChargingState:
            P_3_2_ChargingState_doGet(o);
            break;

        case IID_3_3_Voltage:
            P_3_3_Voltage_doGet(o);
            break;

        case IID_3_4_Status:
            P_3_4_Status_doGet(o);
            break;

        case IID_3_5_ChargeProgress:
            P_3_5_ChargeProgress_doGet(o);
            break;

        case IID_3_6_UsageProgress:
            P_3_6_UsageProgress_doGet(o);
            break;

        case IID_3_7_Eco:
            P_3_7_Eco_doGet(o);
            break;

        default:
            o->code = OPERATION_ERROR_CANNOT_READ;
            break;
    }
}
