/**
 * Copyright (C) 2013-2015
 *
 * @file   S_4_CustomizedServiceForBle_doEvent.c
 *
 * @remark
 *
 */

#include "arch_dbg.h"
#include "S_4_CustomizedServiceForBle_doEvent.h"
#include "operation_executor.h"
#include "arguments.h"

#define TAG "S_4_CustomizedServiceForBle_doEvent"

void E_4_1_CustomizedEvent1(miio_handle_t handle)
{
    event_operation_t * o = NULL;

    do
    {
        // 初始化Event
        o = event_operation_new();
        if (o == NULL)
        {
            LOG_ERROR_TAG(TAG, "event_operation_new failed!\n");
            break;
        }

        o->siid = 4;
        o->eiid = 1;

        // 初始化参数列表
        o->arguments = arguments_new();
        if (o->arguments == NULL)
        {
            LOG_ERROR_TAG(TAG, "arguments_new failed!\n");
            break;
        }

        // 参数个数
        o->arguments->size = 0;

        // 发送消息到服务器
        if (send_event_occurred(handle, o) != MIIO_OK)
        {
            LOG_ERROR_TAG(TAG, "send_event_occurred failed!\n");
            break;
        }
    } while (false);

    if (o != NULL)
    {
        event_operation_delete(o);
    }
}

void E_4_2_CustomizedEvent2(miio_handle_t handle)
{
    event_operation_t * o = NULL;

    do
    {
        // 初始化Event
        o = event_operation_new();
        if (o == NULL)
        {
            LOG_ERROR_TAG(TAG, "event_operation_new failed!\n");
            break;
        }

        o->siid = 4;
        o->eiid = 2;

        // 初始化参数列表
        o->arguments = arguments_new();
        if (o->arguments == NULL)
        {
            LOG_ERROR_TAG(TAG, "arguments_new failed!\n");
            break;
        }

        // 参数个数
        o->arguments->size = 0;

        // 发送消息到服务器
        if (send_event_occurred(handle, o) != MIIO_OK)
        {
            LOG_ERROR_TAG(TAG, "send_event_occurred failed!\n");
            break;
        }
    } while (false);

    if (o != NULL)
    {
        event_operation_delete(o);
    }
}

void E_4_3_CustomizedEvent3(miio_handle_t handle)
{
    event_operation_t * o = NULL;

    do
    {
        // 初始化Event
        o = event_operation_new();
        if (o == NULL)
        {
            LOG_ERROR_TAG(TAG, "event_operation_new failed!\n");
            break;
        }

        o->siid = 4;
        o->eiid = 3;

        // 初始化参数列表
        o->arguments = arguments_new();
        if (o->arguments == NULL)
        {
            LOG_ERROR_TAG(TAG, "arguments_new failed!\n");
            break;
        }

        // 参数个数
        o->arguments->size = 0;

        // 发送消息到服务器
        if (send_event_occurred(handle, o) != MIIO_OK)
        {
            LOG_ERROR_TAG(TAG, "send_event_occurred failed!\n");
            break;
        }
    } while (false);

    if (o != NULL)
    {
        event_operation_delete(o);
    }
}

void E_4_4_CustomizedEvent4(miio_handle_t handle)
{
    event_operation_t * o = NULL;

    do
    {
        // 初始化Event
        o = event_operation_new();
        if (o == NULL)
        {
            LOG_ERROR_TAG(TAG, "event_operation_new failed!\n");
            break;
        }

        o->siid = 4;
        o->eiid = 4;

        // 初始化参数列表
        o->arguments = arguments_new();
        if (o->arguments == NULL)
        {
            LOG_ERROR_TAG(TAG, "arguments_new failed!\n");
            break;
        }

        // 参数个数
        o->arguments->size = 0;

        // 发送消息到服务器
        if (send_event_occurred(handle, o) != MIIO_OK)
        {
            LOG_ERROR_TAG(TAG, "send_event_occurred failed!\n");
            break;
        }
    } while (false);

    if (o != NULL)
    {
        event_operation_delete(o);
    }
}

void E_4_5_CustomizedEvent5(miio_handle_t handle)
{
    event_operation_t * o = NULL;

    do
    {
        // 初始化Event
        o = event_operation_new();
        if (o == NULL)
        {
            LOG_ERROR_TAG(TAG, "event_operation_new failed!\n");
            break;
        }

        o->siid = 4;
        o->eiid = 5;

        // 初始化参数列表
        o->arguments = arguments_new();
        if (o->arguments == NULL)
        {
            LOG_ERROR_TAG(TAG, "arguments_new failed!\n");
            break;
        }

        // 参数个数
        o->arguments->size = 0;

        // 发送消息到服务器
        if (send_event_occurred(handle, o) != MIIO_OK)
        {
            LOG_ERROR_TAG(TAG, "send_event_occurred failed!\n");
            break;
        }
    } while (false);

    if (o != NULL)
    {
        event_operation_delete(o);
    }
}

void E_4_6_CustomizedEvent6(miio_handle_t handle)
{
    event_operation_t * o = NULL;

    do
    {
        // 初始化Event
        o = event_operation_new();
        if (o == NULL)
        {
            LOG_ERROR_TAG(TAG, "event_operation_new failed!\n");
            break;
        }

        o->siid = 4;
        o->eiid = 6;

        // 初始化参数列表
        o->arguments = arguments_new();
        if (o->arguments == NULL)
        {
            LOG_ERROR_TAG(TAG, "arguments_new failed!\n");
            break;
        }

        // 参数个数
        o->arguments->size = 0;

        // 发送消息到服务器
        if (send_event_occurred(handle, o) != MIIO_OK)
        {
            LOG_ERROR_TAG(TAG, "send_event_occurred failed!\n");
            break;
        }
    } while (false);

    if (o != NULL)
    {
        event_operation_delete(o);
    }
}

