/**
 * Copyright (C) 2013-2015
 *
 * @file   S_5_IndicatorLight_doChange.c
 *
 * @remark
 *
 */

#include "arch_dbg.h"
#include "arch_os.h"
#include "S_5_IndicatorLight_doChange.h"
#include "operation_executor.h"

#define TAG "S_5_IndicatorLight_doChange"

extern miio_handle_t g_miio_instance_handle;


void P_5_1_On_doChange(miio_handle_t handle, bool newValue)
{
    if (send_property_changed(handle, 5, 1, property_value_new_boolean(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_5_1_On_doChange_cb(void * newValue)
{
	bool value = (bool) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_5_1_On_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_5_1_On_doChange_notify(bool newValue)
{
	arch_os_async_call(P_5_1_On_doChange_cb,(void *)newValue,500);
}*/

void P_5_2_Mode_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 5, 2, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_5_2_Mode_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_5_2_Mode_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_5_2_Mode_doChange_notify(int newValue)
{
	arch_os_async_call(P_5_2_Mode_doChange_cb,(void *)newValue,500);
}*/

void P_5_3_Brightness_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 5, 3, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_5_3_Brightness_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_5_3_Brightness_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_5_3_Brightness_doChange_notify(int newValue)
{
	arch_os_async_call(P_5_3_Brightness_doChange_cb,(void *)newValue,500);
}*/

void P_5_4_Color_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 5, 4, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_5_4_Color_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_5_4_Color_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_5_4_Color_doChange_notify(int newValue)
{
	arch_os_async_call(P_5_4_Color_doChange_cb,(void *)newValue,500);
}*/

void P_5_5_ColorTemperature_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 5, 5, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_5_5_ColorTemperature_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_5_5_ColorTemperature_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_5_5_ColorTemperature_doChange_notify(int newValue)
{
	arch_os_async_call(P_5_5_ColorTemperature_doChange_cb,(void *)newValue,500);
}*/

void P_5_6_Flow_doChange(miio_handle_t handle, bool newValue)
{
    if (send_property_changed(handle, 5, 6, property_value_new_boolean(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_5_6_Flow_doChange_cb(void * newValue)
{
	bool value = (bool) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_5_6_Flow_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_5_6_Flow_doChange_notify(bool newValue)
{
	arch_os_async_call(P_5_6_Flow_doChange_cb,(void *)newValue,500);
}*/

void P_5_7_Saturability_doChange(miio_handle_t handle, int newValue)
{
    if (send_property_changed(handle, 5, 7, property_value_new_integer(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_5_7_Saturability_doChange_cb(void * newValue)
{
	int value = (int) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_5_7_Saturability_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_5_7_Saturability_doChange_notify(int newValue)
{
	arch_os_async_call(P_5_7_Saturability_doChange_cb,(void *)newValue,500);
}*/

void P_5_8_AutoLightsOff_doChange(miio_handle_t handle, bool newValue)
{
    if (send_property_changed(handle, 5, 8, property_value_new_boolean(newValue)) != MIIO_OK)
    {
        LOG_ERROR_TAG(TAG, "send_property_changed failed!\n");
    }
}
/*
static void P_5_8_AutoLightsOff_doChange_cb(void * newValue)
{
	bool value = (bool) newValue;
	if (NULL == g_miio_instance_handle)
	{
		LOG_ERROR("please create miio instance first!\r\n");
		return;
	}

	P_5_8_AutoLightsOff_doChange(g_miio_instance_handle,value);
	
	
	return;
}

void P_5_8_AutoLightsOff_doChange_notify(bool newValue)
{
	arch_os_async_call(P_5_8_AutoLightsOff_doChange_cb,(void *)newValue,500);
}*/
