/**
* Copyright (C) 2013-2015
*
* @file   S_5_IndicatorLight_doGet.c
*
* @remark
*
*/

#include "S_5_IndicatorLight_doGet.h"
#include "operation_code.h"
#include "iid.h"

/**
 * 格式: property_value_new_boolean(true 或 false)　
 * 取值: true 或　false
 */
static void P_5_1_On_doGet(property_operation_t *o)
{
    o->value = property_value_new_boolean(true); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 0(Auto)
 */
static void P_5_2_Mode_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(0); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 最小值: 1, 最大值: 100, 步长: 1
 */
static void P_5_3_Brightness_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(1); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 最小值: 0, 最大值: 16777215, 步长: 1
 */
static void P_5_4_Color_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(0); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 最小值: 1000, 最大值: 10000, 步长: 1
 */
static void P_5_5_ColorTemperature_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(1000); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_boolean(true 或 false)　
 * 取值: true 或　false
 */
static void P_5_6_Flow_doGet(property_operation_t *o)
{
    o->value = property_value_new_boolean(true); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_integer(整数)　
 * 取值: 最小值: 0, 最大值: 100, 步长: 1
 */
static void P_5_7_Saturability_doGet(property_operation_t *o)
{
    o->value = property_value_new_integer(0); // TODO: 这里需要读到属性真正的值
}

/**
 * 格式: property_value_new_boolean(true 或 false)　
 * 取值: true 或　false
 */
static void P_5_8_AutoLightsOff_doGet(property_operation_t *o)
{
    o->value = property_value_new_boolean(true); // TODO: 这里需要读到属性真正的值
}

void S_5_IndicatorLight_doGet(property_operation_t *o)
{
    switch (o->piid)
    {
        case IID_5_1_On:
            P_5_1_On_doGet(o);
            break;

        case IID_5_2_Mode:
            P_5_2_Mode_doGet(o);
            break;

        case IID_5_3_Brightness:
            P_5_3_Brightness_doGet(o);
            break;

        case IID_5_4_Color:
            P_5_4_Color_doGet(o);
            break;

        case IID_5_5_ColorTemperature:
            P_5_5_ColorTemperature_doGet(o);
            break;

        case IID_5_6_Flow:
            P_5_6_Flow_doGet(o);
            break;

        case IID_5_7_Saturability:
            P_5_7_Saturability_doGet(o);
            break;

        case IID_5_8_AutoLightsOff:
            P_5_8_AutoLightsOff_doGet(o);
            break;

        default:
            o->code = OPERATION_ERROR_CANNOT_READ;
            break;
    }
}
