/**
* Copyright (C) 2013-2015
*
* @file   S_5_IndicatorLight_doSet.c
*
* @remark
*
*/

#include "S_5_IndicatorLight_doSet.h"
#include "S_5_IndicatorLight_doChange.h"
#include "operation_code.h"
#include "iid.h"

static void P_5_1_On_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_BOOLEAN)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.boolean.value;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_5_1_On_doChange_notify(o->value->data.boolean.value);

    return;
}

static void P_5_2_Mode_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_NUMBER)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // 简单判断数据取值范围是否合法，如果不合法，返回代码: OPERATION_ERROR_VALUE
    if (o->value->data.number.value.integerValue < 0 || o->value->data.number.value.integerValue > 0)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.number.value.integerValue;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_5_2_Mode_doChange_notify(o->value->data.number.value.integerValue);

    return;
}

static void P_5_3_Brightness_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_NUMBER)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // 判断数据取值范围是否合法，如果不合法，返回代码: OPERATION_ERROR_VALUE
    if (o->value->data.number.value.integerValue < 1 || o->value->data.number.value.integerValue > 100)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.number.value.integerValue;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_5_3_Brightness_doChange_notify(o->value->data.number.value.integerValue);

    return;
}

static void P_5_4_Color_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_NUMBER)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // 判断数据取值范围是否合法，如果不合法，返回代码: OPERATION_ERROR_VALUE
    if (o->value->data.number.value.integerValue < 0 || o->value->data.number.value.integerValue > 16777215)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.number.value.integerValue;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_5_4_Color_doChange_notify(o->value->data.number.value.integerValue);

    return;
}

static void P_5_5_ColorTemperature_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_NUMBER)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // 判断数据取值范围是否合法，如果不合法，返回代码: OPERATION_ERROR_VALUE
    if (o->value->data.number.value.integerValue < 1000 || o->value->data.number.value.integerValue > 10000)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.number.value.integerValue;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_5_5_ColorTemperature_doChange_notify(o->value->data.number.value.integerValue);

    return;
}

static void P_5_6_Flow_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_BOOLEAN)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.boolean.value;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_5_6_Flow_doChange_notify(o->value->data.boolean.value);

    return;
}

static void P_5_7_Saturability_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_NUMBER)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // 判断数据取值范围是否合法，如果不合法，返回代码: OPERATION_ERROR_VALUE
    if (o->value->data.number.value.integerValue < 0 || o->value->data.number.value.integerValue > 100)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.number.value.integerValue;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_5_7_Saturability_doChange_notify(o->value->data.number.value.integerValue);

    return;
}

static void P_5_8_AutoLightsOff_doSet(property_operation_t *o)
{
    // 判断数据格式是否正确，如果错误，返回代码: OPERATION_ERROR_VALUE
    if (o->value->format != PROPERTY_FORMAT_BOOLEAN)
    {
        o->code = OPERATION_ERROR_VALUE;
        return;
    }

    // TODO: 执行写操作: o->value->data.boolean.value;

    // 如果成功，返回代码: OPERATION_OK
    o->code = OPERATION_OK;
    
    //上报状态，通知app状态变化，统一APP修改、定时器触发后的上报机制
//    P_5_8_AutoLightsOff_doChange_notify(o->value->data.boolean.value);

    return;
}

void S_5_IndicatorLight_doSet(property_operation_t *o)
{
    switch (o->piid)
    {
        case IID_5_1_On:
            P_5_1_On_doSet(o);
            break;

        case IID_5_2_Mode:
            P_5_2_Mode_doSet(o);
            break;

        case IID_5_3_Brightness:
            P_5_3_Brightness_doSet(o);
            break;

        case IID_5_4_Color:
            P_5_4_Color_doSet(o);
            break;

        case IID_5_5_ColorTemperature:
            P_5_5_ColorTemperature_doSet(o);
            break;

        case IID_5_6_Flow:
            P_5_6_Flow_doSet(o);
            break;

        case IID_5_7_Saturability:
            P_5_7_Saturability_doSet(o);
            break;

        case IID_5_8_AutoLightsOff:
            P_5_8_AutoLightsOff_doSet(o);
            break;

        default:
            o->code = OPERATION_ERROR_CANNOT_WRITE;
            break;
    }
}
