/**
 * Copyright (C) 2013-2015
 *
 * @file   on_property_get.c
 *
 * @remark
 *
 */

#include "on_property_set.h"
#include "print_value.h"
#include "arch_dbg.h"
#include "operation_code.h"
#include "iid.h"
#include "S_2_MotionSensor_doSet.h"
#include "S_3_Battery_doSet.h"
#include "S_5_IndicatorLight_doSet.h"

void on_property_set(property_operation_t *o)
{
    LOG_INFO("on_property_set:  siid = [%d], piid = [%d]\n", o->siid, o->piid);
    
    if (o->value == NULL)
    {
    	LOG_ERROR("value is NULL\n");
    	return;
    }
    
    print_value(o->value);

    switch (o->siid)
    {
        case IID_2_MotionSensor:
            S_2_MotionSensor_doSet(o);
            break;

        case IID_3_Battery:
            S_3_Battery_doSet(o);
            break;

        case IID_5_IndicatorLight:
            S_5_IndicatorLight_doSet(o);
            break;

        default:
            o->code = OPERATION_OK;
            break;
    }
}
