/*************************************************************************************************************

: 			LEDѭ˸

*************************************************************************************************************/



#include "gd32f4xx.h"

#include "gd32f450z_eval.h"

#include "main.h"

#include "i2c.h" // I2Cͨصͷļ

#include "e1.h"  // E1Ӱƺͷļ


uint16_t half_count = 0;    // 

uint16_t time_count = 0;    // ʱ

uint16_t min_count = 0;     //1sʱ

uint8_t  second_flag = 0;   // ־

uint8_t  minflag = 0;

uint16_t delay_count = 0;   // ʱ



i2c_addr_def e1_rgb_led_addr; // E1ӰLEDַ




int main(void)

{

	  nvic_priority_group_set(NVIC_PRIGROUP_PRE4_SUB0);// NVICжϷȼ


	  timer3_init();// ʼʱ3

	  init_i2c(); // ʼI2Cͨ


	  e1_rgb_led_addr = e1_init(PCA9685_ADDRESS_E1);// ʼE1Ӱ


	  while(1)

	  {		

     if(second_flag)	// ־λ

     {

				e1_rgb_control(e1_rgb_led_addr.periph,e1_rgb_led_addr.addr,255,255,255);

		 }
		 else
		 {
				e1_rgb_control(e1_rgb_led_addr.periph,e1_rgb_led_addr.addr,0,0,0);
		 }
		 
		}

}





	





/***********************************************************************************************************

//timer3 init 1msʱ

************************************************************************************************************/

void timer3_init(void)

{

		timer_parameter_struct timer_init_struct;

		

		rcu_periph_clock_enable(RCU_TIMER3);

		

		timer_deinit(TIMER3);

		timer_init_struct.prescaler			= 4199;	

		timer_init_struct.period			= 20;

		timer_init_struct.alignedmode		= TIMER_COUNTER_EDGE;

		timer_init_struct.counterdirection	= TIMER_COUNTER_UP;

		timer_init_struct.clockdivision		= TIMER_CKDIV_DIV1;

		timer_init_struct.repetitioncounter = 0;				

		timer_init(TIMER3, &timer_init_struct);

		

		nvic_irq_enable(TIMER3_IRQn, 1, 1); 

		timer_interrupt_enable(TIMER3, TIMER_INT_UP);

		timer_enable(TIMER3);

	

		

}









/********************************************************************************************************

ʱms

*********************************************************************************************************/

void delay_ms(uint16_t mstime)

{

     delay_count = mstime;

     while(delay_count)

		 {

		 }	  

}

/********************************************************************************************************

1msʱжϷ

*********************************************************************************************************/

void TIMER3_IRQHandler(void)

{

		if(timer_interrupt_flag_get(TIMER3, TIMER_INT_FLAG_UP))

		{

			   timer_interrupt_flag_clear(TIMER3, TIMER_INT_FLAG_UP);

			

			   if(delay_count > 0)

				 delay_count--;	 



         if(time_count++ >= 1000)

         {

					    time_count = 0;

					    second_flag = !second_flag;

         }					 

		}

}















