#include "i2c.h"

#include "e3.h"



/*********************************************************************************************************

:     get_e3_address

ڲ:   e3ʼַ

ڲ:    

ֵ:     eborad_addressʵʵõĽṹַ

:       zzz

:       2023/3/31

:   õi2cַ,ʼӦоƬ

**********************************************************************************************************/

i2c_addr_def get_e3_address(uint8_t address)

{

	i2c_addr_def eboard_addess;



	eboard_addess.flag = 0;



	if(i2c_addr_poll(I2C0,address))

	{

		eboard_addess.periph = I2C0;

		eboard_addess.addr = address;

		eboard_addess.flag = 1;			

	} 			 

	if(eboard_addess.flag != 1)

	{

		if(i2c_addr_poll(I2C1,address))

		{

			eboard_addess.periph = I2C1;

			eboard_addess.addr = address;

			eboard_addess.flag = 1; 

		}						

	}	



	return eboard_addess;		 

} 









/*********************************************************************************************************

:     e3_init

ڲ:   e3ַ address 

ڲ:    

ֵ:     i2c_addr_defṹ

:       zzz

:       2023/3/29

:   õe3 i2cַ,ṹflagֵΪ0,ʼоƬýṹflagֵΪ1

**********************************************************************************************************/

i2c_addr_def e3_init(uint8_t address)

{

	i2c_addr_def e_addess;

	uint8_t i;



	e_addess.flag = 0;

	for(i=0;i<4;i++)

	{

		if(i2c_addr_poll(I2C0,address+i*2))

		{

			e_addess.periph = I2C0;

			e_addess.addr = address+i*2;

			e_addess.flag = 1;			

			break;

		} 

	}

	if(e_addess.flag != 1)

	{			

		for(i=0;i<4;i++)

		{

			if(i2c_addr_poll(I2C1,address+i*2))

			{

				e_addess.periph = I2C1;

				e_addess.addr = address+i*2;

				e_addess.flag = 1;

				break;

			}	

		}

	}



	return e_addess;		 

}





/*********************************************************************************************************

:     e3_all_init

ڲ:   e3_addressṹָ  e3_addr-ʼַ 

ڲ:   e3_addressṹָ

ֵ:     

:       zzz

:       2023/3/31

:   ҲʼE3Ӱ,õӦĵַڽṹָe3_address

**********************************************************************************************************/

void e3_all_init(out e3_addr_def *e3_address,uint8_t e3_addr)

{

	   uint8_t i;

	  

	   for(i=0;i<4;i++)

       {

			e3_address->curtain_addr[i] = get_e3_address(e3_addr+i*2);

	   }

}



/*********************************************************************************************************

:     e3_set_position

ڲ:   i2c_periph:i2c   i2c_addr:e3 i2cַ, re_pos λðٷֱ(0-100)

ڲ:    

ֵ:     i2c_addr_defṹ

:       zzz

:       2023/3/29

:   ôλ

**********************************************************************************************************/

void e3_set_position(uint32_t i2c_periph,uint8_t i2c_addr,uint8_t re_pos)

{

	  i2c_delay_byte_write(i2c_periph,i2c_addr,0x03,re_pos);

}









