#include "i2c.h"

#include "s1.h"





/*********************************************************************************************************

:     s1_init

ڲ:   i2cʼַ address 

ڲ:    

ֵ:     i2c_addr_defṹ

:       zzz

:       2023/4/1

:   õs1 i2cַ,ṹflagֵΪ0,ʼоƬýṹflagֵΪ1

**********************************************************************************************************/

i2c_addr_def s1_init(uint8_t address)

{

     i2c_addr_def e_addess;

     

	   e_addess = get_board_address(address);

		 

	   if(e_addess.flag)

	   {

			   i2c_cmd_write(e_addess.periph,e_addess.addr,SYSTEM_ON);

	   }

		return e_addess;		 

}







/*********************************************************************************************************

:     s1_all_init

ڲ:   s1_addressṹָ  s1_addr:s1 i2cʼַ 

ڲ:   s1_addressṹָ

ֵ:     

:       zzz

:       2023/4/1

:   Ҳʼs1Ӱ,õӦĵַڽṹָs1_address

**********************************************************************************************************/

void s1_all_init(s1_addr_def *s1_address,uint8_t s1_addr)

{

	   uint8_t i;

	  

	   for(i=0;i<4;i++)

     {

			    s1_address->key_addr[i] = get_board_address(s1_addr+i*2);

			    if(s1_address->key_addr[i].flag)

					i2c_cmd_write(s1_address->key_addr[i].periph,s1_address->key_addr[i].addr,SYSTEM_ON);	

		 }

}







/*********************************************************************************************

:      s1_key_scan

:        ɨ蹦,õֵ

ڲ:    i2c_periph:i2c  i2c_addr:i2cʼַ

ڲ:    

ֵ     ذɨֵ

ߣ       ZZZ

:        2023/4/1

:    ô˺,õֵ

**********************************************************************************************/

uint8_t s1_key_scan(uint32_t i2c_periph,uint8_t i2c_addr)

{

	  uint8_t key_value;

	  uint8_t keyvalue[6];

	

    i2c_read(i2c_periph,i2c_addr,KEYKS0,keyvalue,6);

	

	   

	  if(keyvalue[0]&0x01)

	  {

		     key_value = SW1;

	  }	

	  else if(keyvalue[2]&0x01)

	  {	

		     key_value = SW2;	 

	  }

	  else if(keyvalue[4]&0x01)

	  {

		     key_value = SW3;

	  }	

	  else if(keyvalue[0]&0x02)

	  {

	       key_value = SW4;

	  }	

	  else if(keyvalue[2]&0x02)

	  {

	       key_value = SW5; 

	  }	

	  else if(keyvalue[4]&0x02)

	  {

	       key_value = SW6; 

	  }

	  else if(keyvalue[0]&0x04)

	  {

		     key_value = SW7;

	  }

	  else if(keyvalue[2]&0x04)

	  {

		     key_value = SW8;

	  }

	  else if(keyvalue[4]&0x04)

	  {

		     key_value = SW9;

	  }

	  else if(keyvalue[0]&0x08)

	  {

		     key_value = SWA;

	  }

	  else if(keyvalue[2]&0x08)

	  {

		     key_value = SW0;

	  }

	  else if(keyvalue[4]&0x08)

	  {

		     key_value = SWC;

	  }	

    else 

    {

		     key_value = SWN;

    }	

    

    return key_value;		

}





