#include "i2c.h"

#include "s2.h"



/*********************************************************************************************

:      delay_s2_ms

:        s2Ӱʱ

ڲ:    count

ڲ:    

ֵ     

ߣ       ZZZ

:        2023/4/1

**********************************************************************************************/

void delay_s2_ms(uint16_t count)

{

	uint16_t i;

	uint32_t decount;

	for(i=0;i<count;i++)

	{

		for(decount=0;decount<50000;decount++)

		{

		}	

	}	 

}



/*********************************************************************************************

:      s2_sht3x_softreset

:        λsht3x

ڲ:    i2c_periph:i2c   i2c_addr:i2cַ

ڲ:    

ֵ     

ߣ       ZZZ

:        2023/4/1

**********************************************************************************************/

void s2_sht3x_softreset(uint32_t i2c_periph,uint8_t i2c_addr)

{

     i2c_delay_byte_write(i2c_periph,i2c_addr,0x30,0xA2);

}







/*********************************************************************************************

:      s2_init_bh1750

:        ʼbh1759

ڲ:    i2c_periph:i2c   i2c_addr:i2cַ

ڲ:    

ֵ     

ߣ       ZZZ

:        2023/4/1

**********************************************************************************************/

void s2_init_bh1750(uint32_t i2c_periph,uint8_t i2c_addr)

{

     i2c_cmd_write(i2c_periph,i2c_addr,0x01);

}





/*********************************************************************************************

:      s2_icm20608_gyro_scaleget

:        ȡǵķֱ

ڲ:    i2c_periph:i2c   i2c_addr:i2cַ

ڲ:    

ֵ     ȡķֱ

ߣ       ZZZ

:        2023/4/3

**********************************************************************************************/

float s2_icm20608_gyro_scaleget(uint32_t i2c_periph,uint8_t i2c_addr)

{

	uint8_t data;

	float gyroscale;



	i2c_delay_read(i2c_periph,i2c_addr,ICM20_GYRO_CONFIG,&data,1);	



	data = (data >> 3) & 0X3;//ȡ̼Ĵֵ

	switch(data) 

	{

		case  0: 				//250dps

			gyroscale = 131;	//ֱgyroscale = ADCݣ65536/̣250*2=131

			break;

		case 1:					//500dps

			gyroscale = 65.5;	//ֱgyroscale = ADCݣ65536/̣500*2=65.5

			break;

		case 2:					//1000dps

			gyroscale = 32.8;	//ֱgyroscale = ADCݣ65536/̣1000*2=32.8

			break;

		case 3:					//2000dps

			gyroscale = 16.4;	//ֱgyroscale = ADCݣ65536/̣2000*2=16.4

			break;

	}

	return gyroscale;

}









/*********************************************************************************************

:      s2_icm20608_accel_scaleget

:        ȡٶȼƵķֱ

ڲ:    i2c_periph:i2c   i2c_addr:i2cַ

ڲ:    

ֵ     ȡķֱ

ߣ       ZZZ

:        2023/4/3

**********************************************************************************************/

uint16_t s2_icm20608_accel_scaleget(uint32_t i2c_periph,uint8_t i2c_addr)

{

	uint8_t  data;

	uint16_t accelscale;

	

	i2c_delay_read(i2c_periph,i2c_addr,ICM20_ACCEL_CONFIG,&data,1);

	data = (data >> 3) & 0X3;

	switch(data) 

	{

			case 0: 

				accelscale = 16384;		//ֱaccelscale = ADCݣ65536/̣2*2= 16384

				break;

			case 1:

				accelscale = 8192;		//ֱaccelscale = ADCݣ65536/̣4*2= 8192

				break;

			case 2:

				accelscale = 4096;		//ֱaccelscale = ADCݣ65536/̣8*2= 4096

				break;

			case 3:

				accelscale = 2048;		//ֱaccelscale = ADCݣ65536/̣16*2= 2048

				break;

	}

	return accelscale;

}







/*********************************************************************************************

:      s2_init_icm20608

:        icm20608

ڲ:    i2c_periph:i2c   i2c_addr:i2cַ

ڲ:    

ֵ     

ߣ       ZZZ

:        2023/4/3

**********************************************************************************************/

void s2_init_icm20608(uint32_t i2c_periph,uint8_t i2c_addr)

{



		 i2c_delay_byte_write(i2c_periph,i2c_addr,ICM20_PWR_MGMT_1, 0x80);		  //λλΪ0x40,˯ģʽ 			

		 delay_s2_ms(100);

		 i2c_delay_byte_write(i2c_periph,i2c_addr,ICM20_PWR_MGMT_1, 0x01);		  //ر˯ߣԶѡʱ 					

		 delay_s2_ms(100);

		

		 i2c_delay_byte_write(i2c_periph,i2c_addr,ICM20_SMPLRT_DIV, 0x00); 	    //ڲ					

		 i2c_delay_byte_write(i2c_periph,i2c_addr,ICM20_GYRO_CONFIG, 0x18); 	  //ǡ2000dps 				

		 i2c_delay_byte_write(i2c_periph,i2c_addr,ICM20_ACCEL_CONFIG, 0x18); 	  //ٶȼơ16G 					

		 i2c_delay_byte_write(i2c_periph,i2c_addr,ICM20_CONFIG, 0x04); 		      //ǵͨ˲BW=20Hz 				

		 i2c_delay_byte_write(i2c_periph,i2c_addr,ICM20_ACCEL_CONFIG2, 0x04); 	//ٶȼƵͨ˲BW=21.2Hz 			

		 i2c_delay_byte_write(i2c_periph,i2c_addr,ICM20_PWR_MGMT_2, 0x00); 	    //򿪼ٶȼƺ 				

		 i2c_delay_byte_write(i2c_periph,i2c_addr,ICM20_LP_MODE_CFG, 0x00); 	  //رյ͹ 						

		 i2c_delay_byte_write(i2c_periph,i2c_addr,ICM20_FIFO_EN, 0x00);		      //رFIFO						



/*	   

	   i2c_delay_byte_write(i2c_periph,i2c_addr,0x6B,0x80);

		delay_ms(100);

	   i2c_delay_byte_write(i2c_periph,i2c_addr,0x6B,0x00); 

	   delay_ms(100);

	

	   i2c_delay_byte_write(i2c_periph,i2c_addr,0x6A,0x01);  

	   delay_ms(100);

	   i2c_delay_byte_write(i2c_periph,i2c_addr,0x6A,0x00);  

	   delay_ms(100);

	

	   i2c_delay_byte_write(i2c_periph,i2c_addr,0x1B,0x18);

	   i2c_delay_byte_write(i2c_periph,i2c_addr,0x1C,0x18);

	   i2c_delay_byte_write(i2c_periph,i2c_addr,0x19,0x00);

	   i2c_delay_byte_write(i2c_periph,i2c_addr,0x1A,0x04);

	

	   i2c_delay_byte_write(i2c_periph,i2c_addr,0x38,0x00);

	   i2c_delay_byte_write(i2c_periph,i2c_addr,0x23,0x00);

	   i2c_delay_byte_write(i2c_periph,i2c_addr,0x37,0x80);

	   i2c_delay_byte_write(i2c_periph,i2c_addr,0x6b,0x01);

	

	   i2c_delay_byte_write(i2c_periph,i2c_addr,0x20,0x7F);

     i2c_delay_byte_write(i2c_periph,i2c_addr,0x21,0x7F);

     i2c_delay_byte_write(i2c_periph,i2c_addr,0x22,0x7F);	



     i2c_delay_byte_write(i2c_periph,i2c_addr,0x69,0x80);

     i2c_delay_byte_write(i2c_periph,i2c_addr,0x38,0xE0);

     i2c_delay_byte_write(i2c_periph,i2c_addr,0x6C,0x00);

*/	   

	   

}

/*********************************************************************************************

crcУֵ

**********************************************************************************************/

uint8_t s2_sht3x_crc_cal(uint16_t DAT)

{

		uint8_t i,t,temp;

		uint8_t CRC_BYTE;



		CRC_BYTE = 0xFF;

		temp = (DAT>>8) & 0xFF;



		for(t = 0; t < 2; t++)

		{

				CRC_BYTE ^= temp;

				for(i = 0;i < 8;i ++)

				{

						if(CRC_BYTE & 0x80)

						{

							  CRC_BYTE <<= 1;

							  CRC_BYTE ^= 0x31;

						}

						else

						{

							  CRC_BYTE <<= 1;

						}

				}



				if(t == 0)

				{

					  temp = DAT & 0xFF;

				}

		}



	  return CRC_BYTE;

}









/*********************************************************************************************************

:     s2_init

ڲ:   i2cʼַ address 

ڲ:    

ֵ:     i2c_addr_defṹ

:       zzz

:       2023/4/1

:   õs2 i2cַ,ṹflagֵΪ0,ʼоƬýṹflagֵΪ1

**********************************************************************************************************/

i2c_addr_def s2_init(uint8_t address)

{

	i2c_addr_def e_addess;

	uint8_t i;     



	e_addess.flag = 0; 

	if( (address == TH_ADDRESS_S2) || (address == AX_ADDRESS_S2) )

	{

		for(i=0;i<2;i++)

		{

			if(i2c_addr_poll(I2C0,address+i*2))

			{

				e_addess.periph = I2C0;

				e_addess.addr = address+i*2;

				e_addess.flag = 1;			

				break;

			} 

		}

		if(e_addess.flag != 1)

		{			

			for(i=0;i<4;i++)

			{

				if(i2c_addr_poll(I2C1,address+i*2))

				{

					e_addess.periph = I2C1;

					e_addess.addr = address+i*2;

					e_addess.flag = 1;

					break;

				}	

			}

		}

		if(e_addess.flag)

		{

			if( (e_addess.addr == TH_ADDRESS_S2) || (e_addess.addr == (TH_ADDRESS_S2+2)) )

			{

				s2_sht3x_softreset(e_addess.periph,e_addess.addr);

			}		

			else if( (e_addess.addr == AX_ADDRESS_S2) || (e_addess.addr == (AX_ADDRESS_S2+2)) )   

			{

				s2_init_icm20608(e_addess.periph,e_addess.addr);

			}								

		}					 

	}

	else if(address == S1_ADDRESS_S2)

	{

		e_addess = get_board_address(S1_ADDRESS_S2);  

		if(e_addess.flag != 1)	

		{

			e_addess = get_board_address(S2_ADDRESS_S2);	

		}			

		if(e_addess.flag)	

		{

			s2_init_bh1750(e_addess.periph,e_addess.addr);

		}					 

	}



	return e_addess;		 

}









/*********************************************************************************************************

:     s2_all_init

ڲ:   s2_addressṹָ  s2_th_addr:sht35ʪȴַ  s2_ss_add:bh1750ַ s2_ax_addr:6ᴫַ

ڲ:   s2_addressṹָ 

ֵ:     

:       zzz

:       2023/4/1

:   ҲʼS2Ӱ,õӦĵַڽṹָs2_address

**********************************************************************************************************/

void s2_all_init(s2_addr_def *s2_address,uint8_t s2_th_addr,uint8_t s2_ss_addr,uint8_t s2_ax_addr)

{

	   s2_address->th_addr = s2_init(s2_th_addr);

	   s2_address->ss_addr = s2_init(s2_ss_addr);

	   s2_address->ax_addr = s2_init(s2_ax_addr);

}	







/*********************************************************************************************

:      s2_read_sht3x

:        ȡ¶Ⱥʪ  

ڲ:    

ڲ:    

ֵ     s2_paraṹ

ߣ       ZZZ

:        2023/4/1

:    ȡsht35¶ʪֵ

**********************************************************************************************/

s2_para s2_read_sht3x(uint32_t i2c_periph,uint8_t i2c_addr)

{

	uint8_t  th_value[6];

	s2_para  sht_para;

	uint16_t tmp;



	i2c_delay_byte_write(i2c_periph,i2c_addr,0x2C,0x0D);

	delay_s2_ms(100);

	i2c_direct_read(i2c_periph,i2c_addr,th_value,6);



	tmp = (th_value[0]<<8) + th_value[1];

	if(s2_sht3x_crc_cal(tmp) == th_value[2])

	{

		sht_para.temperature = (float)tmp*175/(65536-1)-45;

	}



	tmp = (th_value[3]<<8) + th_value[4];

	if(s2_sht3x_crc_cal(tmp) == th_value[5])

	{

		sht_para.humidity = (float)tmp*100/(65536-1);

	}



	return sht_para;

}







/*********************************************************************************************

:      s2_read_bh1750_value

:        ȡն  

ڲ:    2c_periph:i2c   i2c_addr:i2cַ

ڲ:    

ֵ     float ssֵ

ߣ       ZZZ

:        2023/4/1

:    ȡbh1750Ĺǿֵ

**********************************************************************************************/

float s2_read_bh1750_value(uint32_t i2c_periph,uint8_t i2c_addr)

{	

	uint16_t tmp;

	uint8_t ss_value[2];

	float ss;



	i2c_cmd_write(i2c_periph,i2c_addr,0x01);

	i2c_cmd_write(i2c_periph,i2c_addr,0x10);

	delay_s2_ms(200);

	i2c_direct_read(i2c_periph,i2c_addr,ss_value,2);

	tmp = (ss_value[0]<<8) + ss_value[1];

	ss = (float)tmp*10/12;



	return ss;

}







/*********************************************************************************************

:      s2_read_icm20608_value

:        ȡ6  

ڲ:    2c_periph:i2c   i2c_addr:i2cַ

ڲ:    

ֵ     icm_value:ax_paraṹ

ߣ       ZZZ

:        2023/4/3

:    ȡicm20608x,y,zĽٶȺͼٶֵͬʱȡ¶ֵ

**********************************************************************************************/

ax_para s2_read_icm20608_value(uint32_t i2c_periph,uint8_t i2c_addr)

{

	ax_para icm_value;

	float gyroscale;

	uint16_t accescale;

	uint8_t data[14];



	int16_t gyro_x_adc;		

	int16_t gyro_y_adc;		

	int16_t gyro_z_adc;		

	int16_t accel_x_adc;		

	int16_t accel_y_adc;		

	int16_t accel_z_adc;		

	int16_t temp_adc;		



	gyroscale = s2_icm20608_gyro_scaleget(i2c_periph,i2c_addr);

	accescale = s2_icm20608_accel_scaleget(i2c_periph,i2c_addr);



	i2c_delay_read(i2c_periph,i2c_addr,ICM20_ACCEL_XOUT_H,data,14);



	accel_x_adc = (data[0] << 8) | data[1]; 

	accel_y_adc = (data[2] << 8) | data[3]; 

	accel_z_adc = (data[4] << 8) | data[5]; 

	temp_adc    = (data[6] << 8) | data[7]; 

	gyro_x_adc  = (data[8] << 8) | data[9]; 

	gyro_y_adc  = (data[10] << 8) | data[11];

	gyro_z_adc  = (data[12] << 8) | data[13];



	icm_value.gyro_x_act = (float)(gyro_x_adc) / gyroscale;

	icm_value.gyro_y_act = (float)(gyro_y_adc) / gyroscale;

	icm_value.gyro_z_act = (float)(gyro_z_adc) / gyroscale;



	icm_value.accel_x_act = (float)(accel_x_adc) / accescale;

	icm_value.accel_y_act = (float)(accel_y_adc) / accescale;

	icm_value.accel_z_act = (float)(accel_z_adc) / accescale;



	icm_value.temp_act = (float)((temp_adc - 25 )*10 / 3268) + 25;

	return icm_value;

}







