#include "i2c.h"

#include "s7.h"









/*********************************************************************************************************

:     pca9557_ir_init

ڲ:   i2c_periph:i2cѡ i2c_addr:ʼַaddress 

ڲ:    

ֵ:     

:       zzz

:       2023/4/6

:   ʼpca9557оƬ

**********************************************************************************************************/

void pca9557_ir_init(uint32_t i2c_periph,uint8_t i2c_addr)

{

	   i2c_delay_byte_write(i2c_periph,i2c_addr,PCA9557_POLARITY_INVERSION_REG,0x00);

	   i2c_delay_byte_write(i2c_periph,i2c_addr,PCA9557_CONFIG_REG,0xFF);

}







/*********************************************************************************************************

:     s7_init

ڲ:   i2cʼַ address 

ڲ:    

ֵ:     i2c_addr_defṹ

:       zzz

:       2023/4/6

:   õs7 i2cַ,ṹflagֵΪ0,ʼоƬýṹflagֵΪ1

**********************************************************************************************************/

i2c_addr_def s7_init(uint8_t address)

{

     uint8_t i;

	   i2c_addr_def e_address;



     for(i=0;i<4;i++)

     {

			    e_address = get_board_address(address + i*2);

			    if(e_address.flag)

					{

						   pca9557_ir_init(e_address.periph,e_address.addr);

						   break;

          }						

     }

		 

		 return e_address;

}







/*********************************************************************************************************

:     s7_all_init

ڲ:   s7_addressṹָ  s7_addr:s7 i2cʼַ 

ڲ:   s7_addressṹָ

ֵ:     

:       zzz

:       2023/4/6

:   Ҳʼs7Ӱ,õӦĵַڽṹָs7_address

**********************************************************************************************************/

void s7_all_init(s7_addr_def *s7_address,uint8_t s7_addr)

{

	   uint8_t i;

	  

	   for(i=0;i<4;i++)

     {

			    s7_address->ir_addr[i] = get_board_address(s7_addr+i*2);

			    if(s7_address->ir_addr[i].flag)

			    pca9557_ir_init(s7_address->ir_addr[i].periph,s7_address->ir_addr[i].addr);

		 }

}







/*********************************************************************************************************

:     s7_get_status

ڲ:   i2c_periph:i2cѡ i2c_addr:ʼַaddress 

ڲ:    

ֵ:     ״̬1,״̬0

:       zzz

:       2023/4/6

:   õ崫״̬

**********************************************************************************************************/

uint8_t s7_get_status(uint32_t i2c_periph,uint8_t i2c_addr)

{

     uint8_t s_status;

     

	   i2c_read(i2c_periph,i2c_addr,0x00,&s_status,1);

     

	   if(s_status & 0x01)

		 {

			   return 1;

		 }	 

     else

		 {	 

         return 0;

     }			 

}



















