**实验目的**

掌握ALGO扩展的作用

掌握ALGO扩展的安装

掌握ALGO扩展的基本使用

**实验背景**

ALGO是Neo4j提供的一个常用的算法库，ALGO的英文全程为Neo4j Graph Algorithms。Neo4j 3.5 版本之后，Neo4j Graph Algorithms更新为Neo4j Graph Data Science。

**实验原理**

ALOG作为Neo4j的扩展库，使用安装均较为友好，只需要安装后，就可使用，读者主要掌握ALGO提供了哪些常见的扩展，然后熟练使用即可。本实验主要包括ALGO安装，ALGO介绍，ALGO使用等几个部分。

1.ALGO提供的图算法

图算法ALGO用于计算图、节点或关系的度量，本实验主要介绍ALGO提供的几种核心算法，并提供部分算法的使用案例。

1)中心性算法（Centralities algorithms）。

中心性算法主要用来判断图中节点的重要性，很多中心性算法产生于社交网络分析中，本部分将介绍如下几种中心性算法：

页面排名算法（PageRank，algo.pageRank），计算网络中的实体权重排名。PageRank是以Larry Page（谷歌创始人之一）的名字命名的，PageRank算法用于对谷歌的搜索结果中的网站进行排名；

文档排名算法（ArticleRank，algo.articleRank），PageRank算法的一种变体，用于衡量节点的传递影响；

中介中心性（Betweenness Centrality，algo.betweenness），检测节点对图中信息流影响程度的算法，该算法计算图中所有节点对之间的非加权最短路径。根据通过该节点的最短路径的数量，每个节点都会得到一个分数。在其他节点之间的最短路径上的节点，其之间的中心性得分会更高。可用于找到特定疾病的控制基因，以改进药品的靶点；

紧密中心性（Closeness Centrality，algo.closeness），度量节点之间距离，紧密程度的算法，紧密度得分高的节点与所有其他节点的距离最短；

调和中心性（Harmonic Centrality，algo.closeness.harmonic），用于解决不连通图的问题，是紧密中心性算法的一种变体，起源于社交网络分析领域；

度中心性（Degree Centrality，algo.degree），度中心性算法可用于查找图中的重要节点，中心性度量来自节点的传入或传出(或两者都有)关系的数量，并取决于关系投影的方向。

2)社区发现算法（Community detection algorithms）。

社区发现算法主要用于评估一个群体是如何聚集或划分，以及增强或分裂的趋势，本部分介绍如下几种社区发现算法：

鲁汶算法（Louvain，algo.louvain），鲁汶算法于2008年提出，是最快的模块化算法之一。模块度的物理含义是社区内节点的连边的权重之和与随机情况下的连边的权重之和的差距，是评估一个社区网络划分好坏的度量方法；

标签传播算法（Label Propagation，algo.labelPropagation），标签传播算法(LPA)是一种快速查找图中社区的算法，是一种无监督算法，可用与在社交沟通中理解舆论；

强连通组件（Strongly Connected Components，algo.scc），强连通组件算法(SCC)用于检测网络中存在的强联通组件（关系存在双边结构）。强连通组件算法可以找到一个群体，在这个群体内，任何一个节点与其他节点均可互相访问，可用于产品推荐等场景；

三角计数（Triangle Counting，algo.triangleCount），三角计数可用于确定组的稳定性（相互连接的数量，代表了稳定性）。三角计数在社交网络分析中使用较多，常被用来检测社区并衡量这些社区的聚集程度；

3)路径查找算法（Path finding algorithms）。

路径算法可以找到两个或多个节点之间的最短路径，或者评估路径的可用性，本部分介绍如下几种路径查找算法：

最小生成树（Ｍinimum Spanning Tree，algo.mst），用于找到一个连接树，在树中，从给定的节点访问所有可达节点的权重或成本最小；

最短路径（Shortest Path，algo.shortestPath），用于计算两个节点之间的最短路径。最短路径算法有Ａ星算法（A\*，, algo.shortestPath.astar）和Yen’s k最短路径 (Yen’s K-shortest paths，algo.kShortestPaths)两种变体。与最短路径算法略有不同，Yen’s k-最短路径算法不只是找到最短路径，还会计算出第1到第k-1个最短路径；

全节点对最短路径（All Pairs Shortest Path，algo.allShortestPath）和单源最短路径（Single Source Shortesr Path，algo.shortestPath.deltastepping），用于查找从选定节点到其它所有节点的最短路径，或查找所有节点对之间的最短路径；

随机路径（Random Walk，algo.randomWalk），作为机器学习或是其它图算法的预处理步骤。

4)相似度算法（Similarity）。

相似度算法使用不同的度量来计算节点对的相似度，本部分介绍如下几种相似度算法：

杰卡德相似度（Jaccard Similarity，algo.similarity.jaccard），杰卡德相似度用于比较有限样本集之间的相似性与差异性，Jaccard系数值越大，样本相似度越高；

余弦相似度（Consine Similarity，algo.similarity.cosine），余弦相似度是n维空间中两个n维向量夹角的余弦值，是两个向量的点积除以两个向量的长度(或大小)的乘积；

皮尔逊相似度（Pearson Similarity，algo.similarity.pearson），皮尔逊相似度是两个n维向量的协方差除以它们的标准差的乘积；

欧氏距离（Euclidean Distance，algo.similarity.euclidean），欧氏距离是指n维空间中两点之间的直线距离；

重叠相似度（Overlap Similarity，algo.similarity.overlap），重叠相似性度量两个集合之间的重叠。计算公式为两个集合的交集大小，除以两个集合中较小的集合的大小。

5)链接预测算法（Link Prediction）。

链接预测算法算法用于确定一对节点的紧密程度，本部分介绍如下几种链接算法：

Adamic Adar（Adamic Adar ，algo.linkprediction.adamicAdar），Adamic Adar是一种基于节点之间共同邻居的亲密度测算方法。2003年由 Lada Adamic 和 Eytan Adar t在 predict links in a social network中提出的；

相同邻居（Common Neighbors，algo.linkprediction.commonNeighbors），该算法的思想是两个有共同朋友的陌生人比没有共同朋友的陌生人更有可能被介绍认识。

优先连接（Preferential Attachment，algo.linkprediction.preferentialAttachment），优先连接是一种度量方法，用于计算节点的亲密度，优先连接的思想是一个节点的连接越多，该节点接收新连接的可能性就越大。

资源分配（Resource Allocation，algo.linkprediction.resourceAllocation），资源分配是一种度量方法，用于计算基于共享邻居的节点之间的亲密度；

相同社区（Same Community，algo.linkprediction.sameCommunity），相同社区是一种确定两个节点是否属于同一个团体的方法。

**实验环境**

Ubuntu 16.04

jdk1.8

Neo4j3.5.5

ALGO3.5.4.0

**建议课时**

1课时

**实验步骤**

一、ALGO安装

1.ALGO版本匹配

ALGO依赖于Neo4j的内部api，在Neo4j时，需要使用匹配的ALGO版本，确保Neo4j和ALGO之间的前两个版本，官方提供了对应的版本匹配，摘取部分如下：

\[  
    {  
        "neo4j": "3.5.9",  
        "version": "3.5.9.0",  
        "url": "",  
        "jar": "https://s3-eu-west-1.amazonaws.com/com.neo4j.graphalgorithms.dist/neo4j-graph-algorithms-3.5.9.0-standalone.jar"  
    },  
    {  
        "neo4j": "3.5.8",  
        "version": "3.5.8.1",  
        "url": "",  
        "jar": "https://s3-eu-west-1.amazonaws.com/com.neo4j.graphalgorithms.dist/neo4j-graph-algorithms-3.5.8.1-standalone.jar"  
    },  
    {  
        "neo4j": "3.5.7",  
        "version": "3.5.7.0",  
        "url": "",  
        "jar": "https://s3-eu-west-1.amazonaws.com/com.neo4j.graphalgorithms.dist/neo4j-graph-algorithms-3.5.7.0-standalone.jar"  
    },  
    {  
        "neo4j": "3.5.6",  
        "version": "3.5.6.1",  
        "url": "",  
        "jar": "https://s3-eu-west-1.amazonaws.com/com.neo4j.graphalgorithms.dist/neo4j-graph-algorithms-3.5.6.1-standalone.jar"  
    },  
    {  
        "neo4j": "3.5.5",  
        "version": "3.5.4.0",  
        "url": "http://github.com/neo4j-contrib/neo4j-graph-algorithms/releases/3.5.4.0",  
        "jar": "https://github.com/neo4j-contrib/neo4j-graph-algorithms/releases/download/3.5.4.0/graph-algorithms-algo-3.5.4.0.jar"  
    }  
\]

从版本对应关系可以看出，本书Neo4j3.5.5时，对应选用的ALGO版本为3.5.4.0，下载ALGO3.5.4.0。

```markup
cd ~
wget http://i9000.net:8888/sgn/BDColl/Nosql/task13-2.zip
unzip task13-2.zip

```

下载后的jar包为graph-algorithms-algo-3.5.4.0.jar。

2.ALGO安装

下载ALGO的jar文件后，将jar文件复制到Neo4j的plugins目录下。在Ubuntu系统下，plugins路径为于/var/lib/neo4j/plugins。

```markup
cd ~
sudo cp graph-algorithms-algo-3.5.4.0.jar /var/lib/neo4j/plugins
```

修改配置文件,在neo4j.conf 配置文件中添加：

```markup
cd /etc/neo4j
sudo vim neo4j.conf
```

修改配置文件：

```markup
dbms.security.procedures.unrestricted=apoc.*,algo.*
```

该行配置语句可以完成APOC的函数和过程授权，不配置该行语句，在执行函数和过程时，可能会出现如下错误：apoc.algo.pagerank is not available due to having restricted sccess rights,check configuration

重启Neo4j服务:

```markup
sudo neo4j start
```

启动完成后，浏览器打开

```markup
localhost:7474
```

提示输入密码，初始密码为neo4j，如下图：

![neo4j初始密码.png](./pic/neo4j初始密码.png)

初始密码输入后，需要修改密码，如下图：

![neo4j修改密码.png](./pic/neo4j修改密码.png)

修改密码完成后，如果可以看到如下图所示，则说明neo4j启动完成

![neo4j启动.png](./pic/neo4j启动.png)

在可视化界面在输入如下命令:

```markup
return algo.version()
```

如果出现对应的版本号，证明安装成功。

返回值为：

│"apoc.version()"   │  
│"3.5.0.11"    │

打开localhost:7474,在可视化界面在输入如下命令:

```markup
CALL algo.list()
```

返回ALGO库支持的算法，读者可以将支持的算法导出为csv文件。

部分返回值如下：

![ALGO支持的算法.png](./pic/ALGO支持的算法.png)

二、ALGO使用

1.ALGO使用案例

1)在import目录下创建csv文件并导入到neo4j。

本例需要两个csv文件，分别为transport-nodes.csv和transport-relationships.csv文件。这两个csv文件的物理意义是欧洲道路网子集的数据。下载这两个文件，并放置在import目录下：

```markup
cd ~
sudo cp transport-nodes.csv transport-relationships.csv /var/lib/neo4j/import
```

transport-nodes.csv文件的第0列为城市名称，第、2列为经纬度信息，第3列为人口数量。比如第0列的Den Haag为荷兰城市海牙。

transport-nodes.csv文件：

id,latitude,longitude,population  
"Amsterdam",52.379189,4.899431,821752  
"Utrecht",52.092876,5.104480,334176  
"Den Haag",52.078663,4.288788,514861  
"Immingham",53.61239,-0.22219,9642  
"Doncaster",53.52285,-1.13116,302400  
"Hoek van Holland",51.9775,4.13333,9382  
"Felixstowe",51.96375,1.3511,23689  
"Ipswich",52.05917,1.15545,133384  
"Colchester",51.88921,0.90421,104390  
"London",51.509865,-0.118092,8787892  
"Rotterdam",51.9225,4.47917,623652  
"Gouda",52.01667,4.70833,70939

transport-relationships.csv文件的第0列为出发城市名称，第1列为目的地城市名称，第2列关系类别，类别EROAD的现实意义为欧洲的高速公路，第3列为城市间的距离。

transport-relationships.csv文件：

src,dst,relationship,cost  
"Amsterdam","Utrecht","EROAD",46  
"Amsterdam","Den Haag","EROAD",59  
"Den Haag","Rotterdam","EROAD",26  
"Amsterdam","Immingham","EROAD",369  
"Immingham","Doncaster","EROAD",74  
"Doncaster","London","EROAD",277  
"Hoek van Holland","Den Haag","EROAD",27  
"Felixstowe","Hoek van Holland","EROAD",207  
"Ipswich","Felixstowe","EROAD",22  
"Colchester","Ipswich","EROAD",32  
"London","Colchester","EROAD",106  
"Gouda","Rotterdam","EROAD",25  
"Gouda","Utrecht","EROAD",35  
"Den Haag","Gouda","EROAD",32  
"Hoek van Holland","Rotterdam","EROAD",33

**如下语句均在localhost:7474页面操作。**

将transport-nodes.csv文件导入到neo4j：

```markup
WITH "file:///transport-nodes.csv" AS uri
LOAD CSV WITH HEADERS FROM uri AS row
MERGE (place:Place {id:row.id})
SET place.latitude = toFloat(row.latitude),
place.longitude = toFloat(row.latitude),
place.population = toInteger(row.population);
```

将transport-relationships.csv导入到neo4j：

```markup
WITH "file:///transport-relationships.csv" AS uri
LOAD CSV WITH HEADERS FROM uri AS row
MATCH (origin:Place {id: row.src})
MATCH (destination:Place {id: row.dst})
MERGE (origin)-[:EROAD {distance: toInteger(row.cost)}]->(destination);
```

file:///表示import路径。

2)无权重最短路径算法。

Neo4j的最短路径算法位于algo.shortestPath下，最短路径算法中默认图是无方向的，可以用参数direction: "INCOMING" 或者direction: "OUTGOING"更改默认设置，其中INCOMING 表示入链，OUTGOING表示出链。

将空值作为过程的第三个参数传递给最短路径算法时，算法将假定每个关系的默认权重为1.0，这意味着在执行算法时将不考虑权重属性。现在要查询从阿姆斯特丹（Amsterdam）到伦敦（London）的最短路径，不考虑权重，具体代码如下：

```markup
MATCH (source:Place {id: "Amsterdam"}),
(destination:Place {id: "London"})
CALL algo.shortestPath.stream(source, destination, null)
YIELD nodeId, cost
RETURN algo.getNodeById(nodeId).id AS place, cost
```

返回值为：

│"place"   │"cost"│  
│"Amsterdam"│0.0  │  
│"Immingham"│1.0  │  
│"Doncaster"│2.0  │  
│"London"  │3.0  │

返回结果为阿姆斯特丹（Amsterdam）到伦敦（London）的无权重最短路径。将这几个城市之间的距离加起来，可得到该最短路径的总距离为：369+74+277=720公里。

3)加权重最短路径算法。

与无权重最短路径类似，加权重的最短路径算法只需要在第三个参数设置为关系的属性即可。现在要查询从阿姆斯特丹（Amsterdam）到伦敦（London）的加权重最短路径，权重为城市间的距离值。代码如下：

```markup
MATCH (source:Place {id: "Amsterdam"}),
(destination:Place {id: "London"})
CALL algo.shortestPath.stream(source, destination, "distance")
YIELD nodeId, cost
RETURN algo.getNodeById(nodeId).id AS place, cost
```

返回值为：

│"place"      │"cost"│  
│"Amsterdam"    │0.0  │  
│"Den Haag"     │59.0  │  
│"Hoek van Holland"│86.0  │  
│"Felixstowe"    │293.0 │  
│"Ipswich"     │315.0 │  
│"Colchester"    │347.0 │  
│"London"      │453.0 │

无权重的最短路径的总距离成本为720公里，考虑权重的最短路径的总距离成本为453公里，节省了267公里。

**实验总结**

本实验主要完成了ALGO的介绍，安装，配置与基本使用，在使用过程中可以结合需求，参考官网实现更多的ALGO练习。