### **实验目的**

掌握Neo4j数据导入

掌握Neo4j模式查找

掌握基于Neo4j实现好友推荐的过程

### **实验背景**

本实验包括两种数据集：一种是实体数据，包括：教师（people.csv）、高校（school.csv）、高校类别（schooltype.csv）和教室群体（title.csv）四份数据；另外是关系数据，包括教师-高校关系rel-ps.csv、学校-高校类别关系 rel-sc.csv、教师-教师群体关系 rel-pt.csv。

### **实验原理**

Neo4j运维功能与关系型数据库运维基本类似，运维命令为Neo4j数据库自带命令，本实验主要基于Neo4j的离线备份与恢复实现，需要注意的是，在运行转储和恢复命令之前，应该关闭数据库。

### **实验环境**

Ubuntu 16.04

jdk1.8

Neo4j3.5.5

### **建议课时**

2课时

### **实验步骤**

一、开启Neo4j

在命令行下执行如下命令：

```markup
sudo neo4j start
```

启动完成后，浏览器打开

```markup
localhost:7474
```

提示输入密码，初始密码为neo4j，如下图：

![neo4j初始密码.png](./pic/neo4j初始密码.png)

初始密码输入后，需要修改密码，如下图：

![neo4j修改密码.png](./pic/neo4j修改密码.png)

修改密码完成后，如果可以看到如下图所示，则说明neo4j启动完成

![neo4j启动.png](./pic/neo4j启动.png)

在执行实验前删除所有数据：

```markup
MATCH (n) DETACH DELETE n
```

本书进行实验前，删除所有数据仅为查看方便，生产过程中执行此命令一定要慎重。

二、导入Neo4j数据

下载数据

```markup
cd ~
mkdir datadir
wget http://10.90.3.2/BDColl/Nosql/task14-3.zip
unzip task14-3.zip -d ./datadir
```

把数据导入到import目录下：

```markup
cd ~
sudo cp -r datadir/* /var/lib/neo4j/import
```

上面把本案例所需的数据导入到了neo4j的import目录下，下面介绍每个数据集的字段，以及对应的导入语句。

**以下命令均在neo4j的web客户端输入**

1.实体数据如下

1)教师people.csv。

id,school,college,name,rank,title,degree,graduation,research,email  
1,北京大学,计算机科学技术研究所,肖老师,教授,NULL,硕士,北京大学,图形与图像处理技术;网络与信息安全技术,xiaojianguo@pku.edu.cn   
2,清华大学,网络科学与网络空间研究院,吴老师,教授,院士,NULL,NULL,NULL,NULL  
...  
28,中国科学技术大学,网络空间安全学院,吴曼老师,教授/博导,院士,NULL,NULL,网络信息安全；大数据安全,qcmr@ustc.edu.cn  
29,中国科学技术大学,网络空间安全学院,郭老师,教授/博导,院士,NULL,NULL,量子信息；量子光学；信息安全,gcguo@ustc.edu.cn

执行导入语句：

```markup
LOAD CSV WITH HEADERS  FROM "file:///people.csv" AS line
MERGE (p:People{id:line.id,name:line.name,school:line.school,
college:line.college,rank:line.rank,title:line.title,
degree:line.degree,graduation:line.graduation,
research:line.research,email:line.email})
```

执行完成，会导入这29位教师信息，其中实体标签为People，包括属性id、name、degree、email等。

2) 高校school.csv。

高校实体包括高校id、高校名称、高校英文名称、高校类别等四个属性，具体数据如下：

id,name,ename,type  
s1,北京大学,Peking University,985  
s2,清华大学,Tsinghua University,985  
s3,武汉大学,Wuhan University,985  
s4,中国科学技术大学,University of Science and Technology of China,985

执行导入语句：

```markup
LOAD CSV WITH HEADERS  FROM "file:///school.csv" AS line
MERGE (p:School{id:line.id,name:line.name,ename:line.ename,type:line.type})
```

3)高校类别schooltype.csv。

高校类别实体包括985院校、211工程、双一流高校等。具体数据如下：

id,name  
c1,中国985高校  
c2,中国211高校  
c3,中国双一流高校

执行导入命令：

```markup
LOAD CSV WITH HEADERS  FROM "file:///schooltype.csv" AS line
MERGE (p: SchoolType{id:line.id,name:line.name})
```

4)教师群体 title.csv。

教师群体实体主要包括院士、长江学者等，读者也可以自行增加相关群体，如基金课题等。具体如下：

id,name  
t1,院士  
t2,长江学者

执行导入命令：

```markup
LOAD CSV WITH HEADERS  FROM "file:///title.csv" AS line
MERGE (p:Title{id:line.id,name:line.name})
```

导入完成，查看目前存在的节点标签和数量：

```markup
MATCH (n) RETURN DISTINCT labels(n), count(*)
```

返回值为：

│"labels(n)"│"count(\*)"│  
│\["People"\] │29     │  
│\["SchoolType"\]  │3     │  
│\["School"\] │4     │  
│\["Title"\]  │2     │

2.关系数据

1)教师-高校关系rel-ps.csv。

教师高校关系数据包括3个字段，from\_id表示教师id，type表示关系类别，to\_id表示教师所属学校id，具体如下：

from\_id,type,to\_id  
1,属于,s1  
2,属于,s2  
...  
28,属于,s4  
29,属于,s4

执行导入命令：

```markup
LOAD CSV WITH HEADERS FROM "file:///rel-ps.csv" AS line
MATCH  (from:People{id:line.from_id}),(to:School{id:line.to_id})
MERGE  (from)-[r:属于{type:line.type}]->(to)
```

2)学校-高校类别关系 rel-sc.csv。

学校-高校类别数据包括3个字段，from\_id表示学校id，type表示关系类别，to\_id表示学校所属的高校类别id，具体数据如下：

from\_id,type,to\_id  
s1,隶属,c1  
s2,隶属,c1  
s3,隶属,c1  
s4,隶属,c1

执行导入命令：

```markup
LOAD CSV WITH HEADERS FROM "file:///rel-sc.csv" AS line
MATCH  (from:School{id:line.from_id}),(to:SchoolType{id:line.to_id})
MERGE  (from)-[r:隶属{type:line.type}]->(to)
```

3)教师-教师群体关系 rel-pt.csv。

教师-教师群体数据包括3个字段，from\_id表示教师id，type表示关系类别，to\_id表示教师群体id，具体数据如下：

from\_id,type,to\_id  
2,是,t1  
11,是,t1  
28,是,t1  
29,是,t1  
4,是,t2

执行导入命令：

```markup
LOAD CSV WITH HEADERS FROM "file:///rel-pt.csv" AS line
MATCH  (from:People{id:line.from_id}),(to:Title{id:line.to_id})
MERGE  (from)-[r:是{type:line.type}]->(to)
```

到此完成了实体和关系的导入，下面查看下图数据库存在的全部路径：

```markup
MATCH p = (()-[]-()) RETURN p
```

从返回结果可以看到导入的实体和关系，返回结果如下所示。

![数据导入后结果.png](./pic/数据导入后结果.png)

三、查询语句

1.节点信息查询

使用MATCH指令查找name属性为 "杨老师”的节点信息，代码如下：

```markup
MATCH (people {name: "杨老师"}) RETURN people
```

在返回值展示方式中选择Table，返回值如下：

{  
 "college": "网络科学与网络空间研究院",  
 "graduation": "清华大学",  
 "school": "清华大学",  
 "degree": "博士",  
 "name": "杨老师",  
 "rank": "教授",  
 "id": "6",  
 "title": "NULL",  
 "research": "IPv6及新一代互联网体系结构;互联网络管理;网络测量与网络空间安全;云计算、虚拟化及资源管理调度",  
 "email": "yang@cernet.edu.cn"  
}

查询10个标签为People的节点的name属性，代码如下：

```markup
MATCH (p: People) RETURN p.name limit 10
```

在返回值展示方式中选择Table，返回值如下：

p.name  
"段老师"  
"杨老师"  
"王之老师"  
"张老师"  
"李老师"  
"吴黎老师"  
"窦老师"  
"杜老师"  
"崔老师"  
"陈老师"

查询匹配school属性为清华大学或北京大学的节点，代码如下：

```markup
MATCH (p: People)
WHERE p.school="清华大学" OR p.school="北京大学"
RETURN p.id, p.name, p.school
```

在返回值展示方式中选择Text，返回值如下：

│"p.id"│"p.name"│"p.school"│  
│"5"  │"段老师"  │"清华大学"   │  
│"6"  │"杨老师"  │"清华大学"   │  
│"7"  │"王之老师"  │"清华大学"   │  
│"8"  │"张老师"  │"清华大学"   │  
│"9"  │"李老师"  │"清华大学"   │  
│"2"  │"吴老师"  │"清华大学"   │  
│"3"  │"李老师"  │"清华大学"   │  
│"4"  │"毕老师"  │"清华大学"   │  
│"1"  │"肖老师"  │"北京大学"   │

2.关系查询

查找清华大学隶属的高校类别，代码如下：

```markup
MATCH (s: School {name: "清华大学"})-[:隶属]->(People)
RETURN s, People
```

在返回值展示方式中选择Text，返回值如下：

│"s"   │"People"           │  
│{"name":"清华大学","ename":"Tsinghua University","id":"s2","type":"985"}│{"name":"中国985高校","id":"c1"}│

查找清华大学的所有教师，代码如下：

```markup
MATCH (p)-[:属于]->(s: School {name: "清华大学"})
RETURN s, p
```

在返回值展示方式中选择Graph，返回值如图所示：

![清华大学的所有老师.png](./pic/清华大学的所有老师.png)

查找杨老师隶属于哪个高校，返回该高校的name属性值，代码如下：

```markup
MATCH (p {name:"杨老师"})-[:属于]->(School)
RETURN School.name
```

在返回值展示方式中选择Text，返回值如下：

│"School.name"│  
│"清华大学"    │

查找与"杨老师”同一个学校的老师，代码如下：

```markup
MATCH (p: People {name: "杨老师"})-[:属于]->(m)<-[:属于]-(coPeople)
RETURN coPeople.name, coPeople.school
```

在返回值展示方式中选择Text，返回值如下：

│"coPeople.name"│"coPeople.school"│  
│"李老师"      │"清华大学"      │  
│"吴老师"      │"清华大学"      │  
│"王之老师"     │"清华大学"      │  
│"李老师"      │"清华大学"      │  
│"张老师"      │"清华大学"      │  
│"段老师"      │"清华大学"      │  
│"毕老师"      │"清华大学"      │

查找与中国科学技术大学有关系的教师，代码如下：

```markup
MATCH (p:People)-[relateTo]-(s:School {name: "中国科学技术大学"})
RETURN p.name, type(relateTo), relateTo, s.name
```

在返回值展示方式中选择Text，返回值如下：

│"p.name"│"type(relateTo)"│"relateTo"  │"s.name"  │  
│"郭老师"  │"属于"       │{"type":"属于"}│"中国科学技术大学"│  
│"吴曼老师"  │"属于"       │{"type":"属于"}│"中国科学技术大学"│

3.查询关系路径

查找与"杨老师”存在3度及以内关系的老师和学校。

```markup
MATCH (p:People {name:"杨老师"})-[*1..3]-(s)
RETURN DISTINCT s
```

在返回值展示方式中选择Graph，返回值如下：

![关系路径返回值.png](./pic/关系路径返回值.png)

查找老师"杨老师”和"王老师”之间的最短关系路径，代码如下：

```markup
MATCH p=shortestPath(
 (b:People {name:"杨老师"})-[*]-(m:People {name:"王老师"}))
RETURN p
```

返回如下图所示，图中展示了"杨老师”属于清华大学， "王老师”属于武汉大学，他们通过985高校关联在一起。

![王老师和杨老师之间的最短路径.png](./pic/王老师和杨老师之间的最短路径.png)

4.好友推荐

1)给某老师推荐好友。

查找与"杨老师”没有直接合作，且与“杨老师”不在同一个教师群体，但与杨老师的同高校教师存在同一个教师群体的老师，并推荐该老师给“杨老师”，代码如下：

```markup
MATCH (p:People {name:"杨老师"})-[:属于]->(m)<-[:属于]-(中间人),
 (中间人)-[:是]->(m2)<-[:是]-(待推荐人)
WHERE NOT  (p)-[:是]->(m2)
RETURN m.name,m2.name,`中间人`.name,`待推荐人`.name as Recommended, count(*) as len
ORDER BY len DESC
```

上述代码有些复杂，对其进行描述：本次推荐存在一个“中间人”，“中间人”与“杨老师”属于同一所高校，且“中间人”与“待推荐人”属于同一个教师群体m2，同时“杨老师”不属于m2群体。返回值见下图：

![杨老师的好友推荐.png](./pic/杨老师的好友推荐.png)

2)找某两位老师存在共同关系的中间人。

如果清华大学的"杨老师”要认识武汉大学的"窦老师”，找出可以充当中间人的老师，代码如下：

```markup
MATCH (p:People {name:"杨老师"})-[:属于]->(m)<-[:属于]-(中间人),
 (中间人)-[:是]->(m2)<-[:是]-(c: People {name:"窦老师"})
RETURN p, m, 中间人, m2, c
```

返回值如下图所示：

![杨老师和窦老师之间的中间人.png](./pic/杨老师和窦老师之间的中间人.png)

### **实验总结**

本实验主要基于Neo4j完成了导入数据，查询数据，并基于Cypher实现了好友推荐，中间人查询等复杂场景。