### **实验目的**

掌握在Ubuntu操作系统下安装Neo4j

### **实验背景**

Neo4j是一个高性能的NoSQL图形数据库，它将结构化数据存储在网络上而不是表中。Neo4j是一个嵌入式的、基于磁盘的、具备完全的事务特性的Java持久化引擎。Neo4j也可以被看作是一个高性能的图引擎，该引擎具有成熟数据库的所有特性。使用Neo4j时，程序员工作在一个面向对象的、灵活的网络结构下，而不是严格、静态的表中，但是他们可以享受到具备完全的事务特性、企业级的数据库的所有好处。Neo4j因其具备的嵌入式、高性能、轻量级等优势，越来越受到人们的关注。

### **实验原理**

基于Ubuntu 16.04下完成Neo4j的安装启动。考虑到网络问题，本实验采用离线安装方式完成Neo4j的安装

### **实验环境**

Ubuntu 18.04

jdk8

neo4j 3.5

### **建议课时**

2课时

### **实验步骤**

一、jdk安装

1.下载jdk，neo4j 4.x支持的jdk11，通过wget命令下载

```markup
wget http://10.90.3.2/BDColl/Nosql/jdk-11.0.14_linux-x64_bin.tar.gz
```

![159671/preview](./pic/159671/preview)

2.解压下载下来的jdk安装包

```markup
tar -xzvf jdk-11.0.14_linux-x64_bin.tar.gz


```

![159672/preview](./pic/159672/preview)

3．查看解压缩文件

```markup
ls


```

![159662/preview](./pic/159662/preview)

4.配置环境变量，使用vi命令打开环境变量配置文件，在文件末尾添加java\_home等内容，如下：

```markup
vi ~/.bashrc


```

```markup
export JAVA_HOME=/home/ubuntu/jdk-11.0.14
export CLASSPATH=.:${JAVA_HOME}/lib
export PATH=${JAVA_HOME}/bin:$PATH


```

![159667/preview](./pic/159667/preview)

5.source环境变量，使配置生效。

```markup
source ~/.bashrc


```

![159666/preview](./pic/159666/preview)

6.检验是否安装成功，如图则表示jdk安装成功

```markup
java -version

```

![159669/preview](./pic/159669/preview)

二、安装neo4j

命令行下载：curl -O http://dist.neo4j.org/neo4j-community-3.5.5-unix.tar.gz

1.通过wget命令获取neo4j的安装文件

```markup
wget http://10.90.3.2/BDColl/Nosql/neo4j-community-4.3.10-unix.tar.gz	


```

![159673/preview](./pic/159673/preview)

2.解压下载下来的neo安装包

```markup
tar -xzvf neo4j-community-4.3.10-unix.tar.gz


```

![159676/preview](./pic/159676/preview)

3.查看解压缩文件

```markup
ls


```

![159664/preview](./pic/159664/preview)

4.重命名解压缩文件为neo4j

```markup
mv neo4j-community-4.3.10 neo4j
ls


```

![159663/preview](./pic/159663/preview)

5.切换到neo4j bin目录下，在终端输入：

```markup
cd neo4j/bin


```

![159665/preview](./pic/159665/preview)

6.启动Neo4j数据库，在终端输入：

```markup
./neo4j start


```

![159674/preview](./pic/159674/preview)

6.打开浏览器查看

登录 http://localhost:7474/查看，初次登陆默认用户名密码为neo4j。界面如下：

![159670/preview](./pic/159670/preview)

7.登录完成需要修改密码

![159668/preview](./pic/159668/preview)

8.登录成功，界面如下

![159675/preview](./pic/159675/preview)

### **实验总结**

本实验主要完成了在Ubuntu下安装Redis，安装Redis之前需要配置java开发环境，安装jdk。在安装过程中，我们熟练掌握了安装包获取命令、解压缩文件、配置环境变量、启动neo4j等命令，详尽使用，请参考官方文档