### **实验目的**

掌握APOC扩展的作用

掌握APOC扩展的安装

掌握APOC扩展的基本实验

### **实验背景**

APOC的名字最早来自于2009年，英文为 “A Package Of Components”，表示Neo4j的组件库，后来变为“Awesome Procedures On Cypher”，超级棒的Cypher过程。在《黑客帝国》电影中，APOC是Neo的队友，也是飞船的驾驶员，最后被叛徒Cypher杀害。

在APOC发布之前，开发人员需要为Cypher或Neo4j数据库尚未实现的常用功能编写过程和函数。每个开发人员都可能编写所需的函数，这会导致大量的重复。针对这种需求，Neo4j官方开发了一个过程和函数的标准库，即APOC库，在Neo4j3.3版本时，APOC成为了Neo4j的标准库。APOC库是用Java实现的，由450+个过程和函数组成（还在不断更新中），用于完成数据集成、图形算法或数据转换等领域的不同任务。与电影《黑客帝国》中情节不同的是，在Neo4j中，APOC提供的过程极大的增强了Cypher的表达能力。

### **实验原理**

APOC作为Neo4j的扩展库，使用安装均较为友好，只需要安装后，就可使用，读者主要掌握APOC提供了哪些常见的扩展，然后熟练使用即可.

本实验主要包括APOC安装，APOC介绍，APOC使用等几个部分。

### **实验环境**

Ubuntu 16.04

jdk1.8

Python3.6

Neo4j3.5.5

### **建议课时**

1课时

### **实验步骤**

一、APOC安装

1.APOC版本匹配

APOC依赖于Neo4j的内部api，在Neo4j时，需要使用匹配的APOC版本，确保Neo4j和APOC之间的前两个版本号匹配。

2.APOC版本选择

在Neo4j的APOC手册中有APOC的下载地址，通过链接下载指定的APOC版本，本实验环境在Neo4j的版本为3.5.5，选用APOC版本为3.5.0.11，下载地址为：

```markup
cd ~
wget http://10.90.3.2/BDColl/Nosql/task13-1.zip
unzip task13-1.zip

```

下载后的jar包为apoc-3.5.0.11-all.jar。

3.APOC安装

下载APOC的jar文件后，将jar文件复制到Neo4j的plugins目录下。在Ubuntu系统下，plugins路径为于/var/lib/neo4j/plugins。

```markup
cd ~
sudo cp apoc-3.5.0.11-all.jar /var/lib/neo4j/plugins

```

修改配置文件,在neo4j.conf 配置文件中添加：

```markup
cd /etc/neo4j
sudo vim neo4j.conf

```

修改配置文件：

```markup
dbms.security.procedures.unrestricted=apoc.*

```

该行配置语句可以完成APOC的函数和过程授权，不配置该行语句，在执行函数和过程时，可能会出现如下错误：apoc.algo.pagerank is not available due to having restricted sccess rights,check configuration

启动Neo4j服务:

```markup
sudo neo4j start

```

启动完成后，浏览器打开

```markup
localhost:7474

```

提示输入密码，初始密码为neo4j，如下图：

![neo4j初始密码.png](./pic/neo4j初始密码.png)

初始密码输入后，需要修改密码，如下图：

![neo4j修改密码.png](./pic/neo4j修改密码.png)

修改密码完成后，如果可以看到如下图所示，则说明neo4j启动完成

![neo4j启动.png](./pic/neo4j启动.png)

在可视化界面在输入如下命令:

```markup
return apoc.version()

```

如果出现对应的版本号，证明安装成功。

返回值为：

![](pic/APOCNEW1.jpg)



二、APOC使用

1.APOC提供的过程与函数概述

APOC提供了数据集成，数据导出，数据结构，高级图查询等诸多功能，本实验选取部分过程和函数进行演示。相比于过程，函数更容易理解，函数可以直接应用在Cypher查询中，对传入函数中的数据进行计算并返回计算后的结果，这点与Cypher内置的函数没有明显区别。过程的调用必须使用CALL命令，APOC中的过程可以类比与关系数据库中的存储过程。

APOC提供的过程与函数数量较多，在使用过程中若有需要基于APOC实现的，可以在官网手册中获得更详细的使用说明，读者在查看过程中，可以将APOC3.5版本的官网手册和APOC 4.1版本的官网手册对比阅读。

APOC提供的常见功能如下：

1)数据集成。

APOC库支持将各种数据格式(包括JSON、XML和XLS)导入到Neo4j数据库中，也可以从关系型数据库、Mongodb、ElasticSearch将数据导入Neo4j数据库中。这些过程大多位于apoc.load下，也有部分位于apoc.import、apoc.mongodb、apoc.es下。

2)数据导出。

Neo4j可以通过备份和转储命令导出整个数据库。但不支持导出子图或将数据导出为标准数据格式。APOC扩展了Neo4j的导出功能，Neo4j支持将数据导出为JSON、CSV、GraphML和Cypher脚本等格式。

APOC支持导出的过程大多位于apoc.export下。在将数据导出到文件系统时，可能存在权限问题，这时可以通过在neo4j.conf中设置以下属性来启用：

修改配置文件\*\*（本实验不需要执行）\*\*

cd /etc/neo4j  
vim neo4j.conf

添加如下配置\*\*（本实验不需要执行）\*\*

apoc.export.file.enabled=true

如果没有设置这个属性，在执行导出时，将得到以下错误消息:

Failed to invoke procedure apoc.export.csv.all: Caused by: java.lang.RuntimeException: Export to files not enabled, please set apoc.export.file.enabled=true in your neo4j.conf

3)数据结构。

APOC库提供了用于操作数据结构的函数和过程，对数据结构的操作主要分为三种，分别是转换功能（Conversion Functions），映射功能（Map Functions），集合功能（Collection Functions）。转换功能用于将值的类型强制转换，转换功能主要位于apoc.convert包下。映射功能用于对map类型进行操作，映射功能位于apoc.map包下。集合功能用于对集合和列表进行操中，主要位于apoc.coll包下。

4)时间格式操作。

APOC库提供了了对时间类型、时间戳和日期字符串值格式化的支持，这些函数主要位于apoc.temporal和apoc.date包下。

5)数学运算。

APOC提供了关于数学运算的函数和过程，具体包括数学运算功能（包括四舍五入、最大最小值等），精确计算功能，数字格式转换功能，位运算功能。其中数学运算函数主要位于apoc.math包下，精确计算函数位于apoc.number.exact包下，数字格式转换函数位于apoc.number包下，位运算操作位于apoc.bitwise包下。

6)高级图查询。

APOC库提供的高级图查询包含：扩展路径、扩展子图、邻居功能、路径操作、关系查询、节点查询、并行节点搜索等。相关的函数或过程主要位于：apoc.path、apoc.neighbors、apoc.rel、apoc.nodes、apoc.search等包中。

7)触发器。

APOC提供了类似关系数据库中的触发器功能，触发器功能可以在创建、更新或删除Neo4j中的数据时触发。相关的函数或过程主要位于apoc.trigger中，需要注意的是，如果启用apoc.trigger，需要在$NEO4J\_HOME/config/neo4j.conf中启用

apoc.trigger.enabled=true

8)文本和查找索引。

从3.5版开始，Neo4j提供了内置的、不区分大小写的、可配置的全文索引。原有的手工检索和全文检索（位于apoc.index）将逐渐被废弃。在表13-2中已经废弃apoc.index。全文索引的相关函数或过程位于apoc.schema包下。

9)图算法。

在算法方面，APOC库中提供了路径查找算法，相似性算法、社区检测算法、中心性算法等。在图算法方面，Neo4j有提供专用的图算法库Graph Algorithms Library，目前APOC库中除了路径查找算法外，其余算法将被弃用，即将被删除。如果要使用相关图算法，可使用图形算法库中的算法。路径查找算法主要位于apoc.algo包下。

2.APOC使用案例

**如下语句均在localhost:7474页面操作。**

1)APOC帮助命令。

查看apoc支持过程和函数：

```markup
call apoc.help('apoc')

```

返回值为apoc支持的过程，函数等，由于返回值较长，此处列出一条返回结果，为便于分析返回结果，将返回结果进行人工分行。

![](pic/APOCNEW2.jpg)



第1列的procedure表示类型为过程；

第2列的apoc.algo.aStar表示过程的名称；

第3列表示该过程的一个应用案例；

第4列（没有显示出来）为过程的签名信息，签名的一般形式是 name : : TYPE。在调用过程或函数时，通过签名可以获得对应参数的名称、类型及位置，同时还可获悉返回值列的名称和类型。

查看APOC支持的过程和函数数量：

```markup
CALL dbms.functions() YIELD name WHERE name STARTS WITH 'apoc.' RETURN COUNT(name)
UNION
CALL dbms.procedures() YIELD name WHERE name STARTS WITH 'apoc.' RETURN COUNT(name)

```

返回值为：

![](pic/APOCNEW3.jpg)



表示目前3.5.0.11版本的APOC包含了246个函数和294个过程，这个数量已经超过了APOC开发之初定下目标（365个过程或函数）。

2)APOC生成随机图。

本部分操作先删除图中的所有节点和关系，代码如下：

```markup
MATCH (n) DETACH DELETE n

```

基于APOC生成随机图，代码如下：

```markup
CALL apoc.generate.ba(10,2,'Person','朋友')

```

查看所有路径，代码如下：

```markup
MATCH p = (n)-[r]-(m) RETURN p

```

返回结果如图所示：

![APOC生成随机图返回结果.png](./pic/APOC生成随机图返回结果.png)

CALL apoc.generate.ba(10,2,'Person','朋友')中的ba表示Barabási–Albert模型，ba模型可以产生随机的算法无标度网络。

3)实现PageRank算法。

本部分操作先删除图中的所有节点和关系，代码如下：

```markup
MATCH (n) DETACH DELETE n

```

PageRank算法在Google的搜索引擎中用于计算网站的排名，PageRank的规则是：关系越多和与重要节点的关系越多，那么该节点就越重要。

首先创建1000个节点：

```markup
FOREACH (id In range(1,1000) | CREATE (n:NodeLabel{id:id}))

```

再创建100万个关系：

```markup
MATCH (n1:NodeLabel),(n2:NodeLabel) WITH n1,n2 LIMIT 1000000 WHERE rand()<0.1
CREATE (n1)-[:REL_TYPE]->(n2)

```

调用PageRank算法计算NodeLabel节点中的重要性排名，代码如下：

```markup
MATCH (n:NodeLabel) WITH collect(n) AS ns
CALL apoc.algo.pageRank(ns) YIELD node,score
RETURN node,score
ORDER BY score DESC LIMIT 10

```

这行代码建议添加LIMIT 10，否则会出现返回值计算时间过长的情况。返回结果如下图所示，从图中可以看出id为118的节点关系很多，将上面代码中的LIMIT 10 修改为LIMIT 1 ，返回值为 id为118的节点。

![](pic/APOCNEW4.jpg)



选择展示为Text，可以查看到pageRank算法计算得分的返回结果：

![](pic/APOCNEW5.jpg)



4)APOC函数使用。

APOC的函数使用与Cypher的内置函数使用基本一致，下面基于APOC完成一个均值计算，代码如下：

```markup
RETURN apoc.coll.avg([1,2,3,4,5]) AS output

```

apoc.coll.avg()为APOC提供的函数，在使用过程中，只需要将参数放如函数中，即可返回对应的返回值，返回值为：

![](pic/APOCNEW6.jpg)



基于APOC完成数据类型转换为字符串的操作，代码如下：

```markup
RETURN  apoc.convert.toStringList([1, "2", 3, "Four"]) AS output

```

返回值为：

![](pic/APOCNEW7.jpg)



返回值中，1也用双引号包裹起来，表明其数据类型的字符串。

### **实验总结**

本实验主要完成了APOC的介绍，安装，配置与基本使用，在使用过程中可以结合需求，参考官网实现更多的APOC练习。