### 实验目的

1.  掌握Java编程连接Mysql的方法和步骤
2.  掌握Python编程连接Mysql的方法和步骤

### **实验背景**

MySQL是一个关系型数据库管理系统，由瑞典MYSQL AB公司开发，属于Oracle旗下产品。MySQL 是最流行的关系型数据库管理系统之一，在WEB应用方面，MySQL是最好的RDBMS(Relational Database Management System，关系数据库管理系统) 应用软件之一。

MySQL作为一种关系型数据库管理系统，关系数据库将数据保存在不同的表中，而不是将所有数据放在一个大仓库内，这样就增加了速度并提高了灵活性。MySQL所使用的 SQL 语言是用于访问数据库的最常用标准化语言。

Java、Python语言是目前适用范围比较广且使用者最多的两种语言。

### **实验原理**

Java、Python语言是目前适用范围比较广且使用者最多的两种语言，且Python、Java都可通过相应的接口连接Mysql。

### **实验环境**

Ubuntu 18.04

JDK 1.8

Python 3.9

### **建议课时**

2课时

### **实验步骤**

#### 一、连接准备

1、打开终端

双击桌面上terminal图标，打开操作终端

![terminal.png](./pic/terminal.png)

2、启动Mysql并新建测试连接数据库

```markup
mysql -u root -p
```

输入mysql启动密码如123456，成功启动mysql

![connectmysql.png](./pic/connectmysql.png)

新建测试连接数据库test

```markup
create database test;
show databases;
```

![preview.png](./pic/preview.png)

新建测试所用的数据库表

```markup
use test;
create table websites(id int(20),name varchar(30),url varchar(40));
insert into websites values('1001','zhangsan','www.baidu.com');
select * from websites;
```

![websites.png](./pic/websites.png)

测试连接所用数据库及测试表准备完成，下面开发分别通过Python和Java远程连接mysql下的test数据库。

#### 二、Python连接Mysql

1、PyMySQL 是在 Python3.x 版本中用于连接 MySQL 服务器的一个库，先下载更新相关依赖

```markup
pip install pymysql==1.0.2
```

![installpymysql.png](./pic/installpymysql.png)

2、编写Python代码连接test数据库，在进行本文以下内容之前需要注意：

（1）你有一个MySQL数据库，并且已经启动。

（2）你有可以连接该数据库的用户名和密码

（3）你有一个有权限操作的test

新建connect.py文件

```markup
vim connect.py

```

按i进入编辑状态，:wq保存退出

在connect.py中输入以下代码

```markup
#!/usr/bin/python3
 
import pymysql
 
# 打开数据库连接 此处四个参数host为数据库地址，user为数据库用户名，password为数据库密码，database为连接数据库名称
db = pymysql.connect(host="localhost",user="root",password="123456",database="test" )
 
# 使用 cursor() 方法创建一个游标对象 cursor
cursor = db.cursor()
 
# 使用 execute()  方法执行 SQL 查询 
cursor.execute("SELECT VERSION()")
 
# 使用 fetchone() 方法获取单条数据.
data = cursor.fetchone()
 
print ("Database version : %s " % data)
 
# 关闭数据库连接
db.close()
```

3、运行上面的连接代码进行连接验证

```markup
python connect.py

```

![connectsuccessfull.png](./pic/connectsuccessfull.png)

执行以上脚本输出结果返回了数据库版本则表示连接成功。

#### 三、Java连接Mysql

1、打开Eclipse，选择自己的工作区“Workspace”，新建【JAVA Project】

![project.png](./pic/project.png)

2、新建工程名称，"Finish"，Java Project创建完成。

![project3.png](./pic/project3.png)

3、下载5.1.7下载驱动包

```markup
cd /home/ubuntu/Downloads
wget http://10.90.3.2/DevKit/DataBaseKit/mysql-connector-java-5.1.7.tar.gz

```

4、找到下载的驱动包并解压

```markup
tar -zxvf mysql-connector-java-5.1.7.tar.gz

```

5、右键上述步骤新建的工程，点击properties

![properties.png](./pic/properties.png)

6、点击Java Build Path，选择Libraties，点击右侧第二个Add External JARS

![addjar.png](./pic/addjar.png)

7、找到步骤4中解压后的驱动包，选择jar文件，点击OK。

![jarlujing.png](./pic/jarlujing.png)

8、点击Apply and Close完成所需jar包的引入。

![finishjar.png](./pic/finishjar.png)

9、找到上述新建工程下的src，右键选择package，新建包。

![package.png](./pic/package.png)

10、命名包为：com.connect

![package1.png](./pic/package1.png)

11、右键新建的package，选择class，新建Java类

![class.png](./pic/class.png)

12、输入class类名称，finish

![newclass.png](./pic/newclass.png)

13、打开.java文件，输入以下代码

```markup
package com.connect;

import java.sql.*;
public class MysqlDemo {
     // MySQL 8.0 以下版本 - JDBC 驱动名及数据库 URL
    static final String JDBC_DRIVER = "com.mysql.jdbc.Driver";  
    static final String DB_URL = "jdbc:mysql://localhost:3306/test";
     // MySQL 8.0 以上版本 - JDBC 驱动名及数据库 URL
    //static final String JDBC_DRIVER = "com.mysql.cj.jdbc.Driver";  
    //static final String DB_URL = "jdbc:mysql://localhost:3306/test?useSSL=false&allowPublicKeyRetrieval=true&serverTimezone=UTC";
     // 数据库的用户名与密码，需要根据自己的设置
    static final String USER = "root";
    static final String PASS = "123456";
     public static void main(String[] args) {
        Connection conn = null;
        Statement stmt = null;
        try{
            // 注册 JDBC 驱动
            Class.forName(JDBC_DRIVER);
            // 打开链接
            System.out.println("连接数据库...");
            conn = DriverManager.getConnection(DB_URL,USER,PASS);
            // 执行查询
            System.out.println(" 实例化Statement对象...");
            stmt = conn.createStatement();
            String sql;
            sql = "SELECT id, name, url FROM websites";
            ResultSet rs = stmt.executeQuery(sql);
        
            // 展开结果集数据库
            while(rs.next()){
                // 通过字段检索
                int id  = rs.getInt("id");
                String name = rs.getString("name");
                String url = rs.getString("url");
                    // 输出数据
                System.out.print("ID: " + id);
                System.out.print(", 站点名称: " + name);
                System.out.print(", 站点 URL: " + url);
                System.out.print("\n");
            }
            // 完成后关闭
            rs.close();
            stmt.close();
            conn.close();
        }catch(SQLException se){
            // 处理 JDBC 错误
            se.printStackTrace();
        }catch(Exception e){
            // 处理 Class.forName 错误
            e.printStackTrace();
        }finally{
            // 关闭资源
            try{
                if(stmt!=null) stmt.close();
            }catch(SQLException se2){
            }// 什么都不做
            try{
                if(conn!=null) conn.close();
            }catch(SQLException se){
                se.printStackTrace();
            }
        }
        System.out.println("Goodbye!");
    }
}



```

14、点击Eclipse上方的run，完成代码运行。

![runjava.png](./pic/runjava.png)

15、运行窗口查看运行结果。

![finishjava.png](./pic/finishjava.png)

### **实验总结**

通过本次实验，掌握了两种编程语言Python、Java远程连接Mysql的操作过程以及方法。