### 实验名称

HBase伪分布部署

### 实验目的

完成Hbase2.4.17的下载以及伪分布式的部署

### 实验背景

基于Ubuntu 18.04下部署Hbase2.4.17伪分布式

### 实验原理

Hbase是一个高可靠性、高性能、面向列、可伸缩的分布式数据库。利用Hbase技术可在廉价PC Server上搭建起大规模结构化存储集群。

Hbase是非关系型数据库，它不要求数据之间有严格的关系，同时它允许在同一列不同行中存储不同类型的数据。Hbase作为Hadoop框架下的数据库，是被设计成在一个服务器集群上运行的。

### 实验环境

Ubuntu 18.04

JDK 1.8

Hadoop 3.3.5

Hbase 2.4.17

### 建议课时

2课时

### 实验步骤

一、Hbase下载

1、打开终端

双击桌面上terminal图标，打开操作终端

![terminal.png](./pic/terminal.png)

2、打开终端输入如下命令下载提前准备好的HBASE包

```markup
wget http://10.90.3.2/DevKit/HadoopKit/hbase-2.4.17-bin.tar.gz
```

默认文件包下载在当前用户目录home/ubuntu下，ubuntu为当前用户名。

3、将压缩包解压到当前目录

```markup
tar xzvf hbase-2.4.17-bin.tar.gz
```

4、 将Hbase目录重命名为hbase

```markup
cd /home/ubuntu
mv hbase-2.4.17 hbase
```

二、 修改HBase的配置文件

1、首先修改配置文件hbase-env.sh

进入hbase的conf目录下

```markup
cd /home/ubuntu/hbase/conf
```

编辑配置文件hbase-env.sh

```markup
vi hbase-env.sh
```

在文件末尾添加如下信息：

```markup
export JAVA_HOME=/opt/jdk8
export HBASE_MANAGES_ZK=true
```

![env配置.png](./pic/env配置.png)

JAVA\_HOME为java的地址，本实验环境，java安装在/opt/jdk8目录。

export HBASE\_MANAGES\_ZK=true 此配置信息，表示设置由hbase自己管理zookeeper，不需要单独的zookeeper, 本文搭建的 Hbase 用的是自带的 zookeeper，故设置为true，注意该配置信息默认为true，若想使用单独的zookeeper，则需将该值设置为false。

2、修改配置文件hbase-site.xml

```markup
vi hbase-site.xml
```

添加hbase.rootdir属性信息，修改hbase.cluster.distributed的value值。其余信息保持不变

```markup
<configuration>
    <property>
        <name>hbase.rootdir</name>
        <value>hdfs://localhost:8020/hbase</value>
    </property>
    <property>
        <name>hbase.cluster.distributed</name>
        <value>true</value>
    </property>
</configuration>

```

![site文件.png](./pic/site文件.png)

hbase.rootdir：该参数制定了HReion服务器的位置，即数据存放的位置。主要端口号要和Hadoop相应配置一致。

hbase.cluster.distributed：HBase的运行模式。false是单机模式，true是分布式模式。若为false, HBase和Zookeeper会运行在同一个JVM里面。默认为false.

三、启动Hbase

1、启动hadoop服务，确保hdfs的正常运行

首先切换到hadoop安装目录

```markup
cd /opt/hadoop/sbin
```

初始化namenode:

```markup
hdfs namenode -format
```

启动hdfs:

```markup
./start-all.sh
```

使用jps命令查看Namenode和Datanode的服务是否正常启动。如图所示，说明启动成功。

![jps.png](./pic/jps.png)

2、启动Hbase

首先切换到HBase安装目录

```markup
cd /home/ubuntu/hbase

```

使用以下命令启动hbase：

```markup
bin/start-hbase.sh
```

![starthbase.png](./pic/starthbase.png) 

3、使用jps命令查看进程，在节点运行有Hmaster、HRegionServer和HQuorumPeer进程

![jps2.png](./pic/jps2.png)

4、停止Hbase

```markup
bin/stop-hbase.sh
```

### 实验总结

通过本次实验，掌握了Ubuntu下安装Hbase伪分布式的过程以及Ubuntu下Hbase的基本启动查看以及停止操作。