### **实验目的**

1、掌握Hbase 创建数据库表及删除数据库表

2、掌握Hbase 对数据库表数据的增、删、改、查

### 实验背景

基于Ubuntu 18.04下进行Hbase的数据库表创建删除操作以及数据库表的增删改查

### 实验原理

Hbase的数据模型：

Hbase是一个高可靠性、高性能、面向列、可伸缩的分布式数据库。利用Hbase技术可在廉价PC Server上搭建起大规模结构化存储集群。

Hbase是非关系型数据库，它不要求数据之间有严格的关系，同时它允许在同一列不同行中存储不同类型的数据。Hbase作为Hadoop框架下的数据库，是被设计成在一个服务器集群上运行的。

### **实验环境**

Ubuntu 18.04

JDK 1.8

Hadoop 3.3.5

Hbase：2.4.17

### **建议课时**

4课时

### **实验步骤**

1、打开终端

双击桌面上terminal图标，打开操作终端

![terminal.png](./pic/terminal.png)

2、启动hadoop及Hbase

我们需要进入 hadoop目录下的sbin文件夹中。

```markup
cd /opt/hadoop/sbin/
```

初始化namenode：

```markup
hdfs namenode -format
```

启动hdfs：

```markup
./start-all.sh
```

使用start-hbase.sh命令启动hbase

```markup
cd /opt/hbase/bin/
./start-hbase.sh 
```

使用hbase shell命令来连接正在运行的Hbase实例，该命令位于HBase安装包下的bin/目录。HBase Shell提示符以>符号结束。

```markup
./hbase shell
```

![QQ截图20240115113830-1.png](./pic/QQ截图20240115113830-1.png)

3.Hbase 创建数据库表

创建数据库表的命令：create '表名', '列族名1','列族名2','列族名N'

例如：以下示例创建了数据库表 user，以及定义两个列族:

```markup
create 'user','info1','info2'
```

如果想查看所有数据库表，可以使用 list 命令：

```markup
list
```

![user表.png](./pic/user表.png)

可以看到，刚创建的数据库表user 已经在数据库表的列表中，如果要看user表的结构，可以用describe命令，如下截图所示：

```markup
describe'user'
```

![describe.png](./pic/describe.png)

通过命令：count '表名' 来查看表中的所有记录的数量(根据rowKey来计算)；

```markup
count 'user'
```

![countuser.png](./pic/countuser.png)

4、Hbase数据库表数据的增、删、改、查

（1）Hbase 增加数据的语法格式如下：

put‘表名’, ‘rowKey’, ‘列族 : 列’ , '值'

```markup
put 'user', '1234', 'info1:Name','zhangsan'
```

![put.png](./pic/put.png)

（2）Hbase 查询数据的语法格式如下：

scan‘表名’来查看表的所有记录；

```markup
scan 'user'
```

![scan.png](./pic/scan.png)

get '表名' , 'rowKey' 来查看某个rowKey下的所有记录；

```markup
get 'user','1234'
```

![get.png](./pic/get.png)

get '表名','rowkey','列族' 来查看某个rowKey列族的记录；

```markup
get 'user','1234','info1'
```

![get2.png](./pic/get2.png)

get '表名','rowkey','列族：列’来查看rowKey列族的某个列记录；

```markup
get 'user','1234','info1:Name'
```

![get3.png](./pic/get3.png)

（3）Hbase 删除数据的语法格式如下：

delete‘表名’,‘行名’,‘列族：列' 来删除某个记录；

```markup
delete 'user','1234','info1:Name'
```

![delete.png](./pic/delete.png)

get来查询删除的记录是否删除成功；

```markup
get 'user','1234','info1:Name'
```

![get4.png](./pic/get4.png)

deleteall '表名','rowkey' 来删除整行记录；

```markup
deleteall 'user','1234'
```

![QQ截图20240115114213.png](./pic/QQ截图20240115114213.png)

truncate '表名' 来清空表所有的记录；

```markup
truncate 'user'
```

![truncate.png](./pic/truncate.png)

（4）Hbase 更新数据的语法格式如下：

put就是重写一遍，进行覆盖，hbase没有修改，都是追加，即对相同rowKey、列族和列名的数据再次添加即为数据的更新

```markup
put 'user', '1234', 'info1:Name','zhangsan'
```

再次追加：

```markup
put 'user', '1234', 'info1:Name','zhangsan1'
```

使用scan查看rowKey=1234的列族info的栏位name的值被成功改为zhangsan1，操作过程如下图所示：

```markup
scan 'user'
```

![scan2-1645069159527.png](./pic/scan2-1645069159527.png)

5、Hbase 删除数据库表

删除数据表的语法格式如下：

drop '表名'

在删除表时，先要屏蔽该表，才能对该表进行删除；

第一步: disable ‘表名’，第二步，查看表是否可用，第二步 :drop '表名'，具体操作如下图所示：

```markup
drop 'user'
```

![dropuser.png](./pic/dropuser.png)

### **实验总结**

通过本次实验，掌握了Ubuntu下Hbase 创建数据库表及删除数据库表以及Hbase 对数据库表数据的增、删、改、查操作。