### **实验目的**

掌握在Ubuntu操作系统下安装Redis

### **实验背景**

Redis是一种非关系型数据库，是一个高性能的key-value数据库。它支持主从同步，数据可以由主服务器向从服务器同步，从服务器也可以关联其他从服务器的主服务器。本实验主要介绍Ubuntu操作系统下Redis安装过程。本次实验要安装的Redis版本是较新的稳定版本v7.0.12

### **实验原理**

在Ubuntu上安装Redis有2种方式，第一种是下载安装包，第二种是Ubuntu在线安装。本实验采用第二种在线获取安装包，并完成Redis的安装配置

### **实验环境**

Ubuntu 18.04

### **建议课时**

1课时

### **实验步骤**

1、执行sudo apt-get update更新软件包

```markup
sudo apt-get update
```

结果如下图：

![update.jpg](./pic/update.jpg)

2、执行sudo apt-get install redis-server ，安装redis

```markup
sudo apt-get install redis-server
```

![getpackage.jpg](./pic/getpackage.jpg)

输入y 确认安装redis-server：

![y.jpg](./pic/y.jpg)

3、启动redis-server，执行如下命令 sudo service redis-server start

```markup
sudo service redis-server start
```

![start.jpg](./pic/start.jpg)

4、执行完成后，查看Redis服务的状态，执行sudo service redis-server status，状态如果为running，说明安装完成后系统自动启动了服务。如果为not running，说明配置有问题，可以在后续的配置中修改配置后重启正常启动。

```markup
sudo service redis-server status
```

![status.jpg](./pic/status.jpg)

5、执行命令whereis redis 可以查看配置文件所在位置

```markup
sudo whereis redis
```

![whereis.jpg](./pic/whereis.jpg)

6、修改配置文件 /etc/redis/redis.conf。Redis端口默认端口是6379，此处不再单独配置，如有需要也可在配置文件里修改。

 使用vi命令打开配置文件

```markup
sudo vi /etc/redis/redis.conf
```

![vi.jpg](./pic/vi.jpg)

(1)、要远程连接Redis，需要注释掉配置文件中的 bind 127.0.0.1。

![binglocal.jpg](./pic/binglocal.jpg)

(2)、修改保护模式protected-mode由yes修改为no：

![image_course_1653_user_3165_assignment_16600_1695267032825.png](./pic/image_course_1653_user_3165_assignment_16600_1695267032825.png)

(3)、在文件末尾添加 requirepass 123456，用于配置密码

```markup
requirepass 123456
```

![password.jpg](./pic/password.jpg)

7、重启Redis，命令sudo service redis-server restart

```markup
sudo service redis-server restart
```

![restart.jpg](./pic/restart.jpg)

8、通过sudo netstat –talnp命令查看端口情况，Redis server连接正常，可用于远程连接

```markup
sudo netstat -talnp
```

![验证.jpg](./pic/验证.jpg)

9、查看redis版本号：

![WechatIMG567.jpg](./pic/WechatIMG567.jpg)

### **实验总结**

本实验主要完成了在Ubuntu下安装Redis v7.0.12，在安装过程中，熟练掌握了安装包获取命令、查看redis服务状态命令的使用及通过配置文件配置Redis密码及实现远程连接。