### **实验目的**

掌握在Ubuntu18下源码安装Redis-server

### **实验背景**

Redis是一种非关系型数据库，是一个高性能的key-value数据库。它支持主从同步，数据可以由主服务器向从服务器同步，从服务器也可以关联其他从服务器的主服务器。本实验主要介绍Ubuntu操作系统下Redis安装过程。本次实验要安装的Redis版本是较新的稳定版本v7.0.12

### **实验原理**

你可以通过两种方式在Ubuntu上安装Redis。一种是从Redis官方网站下载Redis源代码并进行编译安装，另一种是使用Ubuntu的包管理工具直接在线安装Redis软件包。这里我们使用第一种源码安装方式。

### **实验环境**

Ubuntu 18.04

### **建议课时**

1课时

### **实验步骤**

1．执行sudo apt update更新软件包

```markup
sudo apt update
```

![image_course_1653_user_45_assignment_16600_1703141299196.png](./pic/image_course_1653_user_45_assignment_16600_1703141299196.png)

2\. 下载7.0.12的Redis源代码。在终端中执行以下命令

```markup
cd  /usr/local/src
sudo wget http://10.90.3.2/HUP/NoSQL/2023/redis-7.0.12.tar.gz
```

3\. 编译安装

#安装依赖gcc和tcl，中途输入Y确认继续安装

```markup
sudo apt install make gcc tcl
```

#解压文件

```markup
sudo tar -zxzf redis-7.0.12.tar.gz
```

![image_course_1653_user_45_assignment_16600_1703144078366.png](./pic/image_course_1653_user_45_assignment_16600_1703144078366.png)

4\. 进入解压后redis目录

```markup
cd redis-7.0.12
```

在该目录下执行make命令编译并安装

```markup
sudo make && sudo make install
```

![image_course_1653_user_45_assignment_16600_1703144289627.png](./pic/image_course_1653_user_45_assignment_16600_1703144289627.png)

安装结束后，默认的安装目录是 /usr/local/bin 目录下，该目录默认配置到环境变量，所以可以在任意位置允许该目录下的命令，其中：

redis-cli：Redis 提供的命令行客户端  
redis-server：Redis 的服务端启动脚本  
redis-sentinel：Redis 的哨兵启动脚本

![image_course_1653_user_45_assignment_16600_1703144991022.png](./pic/image_course_1653_user_45_assignment_16600_1703144991022.png)

5.后台启动

如果要 Redis 以后台运行，必须修改 Redis 配置文件 redis.conf。

将 /usr/local/src/redis-7.0.12/redis.conf 复制到 /etc/redis/redis.conf ：

```markup
# 创建目录
sudo mkdir /etc/redis
# 复制文件													
sudo cp /usr/local/src/redis-7.0.12/redis.conf /etc/redis/redis.conf	
cd /etc/redis	
```

![image_course_1653_user_45_assignment_16600_1703145146631.png](./pic/image_course_1653_user_45_assignment_16600_1703145146631.png)

打开 /etc/redis/redis.conf 文件，并根据您的需求进行相应的修改。以下是一些要注意的配置项：

bind：默认绑定本地回环地址（localhost）即可，如果需要远程访问，可以修改为服务器的 IP 地址。

protected-mode：默认启用保护模式，如果你确定你的 Redis 实例是在一个安全的网络环境中，可以将其设置为 no。

daemonize：默认以前台运行，若要在后台运行，请将其设置为 yes。

logfile：可以指定 Redis 的日志文件路径和名称。

\# 密码，默认没有密码，设置后访问redis必须输入密码

\# 如果是本地访问使用则无需设置密码，如果需要远程访问，则一点要设置密码

requirepass 123456

其他配置项可以根据需要进行相应的修改。

```markup
sudo vim  /etc/redis/redis.conf
```

![image_course_1653_user_45_assignment_16600_1703146791947.png](./pic/image_course_1653_user_45_assignment_16600_1703146791947.png)

![image_course_1653_user_45_assignment_16600_1703146866440.png](./pic/image_course_1653_user_45_assignment_16600_1703146866440.png)

![image_course_1653_user_45_assignment_16600_1703146824337.png](./pic/image_course_1653_user_45_assignment_16600_1703146824337.png)

6\. 启动 Redis：

```markup
cd /etc/redis				# 进入目录
redis-server redis.conf		# 携带配置文件启动
ps -ef | grep redis			# 查看redis进程
```

注：若运行redis-server redis.conf时出现如下警告：

\# WARNING Memory overcommit must be enabled! Without it, a background save or replication may fail under low memory condition. Being disabled, it can also cause failures without low memory condition, see https://github.com/jemalloc/jemalloc/issues/1328. To fix this issue add 'vm.overcommit\_memory = 1' to /etc/sysctl.conf and then reboot or run the command 'sysctl vm.overcommit\_memory=1' for this to take effect.

按照提示执行命令sysctl vm.overcommit\_memory=1，再次运行redis-server redis.conf即可。

可以通过ps -ef | grep redis命令查看Redis是否正常运行。

```markup
ps -ef | grep redis
```

![image_course_1653_user_45_assignment_16600_1703147059201.png](./pic/image_course_1653_user_45_assignment_16600_1703147059201.png)

您也可以使用以下命令验证Redis Server是否正在运行：

```markup
redis-cli -a 123456 ping
```

![image_course_1653_user_45_assignment_16600_1703147370882.png](./pic/image_course_1653_user_45_assignment_16600_1703147370882.png)

如果Redis Server运行正常，您将收到PONG响应。

现在，您已经成功地在Ubuntu 18上安装了Redis Server 7.0.12。

7\. 查看redis版本号：

![image_course_1653_user_45_assignment_16600_1703147512866.png](./pic/image_course_1653_user_45_assignment_16600_1703147512866.png)

### **实验总结**

在本次实验中，我们成功地在Ubuntu 18.04操作系统上进行了Redis Server 7.0.12的源码安装。通过该实验，我们掌握了源码安装Redis的基本步骤和原理，并且了解了一些与安装相关的重要配置项。

在实验的过程中，我们执行了以下主要步骤：

更新软件包列表并安装必要的依赖工具。

下载并解压Redis 7.0.12的源代码包。

编译安装Redis 7.0.12。

针对需要的配置项，如后台运行、访问密码等，对Redis的配置文件进行了修改。

最终成功启动了Redis Server，并验证了Redis Server的正常运行。

总结来说，通过本次实验，我们对源码安装Redis有了更深入的了解，也掌握了在Ubuntu 18.04上进行这一过程的具体操作步骤。源码安装为我们提供了更多自定义的选项和配置，能够更灵活地满足特定需求。希望本次实验能够帮助大家更好地理解和应用Redis在Ubuntu上的安装过程。