### **实验目的**

掌握Redis的基本命令

### **实验背景**

Redis是一种非关系型数据库，是一个高性能的key-value数据库。本实验主要介绍Redis的键的基本命令的使用。

### **实验原理**

Redis 命令用于在 redis 服务上执行操作。要在 redis 服务上执行命令需要一个 redis 客户端。Redis 键相关的基本命令包括key的通用操作、key的扩展操作、查询操作及其他操作。key基本操作有删除指定key: del key，判断key是否存在：exists key，获取key的类型：type key 等。key扩展操作主要有有效期设定，判断是否有效，有效状态的切换等。其他操作主要为重命名排序等。

### **实验环境**

Ubuntu 18.04

redis 7.0.12

### **建议课时**

2课时

### **实验步骤**

一 、启动redis服务并打开redis客户端

1、打开桌面终端terminal，输入redis-server

```markup
redis-server
```

2、另外启动一个终端terminal。

3、输入命令： $ redis-cli 进入redis客户端

```markup
redis-cli
```

![9.1rediscli.jpg](./pic/9.1rediscli.jpg)

二．redis基本命令

1、使用set 、hset命令设置键及值

```markup
set key1 value1

```

```markup
hset hset1 hset1 hvalue1
```

![9.1 set.jpg](./pic/9.1 set.jpg)

2、使用type命令判断键的类型

```markup
type key1
```

```markup
type hset1
```

![9.1type.jpg](./pic/9.1type.jpg)

3、使用exists命令判断key是否存在

```markup
exists key1
```

```markup
exists hset1
```

![9.1exists.jpg](./pic/9.1exists.jpg)

4、使用del命令删除 健。

```markup
del key1
```

```markup
del hset1
```

![9.1del.jpg](./pic/9.1del.jpg)

5、使用expire命名设置键的有效期，ttl命令查看键的剩余有效期

```markup
set key1 value1
```

```markup
expire key1 60
```

```markup
ttl key1
```

![9.1设置key有效期.jpg](./pic/9.1设置key有效期.jpg)

6、使用persists命名设置键为永久有效。

```markup
persist key1
```

```markup
ttl key1
```

![9.1设置永久有效期.jpg](./pic/9.1设置永久有效期.jpg)

7、使用通配符对key进行模糊查询 

```markup
keys *
```

![9.1key通配查询.jpg](./pic/9.1key通配查询.jpg)

8、使用rename、renamenx对key重命名

```markup
rename key1 key2
```

```markup
get key2
```

```markup
renamenx key2 key3
```

```markup
get key3
```

![9.1rename.jpg](./pic/9.1rename.jpg)

![9.1renamenx.jpg](./pic/9.1renamenx.jpg)

9、使用sort命名实现键值排序

```markup
lpush m1 1
```

```markup
lpush m1 2
```

```markup
lpush m1 3
```

```markup
lpush m1 4
```

```markup
sort m1
```

```markup
sort m1 desc
```

**![9.1sort.jpg](./pic/9.1sort.jpg)**

### **实验总结**

本实验主要是redis基本命令的使用，通过本实验的操作，可以熟悉并快速掌握redis的基本命令的使用，包括键的基本操作、扩展操作、查询操作及其他操作，更多命令使用，读者可通过查询官网扩展。