### **实验目的**

掌握Redis集合数据类型的基本操作

### **实验背景**

Redis是一种非关系型数据库，是一个高性能的key-value数据库。Redis支持的五种数据类型，包括字符串、哈希、列表、集合、有序集合。本实验主要是集合相关命令的基本操作。

### **实验原理**

Redis 的 Set 是 String 类型的无序集合。集合成员是唯一的，这就意味着集合中不能出现重复的数据。Redis 中集合是通过哈希表实现的，所以添加，删除，查找的复杂度都是 O(1)。

### **实验环境**

Ubuntu 18.04

redis 7.0.12

### **建议课时**

2课时

### **实验步骤**

一 、启动redis服务并打开redis客户端

1、打开桌面终端terminal，输入redis-server:

```markup
redis-server
```

2、打开另外一个终端terminal。

3、输入命令： $ redis-cli 进入redis客户端

```markup
redis-cli
```

![9.2.3rediscli.jpg](./pic/9.2.3rediscli.jpg)

二、集合的基本操作

1、 向集合添加一个或多个成员

Redis Sadd 命令将一个或多个成员元素加入到集合中，已经存在于集合的成员元素将被忽略。假如集合 key 不存在，则创建一个只包含添加的元素作成员的集合。

命令：Sadd。

格式：SADD KEY\_NAME VALUE1..VALUEN。

返回值:被添加到集合中的新元素的数量，不包括被忽略的元素。

实例：

```markup
SADD myset "hello"
```

```markup
SADD myset "foo"
```

```markup
SADD myset "hello"
```

```markup
SMEMBERS myset
```

![9.2.3sadd.jpg](./pic/9.2.3sadd.jpg)

2、返回集合中的所有成员

Redis Smembers 命令返回集合中的所有的成员。 不存在的集合 key 被视为空集合。

命令：Smembers。

格式：SMEMBERS KEY VALUE。

返回值:集合中的所有成员。

实例：

```markup
SMEMBERS myset
```

![9.2.3sembers.jpg](./pic/9.2.3sembers.jpg)

3、判断 member 元素是否是集合 key 的成员

Redis Sismember 命令判断成员元素是否是集合的成员。

命令：Sismember。

格式：SISMEMBER KEY VALUE。

返回值: 如果成员元素是集合的成员，返回 1 。如果成员元素不是集合的成员，或 key 不存在，返回 0 。

实例：

```markup
SADD myset1 "hello"
```

```markup
SISMEMBER myset1 "hello"
```

![sismember.jpg](./pic/sismember.jpg)

4、迭代集合中的元素

Redis Sscan 命令用于迭代集合键中的元素。

命令：Sscan。

格式：SSCAN KEY \[MATCH pattern\] \[COUNT count\]。

返回值: 数组列表。

实例：

```markup
SADD myset1 "hello"
```

```markup
SADD myset1 "hi"
```

```markup
SADD myset1 "bar"
```

```markup
sscan myset1 0 match h*
```

![9.2.3sscan.jpg](./pic/9.2.3sscan.jpg)

5、移除并返回集合中的一个随机元素

Redis Spop 命令用于移除并返回集合中的一个随机元素。

命令：Spop。

格式：SPOP KEY。

返回值: 被移除的随机元素。当集合不存在或是空集时，返回 nil 。

实例：

```markup
SMEMBERS myset1
```

```markup
SPOP myset1
```

```markup
SMEMBERS myset1
```

![9.2.3spop.jpg](./pic/9.2.3spop.jpg)

6、返回所有给定集合的并集

Redis Sunion 命令返回给定集合的并集。不存在的集合 key 被视为空集。

命令：Sunion。

格式：SUNION KEY KEY1..KEYN。

返回值:并集成员的列表。

实例：

```markup
SADD myset2 "hello" "world"
```

```markup
SADD myset3 "hello" "guys"
```

```markup
SUNION myset2 myset3
```

![9.2.3sunion.jpg](./pic/9.2.3sunion.jpg)

7、获取集合的成员数

Redis Scard 命令返回集合中元素的数量。

命令：Scard。

格式：SCARD KEY\_NAME。

返回值: 集合的数量。 当集合 key 不存在时，返回 0 。

实例：

```markup
SADD myset4 "hello" "hi" "hello" "hi"
```

```markup
SCARD myset4
```

![9.2.3scardn.jpg](./pic/9.2.3scardn.jpg)

8、返回集合中一个或多个随机数

Redis Srandmember 命令用于返回集合中的一个随机元素。 Srandmember 命令接受可选的 count 参数：

如果 count 为正数，且小于集合基数，那么命令返回一个包含 count 个元素的数组，数组中的元素各不相同。如果 count 大于等于集合基数，那么返回整个集合。如果 count 为负数，那么命令返回一个数组，数组中的元素可能会重复出现多次，而数组的长度为 count 的绝对值。

命令：Srandmember。

格式：SRANDMEMBER KEY \[count\]。

返回值:只提供集合 key 参数时，返回一个元素；如果集合为空，返回 nil 。 如果提供了 count 参数，那么返回一个数组；如果集合为空，返回空数组。

实例：

```markup
SRANDMEMBER myset4
```

```markup
SRANDMEMBER myset4 3
```

![9.2.3srandnumber.jpg](./pic/9.2.3srandnumber.jpg)

9、返回给定所有集合的交集

Redis Sinter 命令返回给定所有给定集合的交集。 不存在的集合 key 被视为空集。 当给定集合当中有一个空集时，结果也为空集(根据集合运算定律)。

命令：Sinter。

格式：SINTER KEY KEY1..KEYN。

返回值: 交集成员的列表。

实例：

```markup
SADD myset5 "hello" "hi" "nihao"
```

```markup
SADD myset6  "world" "hi" "nihao"
```

```markup
SINTER myset5 myset6
```

![9.2.3sinter.jpg](./pic/9.2.3sinter.jpg)

10、移除集合中一个或多个成员

Redis Srem 命令用于移除集合中的一个或多个成员元素，不存在的成员元素会被忽略。

当 key 不是集合类型，返回一个错误。

命令：Srem。

格式：SREM KEY MEMBER1..MEMBERN。

返回值:被成功移除的元素的数量，不包括被忽略的元素。

实例：

```markup
SREM myset5 "hello"
```

```markup
SREM myset5 "foo"
```

```markup
SMEMBERS myset5
```

![9.2.3srem.jpg](./pic/9.2.3srem.jpg)

11、将 member 元素从 source 集合移动到 destination 集合

Redis Smove 命令将指定成员 member 元素从 source 集合移动到 destination 集合。

命令：Smove。

格式：SMOVE SOURCE DESTINATION MEMBER。

返回值:如果成员元素被成功移除，返回 1 。 如果成员元素不是 source 集合的成员，并且没有任何操作对 destination 集合执行，那么返回 0 。

实例：

```markup
SADD myset7 "hello" "hi" "nihao"

```

```markup
SADD myset8 "foo" "hello"
```

```markup
SMOVE myset7 myset8 "hi"
```

```markup
SMEMBERS myset7
```

```markup
SMEMBERS myset8
```

![9.2.3smove.jpg](./pic/9.2.3smove.jpg)

12、返回给定所有集合的差集并存储在 destination 中

Redis Sdiffstore 命令将给定集合之间的差集存储在指定的集合中。如果指定的集合 key 已存在，则会被覆盖。

命令：Sdiffstore。

格式：SDIFFSTORE DESTINATION\_KEY KEY1..KEYN。

返回值:结果集中的元素数量。

实例：

```markup
SDIFFSTORE destset myset7 myset8
```

```markup
SMEMBERS destset
```

![9.2.3sdiffstore.jpg](./pic/9.2.3sdiffstore.jpg)

13、返回给定所有集合的差集

Redis Sdiff命令返回给定集合之间的差集。不存在的集合 key 将视为空集。

命令：Sdiff。

格式：SDIFF FIRST\_KEY OTHER\_KEY1..OTHER\_KEYN。

返回值:包含差集成员的列表。

实例：

```markup
SDIFF myset7 myset8
```

![9.2.3sdiff.jpg](./pic/9.2.3sdiff.jpg)

14、返回给定所有集合的交集并存储在 destination 中

Redis Sinterstore 命令将给定集合之间的交集存储在指定的集合中。如果指定的集合已经存在，则将其覆盖。

命令：Sinterstore。

格式：SINTERSTORE DESTINATION\_KEY KEY KEY1..KEYN。

返回值:交集成员的列表。

实例：

```markup
SINTERSTORE newset myset7 myset8
```

```markup
SMEMBERS newset
```

![9.2.3sinterstore.jpg](./pic/9.2.3sinterstore.jpg)

15、所有给定集合的并集存储在 destination 集合中

Redis Sunionstore 命令将给定集合的并集存储在指定的集合 destination 中。

命令：Sunionstore。

格式：SUNIONSTORE DESTINATION KEY KEY1..KEYN。

返回值:结果集中的元素数量。

实例：

```markup
SUNIONSTORE newset2  myset7 myset8 
```

```markup
SMEMBERS newset2
```

![9.2.3sunionstore.jpg](./pic/9.2.3sunionstore.jpg)

### **实验总结**

本实验主要是redis集合数据类型的基本操作，通过本实验的操作，可以熟悉并快速掌握redis集合的相关操作命令，更多命令使用，读者可通过查询官网扩展。