### **实验目的**

掌握Redis列表数据类型的基本操作

### **实验背景**

Redis是一种非关系型数据库，是一个高性能的key-value数据库。Redis支持的五种数据类型，包括字符串、哈希、列表、集合、有序集合。本实验主要是列表相关命令的基本操作。

### **实验原理**

Redis列表是简单的字符串列表，按照插入顺序排序。可以添加一个元素到列表的头部(左边)或者尾部(右边)。

### **实验环境**

Ubuntu 18.04

redis 7.0.12

### **建议课时**

2课时

### **实验步骤**

一 、启动redis服务，打开redis客户端。

1、打开桌面终端terminal，输入redis-server:

```markup
redis-server
```

2、打开另外一个终端terminal。

3、输入命令： $ redis-cli 进入redis客户端

```markup
redis-cli

```

![9.2.2rediscli.jpg](./pic/9.2.2rediscli.jpg)

二、列表的基本操作

1、将一个或多个值插入到列表的尾部(最右边)

命令：Rpush。

格式：RPUSH KEY\_NAME VALUE1..VALUEN。

返回值：列表的长度。

```markup
RPUSH mylist "hello"
RPUSH mylist "bar"
LRANGE mylist 0 -1

```

![9.2.2rpush.jpg](./pic/9.2.2rpush.jpg)

2、为已存在的列表添加值

Redis Rpushx 命令用于将一个或多个值插入到已存在的列表尾部(最右边)。如果列表不存在，操作无效。

命令：Rpushx。

格式：RPUSHX KEY\_NAME VALUE1..VALUEN。

返回值：执行 Rpushx 操作后，列表的长度。

```markup
RPUSHX mylist "bar"
LRANGE mylist 0 -1
RPUSHX mylist2 "bar"

```

![9.2.2rpushx.jpg](./pic/9.2.2rpushx.jpg)

3、将一个或多个值插入到列表头部

Redis Lpush 命令将一个或多个值插入到列表头部。如果 key 不存在，一个空列表会被创建并执行 Lpush操作。 当 key 存在但不是列表类型时，返回一个错误。

命令：Lpush。

格式：LPUSH KEY\_NAME VALUE1.. VALUEN。

返回值：执行 Lpush命令后，列表的长度。

```markup
LPUSH list1 "foo"
LPUSH list1 "bar"
LRANGE list1 0 -1

```

![9.2.2Lpush.jpg](./pic/9.2.2Lpush.jpg)

4、通过索引获取列表中的元素

Redis Lindex 命令用于通过索引获取列表中的元素。你也可以使用负数下标，以 -1 表示列表的最后一个元素， -2 表示列表的倒数第二个元素，以此类推。

命令：Lindex。

格式：LINDEX KEY\_NAME INDEX\_POSITION。

返回值:列表中下标为指定索引值的元素。 如果指定索引值不在列表的区间范围内，返回 nil 。

```markup
LINDEX mylist 0
LINDEX mylist -1
LINDEX mylist 3

```

![9.2.2Lpushx.jpg](./pic/9.2.2Lpushx.jpg)

5、获取列表指定范围内的元素

Redis Lrange 返回列表中指定区间内的元素，区间以偏移量 START 和 END 指定。 其中 0 表示列表的第一个元素， 1 表示列表的第二个元素，以此类推。 你也可以使用负数下标，以 -1 表示列表的最后一个元素， -2 表示列表的倒数第二个元素，以此类推。

命令：Lrange。

格式：LRANGE KEY\_NAME START END。

返回值：一个列表，包含指定区间内的元素。

```markup
lrange mylist 0 -1
lrange mylist 1 -1

```

![9.2.2Lrange.jpg](./pic/9.2.2Lrange.jpg)

6、移除列表的最后一个元素，并将该元素添加到另一个列表并返回

Redis Rpoplpush 命令用于移除列表的最后一个元素，并将该元素添加到另一个列表并返回。

命令：Rpoplpush。

格式：RPOPLPUSH SOURCE\_KEY\_NAME DESTINATION\_KEY\_NAME。

返回值：被弹出的元素。

```markup
RPOPLPUSH mylist myotherlist
LRANGE mylist 0 -1
lrange myotherlist 0 -1

```

![9.2.2rpoppush.jpg](./pic/9.2.2rpoppush.jpg)

7、移出并获取列表的第一个元素

Redis Blpop 命令移出并获取列表的第一个元素， 如果列表没有元素会阻塞列表，直到等待超时或发现可弹出元素为止。

命令：Blpop。

格式：BLPOP LIST1 LIST2 .. LISTN TIMEOUT。

返回值：如果列表为空，返回一个 nil 。 否则，返回一个含有两个元素的列表，第一个元素是被弹出元素所属的 key ，第二个元素是被弹出元素的值。

```markup
blpop mylist 100   
blpop yourlist 10

```

![9.2.2blpop.jpg](./pic/9.2.2blpop.jpg)

8、移出并获取列表的最后一个元素

Redis Brpop命令移出并获取列表的最后一个元素， 如果列表没有元素会阻塞列表直到等待超时或发现可弹出元素为止。

命令：Brpop。

格式：BRPOP LIST1 LIST2 .. LISTN TIMEOUT。

返回值: 假如在指定时间内没有任何元素被弹出，则返回一个 nil 和等待时长。 反之，返回一个含有两个元素的列表，第一个元素是被弹出元素所属的 key ，第二个元素是被弹出元素的值。

```markup
brpop mylist 10
brpop yourlist 10

```

![9.2.2brpop.jpg](./pic/9.2.2brpop.jpg)

9、从列表中弹出一个值，将弹出的元素插入到另外一个列表中并返回它

Redis Brpoplpush 命令从列表中弹出一个值，将弹出的元素插入到另外一个列表中并返回它； 如果列表没有元素会阻塞列表直到等待超时或发现可弹出元素为止。

命令：Brpoplpush。

格式：BRPOPLPUSH LIST1 ANOTHER\_LIST TIMEOUT。

实例：

```markup
LPUSH msg "hello moto"
BRPOPLPUSH msg reciver 500
LLEN reciver

```

![brpoppush.jpg](./pic/brpoppush.jpg)

10、移除列表元素

Redis Lrem 根据参数 COUNT 的值，移除列表中与参数 VALUE 相等的元素。

COUNT 的值可以是以下几种：

count > 0 : 从表头开始向表尾搜索，移除与 VALUE 相等的元素，数量为 COUNT 。

count < 0 : 从表尾开始向表头搜索，移除与 VALUE 相等的元素，数量为 COUNT 的绝对值。

count = 0 : 移除表中所有与 VALUE 相等的值。

命令：Lrem。

格式：LREM KEY\_NAME COUNT VALUE。

返回值: 被移除元素的数量。 列表不存在时返回 0 。

实例：

```markup
rpush listone "hello" "hi" "nihao"
lrem listone -2 "hi"
lrange listone 0 -1

```

![9.2.2lrem.jpg](./pic/9.2.2lrem.jpg)

11、获取列表长度

Redis Llen 命令用于返回列表的长度。 如果列表 key 不存在，则 key 被解释为一个空列表，返回 0 。 如果 key 不是列表类型，返回一个错误。

命令：Llen。

格式：LLEN KEY\_NAME。

返回值:列表的长度。

实例：

```markup
llen listone

```

![9.2.2llen.jpg](./pic/9.2.2llen.jpg)

12、对一个列表进行修剪

Redis Ltrim 对一个列表进行修剪(trim)，就是说，让列表只保留指定区间内的元素，不在指定区间之内的元素都将被删除。

下标 0 表示列表的第一个元素，以 1 表示列表的第二个元素，以此类推。 你也可以使用负数下标，以 -1 表示列表的最后一个元素， -2 表示列表的倒数第二个元素，以此类推。

命令：Ltrim。

格式：LTRIM KEY\_NAME START STOP。

返回值:命令执行成功时，返回 ok 。

```markup
RPUSH listtwo "bar"
RPUSH listtwo "zhangsan"
ltrim listtwo 1 -1
lrange listtwo 0 -1

```

![9.2.2ltrim.jpg](./pic/9.2.2ltrim.jpg)

13、移出并获取列表的第一个元素

Redis Lpop 命令用于移除并返回列表的第一个元素。

命令：Lpop。

格式：LPOP LISTNAME。

返回值: 列表的第一个元素。 当列表 key 不存在时，返回 nil 。

```markup
lpop listtwo

```

![9.2.2Lpop.jpg](./pic/9.2.2Lpop.jpg)

14、将一个或多个值插入到已存在的列表头部

Redis Lpushx 将一个或多个值插入到已存在的列表头部，列表不存在时操作无效。

命令：Lpushx。

格式：LPUSHX KEY\_NAME VALUE1.. VALUEN。

返回值:LPUSHX 命令执行之后，列表的长度。

```markup
lpushx list5 "hello"
lpushx mylist "hello"
lpushx listone "hello"

```

![9.2.2Lpushx.jpg](./pic/9.2.2Lpushx.jpg)

15、在列表的元素前或者后插入元素

Redis Linsert 命令用于在列表的元素前或者后插入元素。 当指定元素不存在于列表中时，不执行任何操作。 当列表不存在时，被视为空列表，不执行任何操作。 如果 key 不是列表类型，返回一个错误。

命令：Linsert。

格式：LINSERT KEY\_NAME BEFORE EXISTING\_VALUE NEW\_VALUE。

返回值:如果命令执行成功，返回插入操作完成之后，列表的长度。 如果没有找到指定元素 ，返回 -1 。 如果 key 不存在或为空列表，返回 0 。

```markup
Rpush list6 "hello" "nihao"
linsert list6 before "nihao" "hi"
lrange list6 0 -1

```

![9.2.2linsert.jpg](./pic/9.2.2linsert.jpg)

16、通过索引设置列表元素的值

Redis Lset 通过索引来设置元素的值。

命令：Lset。

格式：LSET KEY\_NAME INDEX VALUE。

返回值:操作成功返回 ok ，否则返回错误信息。

```markup
rpush list7 "hello" "hi" "nihao"
lset list7 0 "hi"
lrange list7 0 -1

```

![9.2.2lset.jpg](./pic/9.2.2lset.jpg)

### **实验总结**

本实验主要是redis列表数据类型的基本操作，通过本实验的操作，可以熟悉并快速掌握redis列表的相关操作命令，更多命令使用，读者可通过查询官网扩展。