### **实验目的**

1\. 掌握Redis基本数据类型字符串的基本操作

2\. 掌握Redis基本数据哈希类型的基本操作

### **实验背景**

Redis是一种非关系型数据库，是一个高性能的key-value数据库。Redis支持的五种数据类型，包括字符串、哈希、列表、集合、有序集合。本实验主要讲解字符串类型及哈希类型的基本操作命令。

### **实验原理**

string 是 Redis 最基本的类型，一个 key 对应一个 value最大能存储 512MB，string 类型能存储任何形式的字符串，包括二进制数据，主要命令是 GETSET key value命令；Redis hash 是一个 string 类型的 field 和 value 的映射表，hash 特别适合用于存储对象，比如存储用户信息，商品信息等等。

### **实验环境**

Ubuntu 18.04

redis 7.0.12

### **建议课时**

2课时

### **实验步骤**

一 、启动redis服务，打开redis客户端。

1、打开桌面终端terminal，输入redis-server:

```markup
redis-server
```

2.打开另外一个终端terminal。

3、输入命令： $ redis-cli 进入redis客户端

```markup
redis-cli
```

![9.2.1rediscli.jpg](./pic/9.2.1rediscli.jpg)

二．字符串基本操作

1、使用set 命令设置键及值，使用get命令获取键的值

```markup
set key1 value1

```

```markup
set name zhangsan
```

```markup
get key1
```

```markup
get name
```

![9.2stringset.jpg](./pic/9.2stringset.jpg)

2、使用getset命令，将给定 key 的值设为 value ，并返回 key 的旧值

```markup
getset name lisi
```

```markup
get name
```

![9.2stringgetset.jpg](./pic/9.2stringgetset.jpg)

三、哈希类型的基本操作

1、将哈希表 key 中的字段 field 的值设为 value

命令：hset

格式：hset key field value。

```markup
hset hash_key key1 v1
```

```markup
hset hash_key key2 v2
```

![9.2.1hset.jpg](./pic/9.2.1hset.jpg)

2、获取存储在哈希表中指定字段的值

命令：hget。

格式：hget key field。

```markup
hget hash_key key1
```

```markup
hget hash_key key2
```

![9.2.1hget.jpg](./pic/9.2.1hget.jpg)

3、删除一个或多个哈希表字段

命令：hdel。

格式：hdel key field。

```markup
hdel hash_key key2
```

```markup
hget hash_key key2
```

![9.2.1hdel.jpg](./pic/9.2.1hdel.jpg)

4、查看哈希表 key 中，指定的字段是否存在

命令：hexists。

格式：hexists key field。

```markup
hexists hash_key key1
```

```markup
hexists hash_key key2
```

![9.2.1hexists.jpg](./pic/9.2.1hexists.jpg)

5、获取在哈希表中指定 key 的所有字段和值

命令：hgetall。

格式：hgetall key。

```markup
hgetall hash_key
```

```markup
hset hash_key key2 v2
```

```markup
hgetall hash_key
```

```markup
hdel hash_key key2
```

```markup
hgetall hash_key
```

![9.2.1hgetall.jpg](./pic/9.2.1hgetall.jpg)

6、获取所有哈希表中的字段

命令：hkeys。

格式：kheys key。

```markup
hkeys hash_key
```

![9.2.1hkeys.jpg](./pic/9.2.1hkeys.jpg)

7、获取哈希表中字段的数量

命令：hlen。

格式：hlen key。

```markup
hlen hash_key
```

![9.2.1hlen.jpg](./pic/9.2.1hlen.jpg)

8、同时将多个 field-value (域-值)对设置到哈希表 key 中

命令：hmset。

格式：hmset key field1 value1 \[field2 value2\] ...。

```markup
hmset hash_key key3 v3 key4 v4 key5 v5
```

```markup
hgetall hash_key
```

![9.2.1hmset.jpg](./pic/9.2.1hmset.jpg)

9、获取所有给定字段的值

命令：hmget。

格式：hmget key field1 \[field2\] ...。

```markup
hmget hash_key key1 key3 key5
```

![9.2.1hmget.jpg](./pic/9.2.1hmget.jpg)

10、获取哈希表中所有值

命令：hvals。

格式：hvals key。

```markup
hvals hash_key
```

![9.2.1hvals.jpg](./pic/9.2.1hvals.jpg)

11、只有在字段 field 不存在时，设置哈希表字段的值

命令：hsetnx。

格式：hsetnx key field value。

```markup
hsetnx hash_key key1 value10000
```

```markup
hget hash_key key1
```

```markup
hsetnx hash_key key10 value10000
```

```markup
hget hash_key key10
```

![9.2.1hsetnx.jpg](./pic/9.2.1hsetnx.jpg)

12、为哈希表 key 中的指定字段的整数值加上增量 increment

命令：hincrby。

格式：hincrby key field increment。

```markup
hset hash_key num 100
```

```markup
hget hash_key num
```

```markup
hincrby hash_key num 5
```

```markup
hget hash_key num
```

![9.2.1hincre.jpg](./pic/9.2.1hincre.jpg)

13、为哈希表 key 中的指定字段的浮点数值加上增量 increment

命令：hincrbyfloat。

格式：hincrbyfloat key field increment。

```markup
hset hash_key float 100
```

```markup
hget hash_key float
```

```markup
hincrbyfloat hash_key float 0.5
```

```markup
hget hash_key float
```

![9.2.1hfloatincr.jpg](./pic/9.2.1hfloatincr.jpg)

14、迭代哈希表中的键值对

命令：hscan。

格式：hscan key cursor \[MATCH pattern\] \[COUNT count\]。

```markup
hmset hash key1 "1" key2 "2" key3 "3"
```

```markup
hscan hash 0 match key2*
```

![9.2.1hscan.jpg](./pic/9.2.1hscan.jpg)

### **实验总结**

本实验主要是redis数据类型字符串及哈希类型的基本操作，通过本实验的操作，可以熟悉并快速掌握redis字符串及哈希类型的相关操作命令，更多命令使用，读者可通过查询官网扩展。