### **实验目的**

掌握Redis有序集合数据类型的基本操作

### **实验背景**

Redis是一种非关系型数据库，是一个高性能的key-value数据库。Redis支持的五种数据类型，包括字符串、哈希、列表、集合、有序集合。本实验主要是有序集合相关命令的基本操作。

### **实验原理**

Redis 有序集合和集合一样也是 string 类型元素的集合,且不允许重复的成员。不同的是每个元素都会关联一个 double 类型的分数。redis 正是通过分数来为集合中的成员进行从小到大的排序。有序集合的成员是唯一的,但分数(score)却可以重复。

### **实验环境**

Ubuntu 18.04

redis 7.0.12

### **建议课时**

2课时

### **实验步骤**

一 、启动redis服务，打开redis客户端。

1、打开桌面终端terminal，输入redis-server:

```markup
redis-server
```

2、打开另外一个终端terminal。

3、输入命令： $ redis-cli 进入redis客户端

```markup
redis-cli

```

![image_course_1653_user_3165_assignment_16603_1701319930468.png](./pic/image_course_1653_user_3165_assignment_16603_1701319930468.png)

二、有序集合的基本操作

1、向有序集合添加一个或多个成员，或者更新已存在成员的分数

命令：Zadd

格式：ZADD KEY\_NAME SCORE1 VALUE1.. SCOREN VALUEN

返回值:

被成功添加的新成员的数量，不包括那些被更新的、已经存在的成员。

实例：

```markup
ZADD myset 1 "hello"

```

```markup
ZADD myset 1 "foo"

```

```markup
ZADD myset 2 "world" 3 "bar"

```

```markup
ZRANGE myset 0 -1 WITHSCORES

```

![9.2.4zadd.jpg](./pic/9.2.4zadd.jpg)

2、获取有序集合的成员数

Redis Zcard 命令用于计算集合中元素的数量。

命令：Zcard。

格式：ZCARD KEY\_NAME。

返回值: 当 key 存在且是有序集类型时，返回有序集的基数。 当 key 不存在时，返回 0 。

实例：

```markup
ZCARD myset

```

![9.2.4zcard.jpg](./pic/9.2.4zcard.jpg)

3、有序集合中对指定成员的分数加上增量 increment

Redis Zincrby 命令对有序集合中指定成员的分数加上增量 increment,可以通过传递一个负数值 increment ，让分数减去相应的值，比如 ZINCRBY key -5 member ，就是让 member 的 score 值减去 5 。

命令：Zincrby。

格式：ZINCRBY key increment member。

返回值:member 成员的新分数值，以字符串形式表示。

实例：

```markup
ZINCRBY myset 2 "hello"

```

```markup
ZRANGE myset 0 -1 WITHSCORES

```

![9.2.4zincrby.jpg](./pic/9.2.4zincrby.jpg)

4、通过索引区间返回有序集合成指定区间内的成员，分数值递增从(小到大)

Redis Zrange 返回有序集中，指定区间内的成员。其中成员的位置按分数值递增从(小到大)来排序。具有相同分数值的成员按字典序(lexicographical order )来排列。

命令：Zrange。

格式：ZRANGE key start stop \[WITHSCORES\]。

返回值: 指定区间内，带有分数值(可选)的有序集成员的列表。

实例：

显示整个有序集成员

```markup
ZADD salary 10086 jack

```

```markup
ZADD salary 5000 tom

```

```markup
ZADD salary 7500 peter

```

```markup
ZADD salary 3500 joe

```

```markup
ZRANGE salary 0 -1 WITHSCORES      

```

![9.2.4zrange1.jpg](./pic/9.2.4zrange1.jpg)

显示有序集下标区间 1 至 2 的成员

```markup
ZRANGE salary 1 2 WITHSCORES 

```

![9.2.4zrange2.jpg](./pic/9.2.4zrange2.jpg)

5、返回有序集中指定索引区间内的成员，分数从高到低排序(大到小)

Redis Zrevrange 命令返回有序集中，指定区间内的成员。其中成员的位置按分数值递减(从大到小)来排列。

命令：Zrevrange。

格式：ZREVRANGE key start stop \[WITHSCORES\]。

返回值: 指定区间内，带有分数值(可选)的有序集成员的列表。

实例：

```markup
 ZREVRANGE salary 0 -1 WITHSCORES

```

![9.2.4zrevrange.jpg](./pic/9.2.4zrevrange.jpg)

6、返回有序集合中指定成员的排名

Redis Zrank 返回有序集中指定成员的排名。其中有序集成员按分数值递增(从小到大)顺序排列。

命令：Zrank。

格式：ZRANK key member。

返回值: 如果成员是有序集 key 的成员，返回 member 的排名。 如果成员不是有序集 key 的成员，返回 nil 。

实例：

显示 tom 的薪水排名，第二

```markup
ZRANK salary tom

```

![9.2.4zrank.jpg](./pic/9.2.4zrank.jpg)

7、返回有序集合中指定成员的排名，有序集成员按分数值递减(从大到小)排序

Redis Zrevrank 命令返回有序集中成员的排名。其中有序集成员按分数值递减(从大到小)排序。

排名以 0 为底，也就是说， 分数值最大的成员排名为 0 。

命令：Zrevrank。

格式：ZREVRANK key member。

实例：

```markup
ZRANGE salary 0 -1 WITHSCORES

```

```markup
ZREVRANK salary peter

```

![9.2.4zrevrank.jpg](./pic/9.2.4zrevrank.jpg)

8、通过分数返回有序集合指定区间内的成员，分数从低到高

Redis Zrangebyscore 返回有序集合中指定分数区间的成员列表。有序集成员按分数值递增(从小到大)次序排列。具有相同分数值的成员按字典序来排列(该属性是有序集提供的，不需要额外的计算)。默认情况下，区间的取值使用闭区间 (小于等于或大于等于)，你也可以通过给参数前增加( 符号来使用可选的开区间 (小于或大于)。

命令：Zrangebyscore。

格式：ZRANGEBYSCORE key min max \[WITHSCORES\] \[LIMIT offset count\]。

返回值:指定区间内，带有分数值(可选)的有序集成员的列表。

实例：

显示整个有序及及成员score值

```markup
ZRANGEBYSCORE salary -inf +inf WITHSCORES 

```

![9.2.4zranscore1.jpg](./pic/9.2.4zranscore1.jpg)

显示工资小于等于5000的所有成员

```markup
ZRANGEBYSCORE salary -inf 5000 WITHSCORES

```

![9.2.4zranscore2.jpg](./pic/9.2.4zranscore2.jpg)

9、返回有序集中指定分数区间内的成员，分数从高到低排序

Redis Zrevrangebyscore 返回有序集中指定分数区间内的所有的成员。有序集成员按分数值递减(从大到小)的次序排列。

命令：Zrevrangebyscore。

格式：ZREVRANGEBYSCORE key max min \[WITHSCORES\] \[LIMIT offset count\]。

返回值: 指定区间内，带有分数值(可选)的有序集成员的列表。

实例：

按工资逆序排列所有成员

```markup
ZREVRANGEBYSCORE salary +inf -inf

```

![9.2.4revrangescore1.jpg](./pic/9.2.4revrangescore1.jpg)

逆序排列薪水介于10000 和 2000 之间的成员

```markup
ZREVRANGEBYSCORE salary 10000 2000

```

![9.2.4revrangescore2.jpg](./pic/9.2.4revrangescore2.jpg)

10、计算给定的一个或多个有序集的交集并将结果集存储在新的有序集合 key 中

Redis Zinterstore 命令计算给定的一个或多个有序集的交集，其中给定 key 的数量必须以 numkeys 参数指定，并将该交集(结果集)储存到 destination 。默认情况下，结果集中某个成员的分数值是所有给定集下该成员分数值之和。

命令：Zinterstore。

格式：ZINTERSTORE destination numkeys key \[key ...\] \[WEIGHTS weight \[weight ...\]\] \[AGGREGATE SUM|MIN|MAX\]。

返回值:保存到目标结果集的的成员数量。

实例：

创建有序集 mid\_test

```markup
ZADD mid_test 70 "Li Lei"

```

```markup
ZADD mid_test 70 "Han Meimei"


```

```markup
ZADD mid_test 99.5 "Tom"

```

创建 另一个有序集 fin\_test

```markup
ZADD fin_test 88 "Li Lei"

```

```markup
 ZADD fin_test 75 "Han Meimei"

```

```markup
 ZADD fin_test 99.5 "Tom"

```

计算交集并显示所有成员分数值

```markup
ZINTERSTORE sum_point 2 mid_test fin_test

```

```markup
ZRANGE sum_point 0 -1 WITHSCORES   

```

![9.2.4zintersscore.jpg](./pic/9.2.4zintersscore.jpg)

11、在有序集合中计算指定字典区间内成员数量

Redis Zlexcount 命令在计算有序集合中指定字典区间内成员数量。

命令：Zlexcount。

格式：ZLEXCOUNT KEY MIN MAX。

返回值:指定区间内的成员数量。

实例：获取b,f之间的成员

```markup
ZADD myzset 0 a 0 b 0 c 0 d 0 e

```

```markup
ZADD myzset 0 f 0 g

```

```markup
ZLEXCOUNT myzset [b [f

```

![9.2.4myzset.jpg](./pic/9.2.4myzset.jpg)

12、计算给定的一个或多个有序集的并集，并存储在新的 key 中

Redis Zunionstore 命令计算给定的一个或多个有序集的并集，其中给定 key 的数量必须以 numkeys 参数指定，并将该并集(结果集)储存到 destination 。结果集中某个成员的分数值是所有给定集下该成员分数值之和 。

命令：Zunionstore。

格式： ZUNIONSTORE destination numkeys key \[key ...\] \[WEIGHTS weight \[weight ...\]\] \[AGGREGATE SUM|MIN|MAX\]。

返回值: 保存到 destination 的结果集的成员数量。

实例：

```markup
ZADD zset1 1 "one"

```

```markup
ZADD zset1 1 "two"

```

```markup
ZADD zset2 1 "one"

```

```markup
ZADD zset2 1 "two"

```

```markup
ZADD zset2 1 "three"

```

```markup
ZUNIONSTORE zset3 2 zset1 zset2 WEIGHTS 2 3

```

```markup
ZRANGE zset3 0 -1 WITHSCORES

```

![9.2.4zunionscore.jpg](./pic/9.2.4zunionscore.jpg)

13、移除有序集合中的一个或多个成员

Redis Zrem 命令用于移除有序集中的一个或多个成员，不存在的成员将被忽略。

当 key 存在但不是有序集类型时，返回一个错误。

命令：Zrem。

格式：ZREM key member \[member ...\]。

返回值: 被成功移除的成员的数量，不包括被忽略的成员。

实例：

```markup
ZADD myset4 1 "hello" 2 "hi" 3 "nihao"

```

```markup
ZREM myset4 "hello"

```

```markup
ZRANGE myset4 0 -1

```

![9.2.4zrem.jpg](./pic/9.2.4zrem.jpg)

### **实验总结**

本实验主要是redis有序集合数据类型的基本操作，通过本实验的操作，可以熟悉并快速掌握redis有序集合的相关操作命令，更多命令使用，读者可通过查询官网扩展。