### 实验目的

掌握Neo4j的操作语言Cypher的基本操作

### 实验背景

Neo4j是一个高性能的NoSQL图形数据库，它将结构化数据存储在网络上而不是表中。Neo4j是一个嵌入式的、基于磁盘的、具备完全的事务特性的Java持久化引擎。Neo4j也可以被看作是一个高性能的图引擎，该引擎具有成熟数据库的所有特性。使用Neo4j时，程序员工作在一个面向对象的、灵活的网络结构下，而不是严格、静态的表中，但是他们可以享受到具备完全的事务特性、企业级的数据库的所有好处。Neo4j因其具备的嵌入式、高性能、轻量级等优势，越来越受到人们的关注。

### 实验原理



Neo4j CQL是Neo4j图形数据库的查询语言，它是一种声明性模式匹配语言，遵循SQL语法，它的语法是非常简单且人性化、可读的格式。本任务主要完成Cypher的常用操作，包括CREATE、MATCH、RETURN、LIMIT、SKIP、DELETE、REMOVE、WHERE、SET、ORDER BY、UNION、UNWIND、MERGE、LOAD CSV等。本实验以电影和演员关系图为例介绍Neo4j的操作语言Cypher的基本操作。

![image-20220310091230756](./pic/image-20220310091230756)

### 实验环境

Ubuntu 16.04

neo4j3.5.32

### 建议课时

4课时

### 实验步骤

一、开启Neo4j

在命令行下执行如下命令：

```markup
sudo neo4j start

```

启动完成后，浏览器打开

```markup
localhost:7474

```

提示输入密码，初始密码为neo4j，如下图：

初次登陆默认用户名密码都是neo4j。界面如下：

![1691672429606](pic/1691672429606.png)

登录完成需要修改密码

![1691672461979](pic/1691672461979.png)

登录成功，界面如下

![1691672494337](pic/1691672494337.png)



二、创建节点及关系                         

1、创建节点

电影和演员关系图中，最上面的5个节点表示Person类型节点，下面的2个节点为Movie类型节点。Person类型节点有name属性，Movie类型节点有title属性。Person类型节点和Movie类型节点之间有DIRECTED和ACTED_IN两种关系。

需要先创建Person和Movie两种节点，代码如下：

```
CREATE (`Wall Street`:Movie{title:'Wall Street'})
CREATE (`The American President`:Movie{title:'The American President'})
```

![](pic/movie-1691673222515.jpg)

```
CREATE (Oliver:Person{name:'Oliver Stone'})
CREATE (`Michael Douglas`:Person{name:'Michael Douglas'})
CREATE (`Charlie Sheen`:Person{name:'Charlie Sheen'})
CREATE (`Martin Sheen`:Person{name:'Martin Sheen'})
CREATE (`Rob Reiner`:Person{name:'Rob Reiner'})
```

![](pic/person-1691673222515.jpg)

2、在使用MATCH命令，查询到所有节点并创建关系

```
MATCH (a:Movie { title: 'Wall Street' }),(Oliver:Person{name:'Oliver Stone'}),(`Michael Douglas`:Person{name:'Michael Douglas'}),(`Charlie Sheen`:Person{name:'Charlie Sheen'}),(`Martin Sheen`:Person{name:'Martin Sheen'}),(`Rob Reiner`:Person{name:'Rob Reiner'}),(b:Movie { title: 'The American President' })
CREATE (Oliver)-[r:DIRECTED]->(a)
CREATE (`Michael Douglas`)-[:ACTED_IN{role:'Gordon Gekko'}]->(a)
CREATE (`Charlie Sheen`)-[:ACTED_IN{role:'Bud Fox'}]->(a)
CREATE (`Martin Sheen`)-[:ACTED_IN{role:'Carl Fox'}]->(a)
CREATE (`Michael Douglas`)-[:ACTED_IN{role:'President Andrew Shepherd'}]->(b)
CREATE (`Martin Sheen`)-[:ACTED_IN{role:'A.J.MacInerney'}]->(b)
CREATE (`Rob Reiner`)-[:DIRECTED]->(b)
```

![](pic/relation-1691673222515.jpg)



二、节点查询。

MATCH可以对节点进行查询，在查询过程中可以按照标签、属性对节点进行查询。 当没有指定节点的标签或属性时，默认是选择节点全部的标签和属性。

1、查询所有节点。

```
MATCH (n)
RETURN n
```

![](pic/match-1691673222515.jpg)

1、查询带有标签的节点。

通过单个节点模式获取带有标签的所有节点。当模式中指定标签时，表示只查询带有特定标签的节点，若节点有多个标签，只要含有指定的标签，就成功可匹配到该节点。

查询并返回节点标签为Movie的所有节点的title属性，代码如下：

```
MATCH (movie:Movie)
RETURN movie.title
```

![](pic/matchmovie-1691673222515.jpg)

3、查询存在关系的节点。

设置节点director的name属性为'Oliver Stone'，匹配与director节点存在任意关系的节点movie，并返回movie节点的title属性。本语句并未指定关系，即表示任意关系，没有指定节点类型，即表示任意节点，唯一的匹配条件就是第一个节点的属性name值为'Oliver Stone'。代码如下：

```
MATCH (director { name: 'Oliver Stone' })--(movie)
RETURN movie.title
```

![](pic/director-1691673222515.jpg)

4、查询存在关系的特定节点。

指定一个节点的标签和属性，查询与该节点有任意关系的且类型为Movie的相关节点，返回相关节点的title属性值。

```
MATCH (:Person { name: 'Oliver Stone' })--(movie:Movie)
RETURN movie.title
```

![](pic/renyi-1691673222516.jpg)

三、基本关系的查询。

1、指定关系的方向。

关系的方向可以通过--> 和<--指定。查询一个标签为Person，name属性是'Oliver Stone'的起始节点，并且该起始节点与结束节点movie有任意关系，返回movie节点的title值：

```
MATCH (:Person { name: 'Oliver Stone' })-->(movie)
RETURN movie.title
```

![](pic/jiben-1691673222516.jpg)

2、查询关系的类型。

在查询关系时，如果需要筛选关系的属性或返回关系，就需要指定关系变量，后续子句可以引用该变量。起始节点为Person类型，name属性为'Oliver Stone'，匹配与Person节点具有任意关系的节点movie，并返回关系类型，关系的类型可通过type()函数查看，代码如下：

```
MATCH (:Person { name: 'Oliver Stone' })-[r]->(movie)
RETURN type(r)
```

![](pic/guanxileixing-1691673222516.jpg)

3、匹配关系类型。

指定节点wallstreet为Movie类型，title属性为' Wall Street '，匹配与wallstreet节点的关系类型为ACTED_IN的节点，并返回相关节点的name属性值，读者需要注意本例中的关系方向，代码如下：

```
MATCH (wallstreet:Movie { title: 'Wall Street' })<-[:ACTED_IN]-(actor)
RETURN actor.name
```

![](pic/ppei-1691673222516.jpg)

4、匹配多种关系类型。

在匹配关系时，可以指定多种关系的类型，要匹配多种类型中的一种，可以通过使用管道符号|将关系类型链接起来。匹配关系类型为ACTED_IN或 DIRECTED的节点，并返回相关节点的name属性值

```
MATCH (wallstreet { title: 'Wall Street' })<-[:ACTED_IN|:DIRECTED]-(person)
RETURN person.name
```

![](pic/ppeiduo-1691673222516.jpg)

5、匹配关系类型，并指定关系变量。

匹配符合条件的关系，并返回该关系的role属性值，代码如下：

```
MATCH (wallstreet { title: 'Wall Street' })<-[r:ACTED_IN]-(actor)
RETURN r.role
```

![](pic/ppeizhiding-1691673222516.jpg)

6、匹配多个关系。

起始节点charlie的name属性为Charlie Sheen，匹配与起始节点关系为ACTED_IN的相关节点movie，同时相关节点movie也与其它节点director具有DIRECTED关系。返回相关节点movie的title属性和节点director的name属性，代码如下：

```
MATCH (charlie { name: 'Charlie Sheen' })-[:ACTED_IN]->(movie)<-[:DIRECTED]-(director)
RETURN movie.title, director.name
```

![](pic/ppduoge-1691673222516.jpg)

7、匹配路径。

 路径是节点和关系交替组合构成的序列，图中必须满足路径指定的模式，才能返回路径中的元素。

1)查询匹配关系数量在1-3之间的模式，并返回movie节点的title，代码如下：

```
MATCH (martin { name: 'Charlie Sheen' })-[:ACTED_IN*1..3]-(movie:Movie)
RETURN movie.title
```

![](pic/1-3-1691673222516.jpg)

2)查询符合条件的模式，并返回路径中的关系，代码如下：

```
MATCH p =(actor { name: 'Charlie Sheen' })-[:ACTED_IN*2]-(co_actor)
RETURN relationships(p)
```

![](pic/fuhemoshi-1691673222516.jpg)

3)匹配可变长度路径上的属性，代码如下：

首先通过以下语句添加关系，从而改变原始图。在这个查询中，“Charlie Sheen”和他的父亲“Martin Sheen”之间有两条路径。其中一份包括一段blocked为FALSE的关系，而另一份则blocked属性为TRUE。代码如下：

```
MATCH (charlie:Person { name: 'Charlie Sheen' }),(martin:Person { name: 'Martin Sheen' })
CREATE (charlie)-[:X { blocked: FALSE }]->(:UNBLOCKED)<-[:X { blocked: FALSE }]-(martin)
CREATE (charlie)-[:X { blocked: TRUE }]->(:BLOCKED)<-[:X { blocked: FALSE }]-(martin)
```

![](pic/xiugai-1691673222516.jpg)

匹配变长路径时，指定属性信息，返回相关路径，代码如下：

```
MATCH p =(charlie:Person)-[* { blocked:false }]-(martin:Person)
WHERE charlie.name = 'Charlie Sheen' AND martin.name = 'Martin Sheen'
RETURN p
```

返回值为'Charlie Sheen'和'Martin Sheen'之间关系的blocked属性为false的路径。

![](pic/block-1691673222516.jpg)

4)匹配命名路径。

如果希望返回模式图中的路径，可以引入命名路径。

```
MATCH p =(michael { name: 'Michael Douglas' })-->()
RETURN p
```

返回从'Michael Douglas'开始的两条路径

   ![](pic/tuzhong-1691673222516.jpg)

四、RETURN、LIMIT和SKIP

RETURN语句可以返回节点、关系、属性，变量等，如果仅关注属性信息，可以直接返回属性，而不是返回节点或关系，直接返回属性将提高性能。LIMIT和SKIP用来过滤或限制查询返回的行数。其中LIMIT表示返回前几行，SKIP表示跳过前几行。

1)返回节点。

(1)返回匹配条件的全部节点。

返回节点标签为Person的全部节点，代码如下：

```
MATCH (n:Person) RETURN n
```

一共返回5个节点，返回值如下：

![](pic/5-1691673222516.jpg)

(2)返回匹配条件的前2个节点。

返回节点标签为Person的前2个节点，代码如下：

```
MATCH (n:Person) RETURN n LIMIT 2
```

一共返回2个节点，返回值如下：

![](pic/2node-1691673222517.jpg)

(3)返回匹配条件的第3个直到最后1个节点。

返回节点标签为Person的返回匹配条件的第3个直到最后1个节点，代码如下：

```
MATCH (n:Person) RETURN n SKIP 2
```

一共返回3个节点，返回值如下：

![](pic/3node-1691673222517.jpg)

2)返回关系。

(1)返回全部关系。

返回关系类别为ACTED_IN的全部关系，代码如下：

```
MATCH ()-[r:ACTED_IN]->() RETURN r
```

返回值为：

![](pic/fanhuiguanxi-1691673222517.jpg)

(2)匹配关系，并返回指定位置的关系。

匹配关系类别为ACTED_IN的全部关系，并返回第3，4条关系，代码如下：

```
MATCH ()-[r:ACTED_IN]->() RETURN r SKIP 2 LIMIT 2 
```

返回值先跳过前2个关系，再返回第3，4个关系，返回值为：

![](pic/fanhui2guan-1691673222517.jpg)

3)返回属性。

RETURN既可以返回节点属性，也可以返回关系属性，两者使用方式一致，这里仅演示返回关系属性的方法。

返回关系为ACTED_IN的role属性值，代码如下：

```
MATCH ()-[r:ACTED_IN]->() RETURN r.role LIMIT 2
```

如果仅需要返回属性时，直接返回属性会提高响应性能，返回值为：

![](pic/fanhuishuxing-1691673222517.jpg)

五、DELETE、REMOVE

在Neo4j中，DELETE用于删除节点、相关节点和关系。REMOVE用于删除现有节点或关系删除标签、属性。两个命令常与MATCH命令一起使用。

1)REMOVE删除属性及标签。

(1)REMOVE删除属性。

先查看指定关系的role属性,代码如下：

```
MATCH ()-[r:ACTED_IN]->() RETURN r.role LIMIT 2
```

此时返回的两个关系均有role属性值，返回值为：

![](pic/fanhui-1691673222517.jpg)

删除关系的role属性，代码如下：

```
MATCH ()-[r1:ACTED_IN{role:"Gordon Gekko"}]->() REMOVE r1.role
```

![](pic/delete-1691673222517.jpg)

返回关系的role属性，代码如下：

```
MATCH ()-[r:ACTED_IN]->() RETURN r.role LIMIT 2
```

此时第2个关系的role属性已经被删除，返回为null，返回值为：

![](pic/fanhuirole-1691673222517.jpg)

(2)REMOVE删除标签。

删除name为“Rob Reiner”节点的Person标签，代码如下：

```
MATCH (n:Person{name:"Rob Reiner"}) REMOVE n:Person
```

![](pic/delete1-1691673222517.jpg)

查看标签为Person的节点代码如下：

```
MATCH (n:Person) RETURN n
```

此时name为“Rob Reiner”节点的Person标签被删除，返回值为：

![](pic/fanhuidelete-1691673222517.jpg)

2)DELETE删除节点关系。

(1)DELETE删除关系。

查看任意两个节点间有关系标签为DIRECTED的路径，并将路径p返回，代码如下：

```
MATCH p=()-[r:DIRECTED]->() RETURN p
```

此时返回匹配的两个路径：

![](pic/delete4-1691673222517.jpg)

删除name为Oliver Stone和title为Wall Street节点之间关系标签为DIRECTED的关系：

```
MATCH (n { name: 'Oliver Stone' })-[r:DIRECTED]->(m{title:"Wall Street"})
DELETE r
```

![](pic/delete5-1691673222517.jpg)

返回值的提示表明，有一个关系被删除了。

此时，再查看任意两个节点间有关系标签为DIRECTED的路径，并将路径p返回，代码如下：

```
MATCH p=()-[r:DIRECTED]->() RETURN p
```

此时返回匹配的两个路径，返回值为：

![](pic/delete6-1691673222517.jpg)

(2)DELETE删除节点及相关的关系。

在DELETE前添加DETACH关键字，可以完成删除节点的同时删除该节点相关的关系，代码如下：

```
MATCH (n:Person{name:"Charlie Sheen"}) DETACH DELETE n
```

返回值为：

![](pic/delete7-1691673222517.jpg)

### 实验总结

### 

### 实验总结

本实验主要完成了Neo4j图数据库CQL语言的基本操作，在操作过程中，熟练掌握了create、match、return、limit、skip、delete、remove等命令的使用。更多命令使用，可参考官方网站。