### **实验目的**

1、掌握使用JavaAPI对Hbase数据库表及数据库表的创建和删除方法

2、掌握使用JavaAPI对Hbase 数据库表数据的增、删、改、查方法

### 实验背景

基于Ubuntu 18.04下进行使用JavaAPI对Hbase的数据库表创建删除操作以及数据库表的增删改查

### 实验原理

使用Java操作HBase的相关类都在org.apache.hadoop.hbase.client中，都是与HBase数据的存储管理相关的API。管理HBase可以使用Admin接口创建、更改、删除表；向表中添加数据、查询数据使用Table接口。

### **实验环境**

Ubuntu 18.04

JDK 1.8

Hadoop 3.3.5

Hbase 2.4.17

### **建议课时**

4课时

### **实验步骤**

1、启动hadoop及Hbase

我们需要进入 hadoop目录下的sbin文件夹中。

```markup
cd /opt/hadoop/sbin/
```

初始化namenode：

```markup
hdfs namenode -format
```

启动hdfs：

```markup
./start-all.sh
```

使用start-hbase.sh命令启动hbase

```markup
cd /opt/hbase/bin/
./start-hbase.sh 
```

使用jps命名验证进程是否启动成功

![jps命令.png](./pic/jps命令.png)

2、构建Maven项目

创建maven project，在pom.xml 里面添加jar包

![创建maven项目1.png](./pic/创建maven项目1.png)

![创建maven项目2.png](./pic/创建maven项目2.png)

![创建maven项目3.png](./pic/创建maven项目3.png)

3、使用Java对Hbase进行表的操作

首先修改pom.xml文件，增加客户端依赖

```markup
    <dependency>
      <groupId>org.apache.hbase</groupId>
      <artifactId>hbase-client</artifactId>
      <version>2.4.17</version>
    </dependency>
    <dependency>
      <groupId>org.apache.hbase</groupId>
      <artifactId>hbase-server</artifactId>
      <version>2.4.17</version>
    </dependency>
```

![修改pom.xml文件.png](./pic/修改pom.xml文件.png)

更改jdk的jar包版本为jdk1.8

![更改jdk.png](./pic/更改jdk.png)

![编辑jdk.png](./pic/编辑jdk.png)

![编辑jdk2.png](./pic/编辑jdk2.png)

新建HbaseTest的类

![新建类.png](./pic/新建类.png)

在HbaseTest类中，使用HBaseConfiguration.create()创建相关的配置文件对象，使用该对象配置Zookeeper的地址localhost、端口2181。

```markup
  // 连接到HBase
	public static void init() {
		// 创建配置对象
		conf = HBaseConfiguration.create();
		// 配置Zookeeper的地址、端口
		conf.set("hbase.zookeeper.quorum", "localhost");
		conf.set("hbase.zookeeper.property.clientPort", "2181");
		// 创建连接
		try {
			connection = ConnectionFactory.createConnection(conf);
			admin = connection.getAdmin();
			System.out.println(admin);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
```

![链接hbase.png](./pic/链接hbase.png)

关闭流

```markup
// 关闭流
	public static void close() throws IOException {
		if (admin != null) {
			admin.close();
		}
		if (connection != null) {
			connection.close();
		}
	}
```

![关闭流.png](./pic/关闭流.png)

创建命名空间

```markup
// 创建命名空间
	public static void createNameSpace() {
		NamespaceDescriptor test = NamespaceDescriptor.create("test").build();

		try {
			// 执行创建对象
			admin.createNamespace(test);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
```

![创建命名空间.png](./pic/创建命名空间.png)

创建表

```markup
// 创建表
	public static void createTable() throws IOException {
		// 创建表的描述类
		TableName tableName = TableName.valueOf("test:student");
		// 获取表格描述器
		HTableDescriptor desc = new HTableDescriptor(tableName);

		// 创建列族的描述类，添加列族
		HColumnDescriptor family1 = new HColumnDescriptor("info1");
		HColumnDescriptor family2 = new HColumnDescriptor("info2");
		desc.addFamily(family1);
		desc.addFamily(family2);

		admin.createTable(desc);
	}
```

![创建表.png](./pic/创建表.png)

向表中添加数据

```markup
// 插入数据
	public static void insertData() throws IOException {
		// 获取表的信息
		Table table = connection.getTable(TableName.valueOf("test:student"));
		// 设置行键
		Put put = new Put(Bytes.toBytes("student1"));
		// 设置列的标识以及列值
		put.addColumn("info1".getBytes(), "name".getBytes(), "zs".getBytes());
		put.addColumn("info2".getBytes(), "school".getBytes(), "xwxx".getBytes());
		// 执行添加
		table.put(put);

		// 使用集合添加数据
		Put put2 = new Put(Bytes.toBytes("student2"));
		put2.addColumn("info1".getBytes(), "name".getBytes(), "zss".getBytes());
		put2.addColumn("info2".getBytes(), "school".getBytes(), "xwxx".getBytes());
		Put put3 = new Put(Bytes.toBytes("student3"));
		put3.addColumn("info1".getBytes(), "name".getBytes(), "zsr".getBytes());
		put3.addColumn("info2".getBytes(), "school".getBytes(), "xwxx".getBytes());
		List<Put> list = new ArrayList<>();
		list.add(put2);
		list.add(put3);
		table.put(list);
	}
```

![插入数据.png](./pic/插入数据.png)

使用get方法获取某一行数据

```markup
	//使用get方法获取某一行数据
	public static void queryData() throws IOException {
        Table table = connection.getTable(TableName.valueOf("test:student"));
        Get get = new Get(Bytes.toBytes("student1"));
        Result result = table.get(get);
        byte[] value = result.getValue(Bytes.toBytes("info1"), Bytes.toBytes("name"));
        System.out.println("姓名:" + Bytes.toString(value));
        value = result.getValue(Bytes.toBytes("info2"), Bytes.toBytes("school"));
        System.out.println("学校:" + Bytes.toString(value));
 
    }
```

![get获取数据.png](./pic/get获取数据.png)

使用scan扫描HBase的整表数据

```markup
	//使用scan扫描HBase的整表数据
	public static void scanData() throws IOException{
	// 创建Scan对象
	Scan scan = new Scan( ); 
	// 创建表对象
	Table table = connection.getTable(TableName.valueOf("test:student"));
	System.out.println("Scanning data……");
	// 返回结果
	ResultScanner resultScanner =  table.getScanner(scan);
	// 遍历ResultScanner对象，获取每一个Result对象
	for(Result result:resultScanner) {
	// 获取Result对象的单元格对象
	Cell[] cells = result.rawCells( ); 
	for(Cell cell:cells){
	// 打印出每个单元格的行键、列、值、时间戳 
	System.out.println("rowKey:"+new String(CellUtil.cloneRow(cell)));
	System.out.println("col:"+new String(CellUtil.cloneQualifier(cell)));
	System.out.println("value:"+new String(CellUtil.cloneValue(cell)));
	System.out.println("ts:"+cell.getTimestamp( ));
	}
	}
	}
```

![scan扫描数据.png](./pic/scan扫描数据.png)

测试

```markup
	public static void main(String[] args) {
		// TODO Auto-generated method stub		
		try {
			/*init();*/
			createNameSpace();
			createTable();
			insertData();
			queryData();
			scanData();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}finally {
			try {
				//关闭流
				close();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}
```

![测试2.png](./pic/测试2.png)

通过控制台输出结果可知，能够查看单条结果，也能查看表中全部数据。

程序完整代码如下：

```markup
package com.study.hbasePro;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

//环境配置类
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.*;
//HBase客户端接口
import org.apache.hadoop.hbase.client.*;
//字节类
import org.apache.hadoop.hbase.util.Bytes;

public class HbaseTest {
	public static Configuration conf;
	public static Connection connection;
	public static Admin admin;

	// 连接到HBase
	public static void init() {
		// 创建配置对象
		conf = HBaseConfiguration.create();
		// 配置Zookeeper的地址、端口
		conf.set("hbase.zookeeper.quorum", "localhost");
		conf.set("hbase.zookeeper.property.clientPort", "2181");
		// 创建连接
		try {
			connection = ConnectionFactory.createConnection(conf);
			admin = connection.getAdmin();
			System.out.println(admin);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	// 关闭流
	public static void close() throws IOException {
		if (admin != null) {
			admin.close();
		}
		if (connection != null) {
			connection.close();
		}
	}

	// 创建命名空间
	public static void createNameSpace() {
		NamespaceDescriptor test = NamespaceDescriptor.create("test").build();

		try {
			// 执行创建对象
			admin.createNamespace(test);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	// 创建表
	public static void createTable() throws IOException {
		// 创建表的描述类
		TableName tableName = TableName.valueOf("test:student");
		// 获取表格描述器
		HTableDescriptor desc = new HTableDescriptor(tableName);

		// 创建列族的描述类，添加列族
		HColumnDescriptor family1 = new HColumnDescriptor("info1");
		HColumnDescriptor family2 = new HColumnDescriptor("info2");
		desc.addFamily(family1);
		desc.addFamily(family2);

		admin.createTable(desc);
	}

	// 插入数据
	public static void insertData() throws IOException {
		// 获取表的信息
		Table table = connection.getTable(TableName.valueOf("test:student"));
		// 设置行键
		Put put = new Put(Bytes.toBytes("student1"));
		// 设置列的标识以及列值
		put.addColumn("info1".getBytes(), "name".getBytes(), "zs".getBytes());
		put.addColumn("info2".getBytes(), "school".getBytes(), "xwxx".getBytes());
		// 执行添加
		table.put(put);

		// 使用集合添加数据
		Put put2 = new Put(Bytes.toBytes("student2"));
		put2.addColumn("info1".getBytes(), "name".getBytes(), "zss".getBytes());
		put2.addColumn("info2".getBytes(), "school".getBytes(), "xwxx".getBytes());
		Put put3 = new Put(Bytes.toBytes("student3"));
		put3.addColumn("info1".getBytes(), "name".getBytes(), "zsr".getBytes());
		put3.addColumn("info2".getBytes(), "school".getBytes(), "xwxx".getBytes());
		List<Put> list = new ArrayList<>();
		list.add(put2);
		list.add(put3);
		table.put(list);
	}
	//使用get方法获取某一行数据
	public static void queryData() throws IOException {
        Table table = connection.getTable(TableName.valueOf("test:student"));
        Get get = new Get(Bytes.toBytes("student1"));
        Result result = table.get(get);
        byte[] value = result.getValue(Bytes.toBytes("info1"), Bytes.toBytes("name"));
        System.out.println("姓名:" + Bytes.toString(value));
        value = result.getValue(Bytes.toBytes("info2"), Bytes.toBytes("school"));
        System.out.println("学校:" + Bytes.toString(value));
 
    }
	//使用scan扫描HBase的整表数据
	public static void scanData() throws IOException{
	// 创建Scan对象
	Scan scan = new Scan( ); 
	// 创建表对象
	Table table = connection.getTable(TableName.valueOf("test:student"));
	System.out.println("Scanning data……");
	// 返回结果
	ResultScanner resultScanner =  table.getScanner(scan);
	// 遍历ResultScanner对象，获取每一个Result对象
	for(Result result:resultScanner) {
	// 获取Result对象的单元格对象
	Cell[] cells = result.rawCells( ); 
	for(Cell cell:cells){
	// 打印出每个单元格的行键、列、值、时间戳 
	System.out.println("rowKey:"+new String(CellUtil.cloneRow(cell)));
	System.out.println("col:"+new String(CellUtil.cloneQualifier(cell)));
	System.out.println("value:"+new String(CellUtil.cloneValue(cell)));
	System.out.println("ts:"+cell.getTimestamp( ));
	}
	}
	}
	
	public static void main(String[] args) {
		// TODO Auto-generated method stub		
		try {
			init();
			createNameSpace();
			createTable();
			insertData();
			queryData();
			scanData();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}finally {
			try {
				//关闭流
				close();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}

}

```

### **实验总结**

通过本次实验，掌握了JavaAPI下Hbase 创建数据库表及删除数据库表以及Hbase 对数据库表数据的增、删、改、查操作。