### **实验名称**

Redis编程操作

### **实验目的**

掌握使用java编程语言操作Redis数据库

### **实验背景**

Redis(Remote Dictionary Server )，即远程字典服务，是完全开源的，遵守 BSD 协议，是一个高性能的key-value数据库。Redis是一种非关系型数据库，它支持主从同步。基于Java操作Redis数据库，可以将Redi整合到工程中，便于更充分的利用Redis数据库的特性。

### **实验原理**

开始在 Java 中使用 Redis 前，需要确保已经安装了Redis 服务和 Redis 驱动，且你的机器上能正常使用 Java。目前提供的Redis驱动为jedis-2.9.0.jar，可以很方便的操作Redis数据库，实现对Redis数据库里数据的增删改查等操作。本实验通过配置maven项目，使用maven下载Redis驱动包，完成Java对Redis的编程操作。

### **实验环境**

Ubuntu 18.04

jdk1.8

Maven3.6.1

IDEA/Eclipse

Redis 7.0.12

### **建议课时**

2课时

### **实验步骤**

一 、配置和启动Redis

1、使用ifconfig命令查看服务器ip地址，记录下来用于修改redis配置文件。此处Redis服务器IP地址为 10.2.92.3（实际实验中，需要记录自己查出的IP地址信息）

```markup
ifconfig

```

![image_course_1653_user_3165_assignment_16606_1695456405244.png](./pic/image_course_1653_user_3165_assignment_16606_1695456405244.png)

2、修改Redis服务器的配置文件 使用 sudo vi /etc/redis/redis.conf 命令打开配置文件

(1)、上一步我们查到Redis服务器的IP地址为10.2.92.3，此处我们将配置文件中 #bind 127.0.0.1 修改为Redis服务器的bind 10.2.92.3。

```markup
sudo vi /opt/redis/redis.conf

```

```markup
bind 10.2.92.3

```

![image_course_1653_user_3165_assignment_16606_1695456588047.png](./pic/image_course_1653_user_3165_assignment_16606_1695456588047.png)

(2)、将Redis server的保护模式由yes改为设置为no。

![image_course_1653_user_3165_assignment_16607_1695281816230.png](./pic/image_course_1653_user_3165_assignment_16607_1695281816230.png)

(3)、将Redis服务器的demonize由no改为设置为yes。

![image_course_1653_user_3165_assignment_16607_1695281949737.png](./pic/image_course_1653_user_3165_assignment_16607_1695281949737.png)

(4)、并在文件末尾为Redis添加授权码123456。

```python
requirepass 123456
```

![image_course_1653_user_3165_assignment_16607_1695283541262.png](./pic/image_course_1653_user_3165_assignment_16607_1695283541262.png)

3、保存配置文件，启动redis

```markup
redis-server /opt/redis/redis.conf

```

4、用redis-cli工具验证redis服务可用性，Redis服务器配置完毕。

```python
redis-cli -h 10.2.92.3 -p 6379 -a '123456'
```

![image_course_1653_user_3165_assignment_16606_1695456691530.png](./pic/image_course_1653_user_3165_assignment_16606_1695456691530.png)

二、使用IDEA创建Java maven项目

1、双击打开桌面Java集成开发环境Eclipse

![image_course_1653_user_3165_assignment_16606_1695455322925.png](./pic/image_course_1653_user_3165_assignment_16606_1695455322925.png)

采用缺省的workspace目录，点击Launch

![image_course_1653_user_3165_assignment_16606_1695455369890.png](./pic/image_course_1653_user_3165_assignment_16606_1695455369890.png)

2、进入eclipse后，选择new->Other...->Maven Project

![image_course_1653_user_3165_assignment_16606_1695455451652.png](./pic/image_course_1653_user_3165_assignment_16606_1695455451652.png)  

![image_course_1653_user_3165_assignment_16606_1695455536128.png](./pic/image_course_1653_user_3165_assignment_16606_1695455536128.png)

3、选择新建maven项目，点击next

![image_course_1653_user_3165_assignment_16606_1695455605760.png](./pic/image_course_1653_user_3165_assignment_16606_1695455605760.png)

选择如图maven-archetype-quickstart

![image_course_1653_user_3165_assignment_16606_1695455633163.png](./pic/image_course_1653_user_3165_assignment_16606_1695455633163.png)

4、填写Groupid、Artifactid等信息，然后点击next

![image_course_1653_user_3165_assignment_16606_1695455707514.png](./pic/image_course_1653_user_3165_assignment_16606_1695455707514.png)

5、创建后的maven工程如下：

![image_course_1653_user_3165_assignment_16606_1695455770754.png](./pic/image_course_1653_user_3165_assignment_16606_1695455770754.png)

6、打开pom.xml文件，添加Redis的Java驱动，

pom依赖如下：

```markup
<dependency>
      <groupId>redis.clients</groupId>
      <artifactId>jedis</artifactId>
      <version>3.6.0</version>
</dependency>

```

![image_course_1653_user_3165_assignment_16606_1695455794429.png](./pic/image_course_1653_user_3165_assignment_16606_1695455794429.png)

三、创建JavaRedis类,测试Redis服务连接是否正常

1、在工程中创建类文件，文件名为JavaRedis。如下图

![image_course_1653_user_3165_assignment_16606_1695455827942.png](./pic/image_course_1653_user_3165_assignment_16606_1695455827942.png)

![image_course_1653_user_3165_assignment_16606_1695457021760.png](./pic/image_course_1653_user_3165_assignment_16606_1695457021760.png)

2、在JavaRedis类中编写如下代码

```markup
package com.study;

import redis.clients.jedis.Jedis;
public class JavaRedis {
    public static void main(String[] args) {
        //连接本地的 Redis 服务
        Jedis jedis = new Jedis("10.2.92.3");
        // 如果 Redis 服务设置了密码，需要下面这行，没有就不需要
        jedis.auth("123456");
        System.out.println("连接成功");
        //查看服务是否运行
        System.out.println("服务正在运行: "+jedis.ping());
    }
}


```

![image_course_1653_user_3165_assignment_16606_1695455899248.png](./pic/image_course_1653_user_3165_assignment_16606_1695455899248.png)

3、在代码处点击右键运行Run as->Java Application

![image_course_1653_user_3165_assignment_16606_1695455927224.png](./pic/image_course_1653_user_3165_assignment_16606_1695455927224.png)

4.  执行结果，可以看到已成功连接到Redis服务

![image_course_1653_user_3165_assignment_16606_1695455982229.png](./pic/image_course_1653_user_3165_assignment_16606_1695455982229.png)

三、Redis字符串操作

1、在工程中创建类文件RedisStringJava。右键com.study包目录，创建RedisStringJava类

![image_course_1653_user_3165_assignment_16606_1695456003571.png](./pic/image_course_1653_user_3165_assignment_16606_1695456003571.png)

2、在RedisStringJava 类中编写如下代码

```markup
package com.study;

import redis.clients.jedis.Jedis;
public class RedisStringJava {
    public static void main(String[] args) {
        //连接本地的 Redis 服务
        Jedis jedis = new Jedis("10.2.92.3");
        // 如果 Redis 服务设置了密码，需要下面这行，没有就不需要
        jedis.auth("123456");
        System.out.println("连接成功");
        //设置 redis 字符串数据
        jedis.set("testkey", "测试value");
        // 获取存储的数据并输出
        System.out.println("redis 存储的字符串为: "+ jedis.get("testkey"));
    }
}

```

![image_course_1653_user_3165_assignment_16606_1695456032551.png](./pic/image_course_1653_user_3165_assignment_16606_1695456032551.png)

3、右键执行

![image_course_1653_user_3165_assignment_16606_1695456141840.png](./pic/image_course_1653_user_3165_assignment_16606_1695456141840.png)

4、查看结果，可以看到redis键值设置成功。

![image_course_1653_user_3165_assignment_16606_1695456175555.png](./pic/image_course_1653_user_3165_assignment_16606_1695456175555.png)

### **实验总结**

本实验的主要内容是基于Java完成Redis数据库的连接 及字符串操作，经过本实验，可以快速将Redis整合到工程项目中。更多操作，如Java对列表、集合等的操作，读者可以根据官网进行拓展。