### **实验目的**

掌握Redis主从模式的部署方式

### **实验背景**

Redis是一种非关系型数据库，是一个高性能的key-value数据库。它支持主从同步，数据可以由主服务器向从服务器同步，从服务器也可以关联其他从服务器的主服务器。本实验主要介绍Ubuntu操作系统下Redis主从模式配置部署方式。

### **实验原理**

实现主从复制（Master-Slave Replication）的工作原理：Slave从节点服务启动并连接到Master之后，它将主动发送一个SYNC命令。Master服务主节点收到同步命令后将启动后台存盘进程，同时收集所有接收到的用于修改数据集的命令，在后台进程执行完毕后，Master将传送整个数据库文件到Slave，以完成一次完全同步。而Slave从节点服务在接收到数据库文件数据之后将其存盘并加载到内存中。此后，Master主节点继续将所有已经收集到的修改命令，和新的修改命令依次传送给Slave，Slave将在本地执行这些数据修改命令，从而达到最终的数据同步。

### **实验环境**

Ubuntu 18.04

redis 7.0.12

### **建议课时**

2课时

### **实验步骤**

一、主服务器Master配置

1、选择实验机中master主机

![10.1master.jpg](./pic/10.1master.jpg)

2、使用ifconfig命令查看Master主服务器ip地址，记录下来用于修改redis配置文件。此处主服务器IP地址为 10.2.33.4（实际实验中，需要记录自己查出的IP地址信息）

```markup
ifconfig

```

![image_course_1653_user_3165_assignment_16607_1695282933456.png](./pic/image_course_1653_user_3165_assignment_16607_1695282933456.png)

3、修改Master的配置文件 使用 sudo vi /etc/redis/redis.conf 命令打开配置文件

(1)、上一步我们查到master的IP地址为10.2.33.4，此处我们将配置文件中 #bind 127.0.0.1 修改为Master服务器的bind 10.2.33.4。

```markup
sudo vi /opt/redis/redis.conf

```

```markup
bind 10.2.33.4

```

![image_course_1653_user_3165_assignment_16607_1695281768313.png](./pic/image_course_1653_user_3165_assignment_16607_1695281768313.png)

(2)、将Redis server的保护模式由yes改为设置为no。

![image_course_1653_user_3165_assignment_16607_1695281816230.png](./pic/image_course_1653_user_3165_assignment_16607_1695281816230.png)

(3)、将Redis server的demonize由no改为设置为yes。

![image_course_1653_user_3165_assignment_16607_1695281949737.png](./pic/image_course_1653_user_3165_assignment_16607_1695281949737.png)

(4)、并在文件末尾为Redis添加授权码123456。

```python
requirepass 123456
```

![image_course_1653_user_3165_assignment_16607_1695283541262.png](./pic/image_course_1653_user_3165_assignment_16607_1695283541262.png)

4、保存配置文件，启动redis

```markup
redis-server /opt/redis/redis.conf

```

5、用redis-cli工具验证redis服务可用性，主服务器配置完毕。

```python
redis-cli -h 10.2.33.4 -p 6379 -a '123456'
```

![image_course_1653_user_3165_assignment_16607_1695283668333.png](./pic/image_course_1653_user_3165_assignment_16607_1695283668333.png)

二、从服务Slave配置

1、选择实验机中的slave主机

![10.1slave.jpg](./pic/10.1slave.jpg)

2、使用ifconfig命令查看slave服务器ip地址，记录下来用于修改redis配置文件。此实验中主服务器IP地址为 10.2.33.2（实际实验中，需要记录自己查出的IP地址信息）

```markup
ifconfig

```

![image_course_1653_user_3165_assignment_16607_1695283710415.png](./pic/image_course_1653_user_3165_assignment_16607_1695283710415.png)

3、使用ping命令查看slave主机与Master主机之间是否可通信。本实验中，Master主机IP地址10.2.33.4。

```markup
ping -c 3 10.2.33.4

```

![image_course_1653_user_3165_assignment_16607_1695284003833.png](./pic/image_course_1653_user_3165_assignment_16607_1695284003833.png)

能ping通说明网络正常。

4、修改Slave的配置文件sudo vi /opt/redis/redis.conf。

(1)、将配置文件中 #bind 127.0.0.1 修改为绑定Slave服务器的IP地址。此处为改为 bind 10.2.33.2（实际实验中，需配置为根据二（2）步骤中查出的IP地址） ，由于主服务设置了密码，从服务还得配置主服务的授权，使用masterauth进行配置

```markup
sudo vi /opt/redis/redis.conf

```

```markup
bind 10.2.33.2

```

![image_course_1653_user_3165_assignment_16607_1695284310927.png](./pic/image_course_1653_user_3165_assignment_16607_1695284310927.png)

(2)、将Redis server的保护模式由yes改为设置为no。

![image_course_1653_user_3165_assignment_16607_1695281816230.png](./pic/image_course_1653_user_3165_assignment_16607_1695281816230.png)

(3)、将Redis server的demonize由no改为设置为yes。

![image_course_1653_user_3165_assignment_16607_1695281949737.png](./pic/image_course_1653_user_3165_assignment_16607_1695281949737.png)

(4)、并在文件末尾为Redis添加授权码123456。

```python
requirepass 123456
masterauth 123456
slaveof 10.2.33.4 6379
```

4、保存配置文件，启动redis

```markup
redis-server /opt/redis/redis.conf

```

5、用redis-cli工具验证redis服务可用性，主服务器配置完毕。

```python
redis-cli -h 10.2.33.4 -p 6379 -a '123456'
```

![image_course_1653_user_3165_assignment_16607_1695283668333.png](./pic/image_course_1653_user_3165_assignment_16607_1695283668333.png)

三、验证主从模式是否部署成功

1、在从服务器下，使用redis-cli -h IP地址 -p 端口号 -a 密码命令打开slave服务器的Redis客户端 ，本实验中，slave服务器IP地址是10.2.33.2，使用命令如下 redis-cli -h 10.2.93.2 -p 6379 -a "123456" 打开。（实际实验中，请根据自己查到的IP地址修改命令）

```markup
redis-cli -h 10.2.33.2 -p 6379 -a "123456" 

```

![image_course_1653_user_3165_assignment_16607_1695285917113.png](./pic/image_course_1653_user_3165_assignment_16607_1695285917113.png)

2、使用info Replication命令查看主从配置情况，如下从机出现master\_link\_status:up提示则表示Redis主从配置关联成功

```markup
info Replication

```

![image_course_1653_user_3165_assignment_16607_1695282678002.png](./pic/image_course_1653_user_3165_assignment_16607_1695282678002.png)

### **实验总结**

本实验讲解了在Ubuntu下完成Redis的主从配置模式的部署，主要通过修改主从服务器的配置文件来完成相主从模式的部署，更多主从模式内容，可通过官方网站扩展。