### **实验目的**

掌握Redis哨兵模式的部署方式

### **实验背景**

Redis是一种非关系型数据库，是一个高性能的key-value数据库。它支持主从同步，数据可以由主服务器向从服务器同步，从服务器也可以关联其他从服务器的主服务器。Redis 哨兵模式（Sentinel）是Redis的高可用性解决方案。由一个或多个Sentinel实例组成的Sentinel系统可以监视任意多个主服务器，以及这些主服务器属下的所有从服务器，并在被监视的主服务器进入下线状态时，自动将下线主服务器属下的某个从服务器升级为新的主服务器。Sentinel 其实也是一个 Redis的服务端程序，它也会定时执行 serverCron 函数，只是里面其他的程序用不到，用到的是对普通 Redis节点的监控以及故障转移模块。

### **实验原理**

首先安装部署redis主从模式，其次主从服务器 分别安装redis-sentinel（哨兵），第三步主从服务上都配一个哨兵程序，第四步重启哨兵进程，即可完成哨兵模式搭建

### **实验环境**

Ubuntu 18.04

redis 7.0.12

### **建议课时**

3课时

### **实验步骤**

一、主服务器Master配置

1.  选择实验机中master主机

![master1.jpg](./pic/master1.jpg)

2.  使用ifconfig命令查看Master主服务器ip地址，记录下来用于修改redis配置文件。此处主服务器IP地址为 10.2.28.3（实际实验中，需要记录自己查出的IP地址信息）

```markup
ifconfig

```

3.  修改Master的配置文件 使用 sudo vi /opt/redis/redis.conf 命令打开配置文件

上一步我们查到master的IP地址为10.2.28.3，此处我们将配置文件中 #bind 127.0.0.1 修改为Master服务器的bind 10.2.28.3

```markup
sudo vi /opt/redis/redis.conf

```

```markup
bind 10.2.28.3

```

![1.jpg](./pic/1.jpg)

将Redis server的保护模式由yes改为设置为no。

![image_course_1653_user_3165_assignment_16608_1695287262787.png](./pic/image_course_1653_user_3165_assignment_16608_1695287262787.png)

将Redis server的demonize由no改为设置为yes。

![image_course_1653_user_3165_assignment_16608_1695287295583.png](./pic/image_course_1653_user_3165_assignment_16608_1695287295583.png)

在文件末尾添加Redis授权码123456

```python
requirepass 123456
```

![image_course_1653_user_3165_assignment_16608_1695286971385.png](./pic/image_course_1653_user_3165_assignment_16608_1695286971385.png)

4、保存配置文件，启动redis。启动之后查看redis服务状态

```markup
redis-server /opt/redis/redis.conf

```

用redis-cli工具验证redis服务可用性，主服务器配置完毕。（注意：该IP需要改成你的Master机器ifconfig里显示出的IP）

```python
redis-cli -h 10.2.28.3 -p 6379 -a '123456'
```

![2.jpg](./pic/2.jpg)

二、主服务器安装哨兵

1、安装redis-sentinel（哨兵），

```python
sudo apt-get update
```

使用命令为sudo apt-get install redis-sentinel

```markup
sudo apt-get install redis-sentinel

```

![masterinstallS.jpg](./pic/masterinstallS.jpg)

2、配置哨兵模式，使用sudo vim /etc/redis/sentinel.conf进行编辑配置文件，分别取消仅支持本地连接、设置主节点（设置主节点（实际实验中，需配置为根据一（2）步骤中查出的IP地址））、设置密码。

```markup
sudo vim /etc/redis/sentinel.conf

```

```markup
#bind 127.0.0.1

```

修改内容如下：（注意：IP需要改成实际的master和slave的IP地址）

```markup
sentinel monitor mymaster 10.2.28.3 6379 1
sentinel auth-pass mymaster 123456
sentinel config-epoch mymaster 2
sentinel known-slave mymaster 10.2.28.2 6379

```

![senti1Bind.jpg](./pic/senti1Bind.jpg)

将protected-mode设为no：

![image_course_1653_user_3165_assignment_16608_1695301573843.png](./pic/image_course_1653_user_3165_assignment_16608_1695301573843.png)

![3.jpg](./pic/3.jpg)

3、使用sudo service redis-sentinel restart命令重启哨兵进程，再使用sudo service redis-sentinel status命令查看哨兵进程是否正在运行，若为active (running)状态则表示哨兵进程正常启动，配置完成

```markup
sudo service redis-sentinel start

```

```markup
sudo service redis-sentinel status

```

![mSenStart.jpg](./pic/mSenStart.jpg)

三、从服务Slave配置

1.  选择实验机中的slave主机
    
    ![slave1.jpg](./pic/slave1.jpg)
    
2.  使用ifconfig命令查看slave服务器ip地址，记录下来用于修改redis配置文件。此实验中主服务器IP地址为 10.2.28.3（实际实验中，需要记录自己查出的IP地址信息）
    

```markup
ifconfig

```

3.使用ping命令查看slave主机与Master主机之间是否可通信。本实验中，Master主机IP地址10.2.28.3。

```python
ping -c 3 10.2.28.3

```

![4.jpg](./pic/4.jpg)

4.修改Slave的配置文件sudo vi /opt/redis/redis.conf。

将配置文件中 #bind 127.0.0.1 修改为绑定Slave服务器的IP地址。此处为改为 bind 10.2.28.2（实际实验中，需配置为根据三（2）步骤中查出的IP地址） ，由于主服务设置了密码，从服务还得配置主服务的授权，使用masterauth进行配置

```markup
sudo vi /opt/redis/redis.conf

```

```markup
bind 10.2.28.2

```

将Redis server的保护模式由yes改为设置为no。

![image_course_1653_user_3165_assignment_16608_1695287262787.png](./pic/image_course_1653_user_3165_assignment_16608_1695287262787.png)

将Redis server的demonize由no改为设置为yes。

![image_course_1653_user_3165_assignment_16608_1695287295583.png](./pic/image_course_1653_user_3165_assignment_16608_1695287295583.png)

在文件末尾添加Redis授权码123456

```markup
requirepass 123456
masterauth 123456
slaveof 10.2.28.3 6379

```

![5.jpg](./pic/5.jpg)

![6.jpg](./pic/6.jpg)

5.  保存配置文件，启动redis。启动之后查看redis服务状态

```markup
redis-server /opt/redis/redis.conf

```

用redis-cli工具验证redis服务可用性，主服务器配置完毕。

```python
redis-cli -h 10.2.28.3 -p 6379 -a '123456'
```

![7.jpg](./pic/7.jpg)

四、从服务器安装哨兵

1、安装redis-sentinel（哨兵），使用命令为

```python
sudo apt-get update
```

```markup
sudo apt-get install redis-sentinel
```

![Sseninstall.jpg](./pic/Sseninstall.jpg)

2、配置哨兵模式，使用sudo vim /etc/redis/sentinel.conf进行编辑配置文件，分别取消仅支持本地连接、设置主节点（实际实验中，需配置为根据一（2）步骤中查出的IP地址）、设置密码。

```markup
sudo vim /etc/redis/sentinel.conf

```

```markup
#bind 127.0.0.1

```

```markup
sentinel monitor mymaster 10.2.28.3 6379 1
sentinel auth-pass mymaster 123456
sentinel config-epoch mymaster 2
sentinel known-slave mymaster 10.2.28.2 6379

```

![senti1Bind.jpg](./pic/senti1Bind.jpg)

将protected-mode设为no：

![image_course_1653_user_3165_assignment_16608_1695301573843.png](./pic/image_course_1653_user_3165_assignment_16608_1695301573843.png)

![8.jpg](./pic/8.jpg)

修改已知slave的IP地址时注意IP需要改成slave的IP地址。

3、使用sudo service redis-sentinel restart命令重启哨兵进程，再使用sudo service redis-sentinel status命令查看哨兵进程是否正在运行，若为active (running)状态则表示哨兵进程正常启动，配置完成

```markup
sudo service redis-sentinel start

```

```markup
sudo service redis-sentinel status

```

![S1start.jpg](./pic/S1start.jpg)

五、哨兵模式实践

1.切换到主服务器

![master1.jpg](./pic/master1.jpg)

2.查看Master状态，使用主服务器连接Redis，并查看Master信息，该Master的名称是mymaster ，ip是配置的10.2.28.3，是我们第一步中配置的主服务器。

```markup
redis-cli -h 10.2.28.3 -p 26379

```

```markup
sentinel master mymaster

```

![9.jpg](./pic/9.jpg)

2)查看Slave状态，可以看到，从服务器是我们第三步配置的10.2.28.2。

```markup
sentinel slaves mymaster

```

![10.jpg](./pic/10.jpg)

3)查看哨兵状态，主服务有个10.2.28.2的哨兵在监听。

```markup
sentinel sentinels mymaster

```

![11.jpg](./pic/11.jpg)

4、进入redis-cli关闭主Redis服务。

```markup
redis-cli -h 10.2.28.3 -p 6379 -a '123456' 

```

![12.jpg](./pic/12.jpg)

说明此时master服务器的Redis服务已经停掉。

5、再次登录哨兵系统，查询状态，此时主从服务自动切换，主服务变成了之前的从服务器10.2.28.2，说明通过哨兵模式能够自动完成主从服务的切换。

```markup
redis-cli -h 10.2.28.3 -p 26379 

```

```markup
sentinel master mymaster

```

![13.jpg](./pic/13.jpg)

### **实验总结**

本实验讲解了在Ubuntu下完成Redis的哨兵配置模式的部署，主要通过修改主从服务器安装哨兵并配置哨兵配置文件来完成哨兵模式的部署，更多哨兵模式内容，可通过官方网站扩展。