### **实验目的**

1、掌握Hadoop，Hbase以及thrift服务的启动；

2、掌握python连接MySQL，了解python操作MySQL数据；

3、掌握python实现MySQL数据导入HBase；

4、熟悉python操作Hbase

### **实验背景**

以学生课程成绩为例，将实体和实体间的关系都存在MySQL数据库中，实体有学生和课程，分别对应学生信息表studentinfo和课程信息表courseinfo，实体之间的关系为选课及成绩，对应成绩表gradeinfo，这三张表的结构如图所示。

![MySQL中的表结构.png](./pic/MySQL中的表结构.png)

如果还是以三张表的形式存储数据到HBase中并没有任何意义，因为HBase有列族的概念，可以将三张表的数据整合到HBase的一张表中，HBase中表的逻辑结构如图所示。

![HBase表逻辑结构-1.png](./pic/HBase表逻辑结构-1.png)

### **实验原理**

HBase表将MySQL三张表的数据聚合到一张表中，studentinfo表映射到HBase的Stuinfo列族，gradeinfo和courseinfo表信息映射到Grades列族中，使用HBase列族形式将数据整合到一起，查询起来更加方便，同时对出现大量空值的场景，可以节约大量的存储空间。

### **实验环境**

ubuntu18.04

python3.9

hbase 2.4.17

mysql5.7.28

### **建议课时**

4课时

### **实验步骤**

一、源数据准备以及实验环境配置

1、获取数据源：

```markup
cd ~
wget http://10.90.3.2/HUP/NoSQL/WinQSB/coursesel.sql

```

（1）登陆MySQL，建立空数据库，输入密码，默认为“123456”

```markup
mysql -u root -p

```

（2）在mysqlshell中创建数据库，如下：

```markup
create database coursesel;

```

（3）导入数据

```markup
use coursesel;
source coursesel.sql;

```

（4）查看数据是否导入

```markup
show tables;

```

![mysql表.png](./pic/mysql表.png)

2、 实验运行环境配置

（1）将Hbase安装包（/opt/hbase）复制到python的site-package路径(/usr/local/python3.9.17/lib/python3.9/site-packages)下

（2）相关库包下载

```markup
pip install pymysql==1.1.0
pip install thrift==0.16.0
pip install hbase-thrift==0.20.4

```

python连接hbase需要使用thrift，且需要将thrift生成的hbase.py和ttypes.py覆盖python hbase库对应的文件。thrift生成的hbase.py和ttypes.py文件获取方式如下：

```markup
wget http://10.90.3.2/HUP/NoSQL/WinQSB/Hbase.py
wget http://10.90.3.2/HUP/NoSQL/WinQSB/ttypes.py

```

使用以下命令，替换hbase库中的这两个文件，使用命令如下：

```markup
sudo cp Hbase.py /usr/local/python3.9.17/lib/python3.9/site-packages/hbase
sudo cp ttypes.py /usr/local/python3.9.17/lib/python3.9/site-packages/hbase/

```

二、Python读取MySQL

1.在终端使用jupyter notebook 命令打开jupyter，并新建python文件，命名为mysqltest

```markup
jupyter notebook

```

![jupyter 界面.png](./pic/jupyter 界面.png)

2.python操作MySQL

（1）Python连接MySQL，其中第一个参数localhost为本地数据库，如果远程数据库可使用ip:port形式，例如“10.100.9.33:3306”。接下来两个参数分别为连接数据库的用户名和密码，最后一个为具体数据库名。

```markup
#导包
import pymysql
# 打开mysql数据库连接
db = pymysql.connect(host="localhost", user="root", password="123456",database= "coursesel")

```

（2）获取学生基本信息。

```markup
# 使用 cursor() 方法创建一个游标对象 cursor
cursor = db.cursor()
# 执行SQL语句
cursor.execute("SELECT * FROM studentinfo")
# 获取所有记录列表
stuInfo = cursor.fetchall()
print(stuInfo)

```

完整代码及结果如图所示

![学生基本信息.png](./pic/学生基本信息.png)

（3）获取课程信息。

fatchall方法获取查询的结果，返回的sutinfo为list结构，存储多行数据。然后针对每个学生从gradeinfo和courseinfo表中获取课程信息，代码如下：

```markup
for row in stuInfo:
    id = row[0]
    name = row[1]
    age = row[2]
    sex = row[3]
    # 根据学号查询该学生所选课程的相关信息
    sqlCourse = "SELECT courseinfo.课程名,gradeinfo.成绩  " \
                "FROM studentinfo,courseinfo,gradeinfo  " \
                "WHERE studentinfo.学号=gradeinfo.学号  " \
                "and courseinfo.课程号=gradeinfo.课程号 " \
                "and studentinfo.学号='%s'" % (id)
    cursor1 = db.cursor()
    cursor1.execute(sqlCourse)
    courses = cursor1.fetchall()
    print(courses)

```

经过此查询后可以获取每个学生的选课信息和成绩，显示结果如图所示：

![课程基本信息.png](./pic/课程基本信息.png)

三、启动hbase以及thrift服务器

1.启动hbase前先启动hadoop

```markup
cd /opt/hadoop/sbin
hdfs namenode -format
./start-all.sh

```

2.启动hbase

```markup
cd /opt/hbase/bin/
./start-hbase.sh

```

3、启动thrift服务器

```markup
./hbase-daemon.sh start thrift

```

![服务启动.png](./pic/服务启动.png)

四、将数据从MySQL导入HBase 中

1.在jupyter中在新建一个python文件，文件名为putHbase，在putHbase文件中导入相应的库包：

```markup
from thrift.transport import TSocket
from hbase import Hbase
from hbase.ttypes import *
import pymysql

```

2.连接HBase，使用以下代码连接HBase数据库以及创建表，其中，Tsocket()方法中的第一个参数host为HBase服务器地址，9090为HBase启动的默认端口号。使用HBase.Client创建Client对象：

```markup
transport = TSocket.TSocket('localhost', 9090)
protocol = TBinaryProtocol.TBinaryProtocol(transport)
client = Hbase.Client(protocol)
transport.open()

```

3.连接HBase后，创建表结构：

```markup
#定义列族
cf1 = ColumnDescriptor(name='stuInfo')
cf2 = ColumnDescriptor(name='Grades')
#建立表结构
try:
    # 判断表是否存在
    tables_list = client.getTableNames()
    if "courseGrade" in tables_list:
        #如果表存在则删除重新建立
        client.disableTable('courseGrade')
        client.deleteTable('courseGrade')
        client.createTable('courseGrade', [cf1, cf2])
    else:
        # 如果不存在，则创建表
        client.createTable('courseGrade', [cf1, cf2])
except:
    print("创建表失败！")

```

首先使用ColumnDescripto()方法描述一个列族，第一个参数为列族名，还可以增加其他参数，如设置最大保存版本数maxVersions。使用createTable()方法创建表，第一个参数为表名，第二个参数为列族列表。

4.向列族中插入数据，数据来源与mysql数据库中，读取mysql代码如下：

```markup
# 打开mysql数据库连接
db = pymysql.connect(host="localhost", user="root", password="123456", database="coursesel")
# 使用 cursor() 方法创建一个游标对象 cursor
cursor = db.cursor()
cursor1 = db.cursor()
# SQL 查询学生表信息
sqlStu = "SELECT * FROM studentinfo"
try:
    # 执行SQL语句
    cursor.execute(sqlStu)
    # 获取所有记录列表
    stuInfo = cursor.fetchall()
    for row in stuInfo:
        id = row[0]
        name = row[1]
        age = row[2]
        sex = row[3]
        
        #根据学号查询该学生所选课程的相关信息
        sqlCourse = "SELECT courseinfo.课程名,gradeinfo.成绩 " \
                    "FROM studentinfo,courseinfo,gradeinfo " \
                    "WHERE studentinfo.学号=gradeinfo.学号 " \
                    "and courseinfo.课程号=gradeinfo.课程号 and studentinfo.学号='%d'" %(id)
        cursor1.execute(sqlCourse)
        # 获取所有记录列表
        courses = cursor1.fetchall()
        
        #插入HBase courseGrade表的stuInfo列族
        # 代码圈1在下面
        #-------------------
            
        #-------------------
        
        for course in courses:
            courseName = course[0]
            score = course[1]
            # 插入HBase courseGrade表的Grades列族
            # 代码圈2 在下面
            #-------------------
            
            #-------------------
        # 查询数据并输出
        # 代码圈3 在下面
        # ------------
        
        # ------------
        result = client.getRow('courseGrade', str(id))
        print(result)
except Exception as err:
    print(err)

```

填补空缺代码：

代码圈1部分：

使用mutateRow()方法插入一个逻辑行，对应多个列：

```markup
        #插入HBase courseGrade表的stuInfo列族
        # 代码圈1在下面
        #-------------------
        mutations = [Mutation(column="stuInfo:name", value = name),
        Mutation(column="stuInfo:age", value = str(age)),
        Mutation(column="stuInfo:sex", value = str(sex))]
        client.mutateRow('courseGrade', str(id), mutations)   
        #-------------------

```

mutateRow()方法的第一个参数为文本类型的表名，第二个参数为文本类型的行键，第三个参数为文本类型的列值列表，后面还可以设置JSON格式的可选属性。

代码圈2部分：

用同样的方式将学生的选课信息插入Grades列族：

```markup
            # 插入HBase courseGrade表的Grades列族
            # 代码圈2 在下面
            #-------------------
            mutations = [Mutation(column="Grades:'%s'"%(courseName), value=str(score))]
            client.mutateRow('courseGrade', str(id), mutations)
            
            #-------------------

```

Grades列族中以courseName为列名，成绩score为具体单元格的值。

代码圈3部分：

现在可获取某个学生所选课程的成绩。以下示例表示获取指定id的学生的所有选课信息：

```python
        # 查询数据并输出
        # 代码圈3 在下面
        # ------------
        result = client.getRow('courseGrade', str(id))
        print(result)      
        # ------------

```

getRow()方法必须设定表名和行键，第一个参数为表名，第二参数为行键，HBase中所有的数据类型均为字符型。getRow()方法只能获取一个逻辑行的数据，并且必须指定行键，其他查询方法请查阅Python HBase API的相关文档。

查询结果如下：

![查询结果.png](./pic/查询结果.png)

完整代码如下：

```python
from thrift.transport import TSocket
from hbase import Hbase
from hbase.ttypes import *
import pymysql

# 打开hbase数据库连接
transport = TSocket.TSocket('localhost', 9090)
protocol = TBinaryProtocol.TBinaryProtocol(transport)
client = Hbase.Client(protocol)
transport.open()

#定义列族
cf1 = ColumnDescriptor(name='stuInfo')
cf2 = ColumnDescriptor(name='Grades')

#建立表结构
try:
    # 判断表是否存在
    tables_list = client.getTableNames()
    if "courseGrade" in tables_list:
        #如果表存在则删除重新建立
        client.disableTable('courseGrade')
        client.deleteTable('courseGrade')
        client.createTable('courseGrade', [cf1, cf2])
    else:
        # 如果不存在，则创建表
        client.createTable('courseGrade', [cf1, cf2])
except:
    print("创建表失败！")

# 打开mysql数据库连接
db = pymysql.connect(host="localhost", user="root", password="123456", database="coursesel")
# 使用 cursor() 方法创建一个游标对象 cursor
cursor = db.cursor()
cursor1 = db.cursor()
# SQL 查询学生表信息
sqlStu = "SELECT * FROM studentinfo"
try:
    # 执行SQL语句
    cursor.execute(sqlStu)
    # 获取所有记录列表
    stuInfo = cursor.fetchall()
    for row in stuInfo:
        id = row[0]
        name = row[1]
        age = row[2]
        sex = row[3]

        #根据学号查询该学生所选课程的相关信息
        sqlCourse = "SELECT courseinfo.课程名,gradeinfo.成绩 " \
                    "FROM studentinfo,courseinfo,gradeinfo " \
                    "WHERE studentinfo.学号=gradeinfo.学号 " \
                    "and courseinfo.课程号=gradeinfo.课程号 and studentinfo.学号='%d'" %(id)
        cursor1.execute(sqlCourse)
        # 获取所有记录列表
        courses = cursor1.fetchall()
        
                #插入HBase courseGrade表的stuInfo列族
        # 代码圈1在下面
        #-------------------
        mutations = [Mutation(column="stuInfo:name", value = name),
        Mutation(column="stuInfo:age", value = str(age)),
        Mutation(column="stuInfo:sex", value = str(sex))]
        client.mutateRow('courseGrade', str(id), mutations)   
        #-------------------
        
        for course in courses:
            courseName = course[0]
            score = course[1]
            # 插入HBase courseGrade表的Grades列族
            # 代码圈2 在下面
            #-------------------
            mutations = [Mutation(column="Grades:'%s'"%(courseName), value=str(score))]
            client.mutateRow('courseGrade', str(id), mutations)
            
            #-------------------
            
        # 查询数据并输出
        # 代码圈3 在下面
        # ------------
        result = client.getRow('courseGrade', str(id))
        print(result)      
        # ------------
except Exception as err:
    print(err)

# 关闭数据库连接
transport.close()
db.close()

```

### **实验总结**

该实验通过实际的编程加深对HBase数据库结构的理解，掌握了python编程语言连接HBsae的方式，熟练使用python对数据库进行各种数据操作的方法。